/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.util;

import android.databinding.tool.reflection.Callable;
import android.databinding.tool.util.L;

public class BrNameUtil {
    private static String stripPrefixFromField(String name) {
        if (name.length() >= 2) {
            char firstChar = name.charAt(0);
            char secondChar = name.charAt(1);
            if (name.length() > 2 && firstChar == 'm' && secondChar == '_') {
                char thirdChar = name.charAt(2);
                if (Character.isJavaIdentifierStart(thirdChar)) {
                    return "" + Character.toLowerCase(thirdChar) + name.subSequence(3, name.length());
                }
            } else if (firstChar == 'm' && Character.isUpperCase(secondChar) || firstChar == '_' && Character.isJavaIdentifierStart(secondChar)) {
                return "" + Character.toLowerCase(secondChar) + name.subSequence(2, name.length());
            }
        }
        return name;
    }

    public static String brKey(Callable callable) {
        CharSequence propertyName;
        if (callable.type == Callable.Type.FIELD) {
            return BrNameUtil.stripPrefixFromField(callable.name);
        }
        String name = callable.name;
        if (BrNameUtil.isGetter(callable) || BrNameUtil.isSetter(callable)) {
            propertyName = name.subSequence(3, name.length());
        } else if (BrNameUtil.isBooleanGetter(callable)) {
            propertyName = name.subSequence(2, name.length());
        } else {
            L.e("@Bindable associated with method must follow JavaBeans convention %s", callable);
            return null;
        }
        char firstChar = propertyName.charAt(0);
        return "" + Character.toLowerCase(firstChar) + propertyName.subSequence(1, propertyName.length());
    }

    private static boolean isGetter(Callable callable) {
        return BrNameUtil.prefixes(callable.name, "get") && Character.isJavaIdentifierStart(callable.name.charAt(3)) && callable.getParameterCount() == 0 && !callable.resolvedType.isVoid();
    }

    private static boolean isSetter(Callable callable) {
        return BrNameUtil.prefixes(callable.name, "set") && Character.isJavaIdentifierStart(callable.name.charAt(3)) && callable.getParameterCount() == 1 && callable.resolvedType.isVoid();
    }

    private static boolean isBooleanGetter(Callable callable) {
        return BrNameUtil.prefixes(callable.name, "is") && Character.isJavaIdentifierStart(callable.name.charAt(2)) && callable.getParameterCount() == 0 && callable.resolvedType.isBoolean();
    }

    private static boolean prefixes(CharSequence sequence, String prefix) {
        boolean prefixes = false;
        if (sequence.length() > prefix.length()) {
            int count = prefix.length();
            prefixes = true;
            for (int i = 0; i < count; ++i) {
                if (sequence.charAt(i) == prefix.charAt(i)) continue;
                prefixes = false;
                break;
            }
        }
        return prefixes;
    }
}

