/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.job;

import com.oracle.javafx.scenebuilder.kit.editor.EditorController;
import com.oracle.javafx.scenebuilder.kit.editor.job.BatchSelectionJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.Job;
import com.oracle.javafx.scenebuilder.kit.editor.job.PrunePropertiesJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.AddPropertyJob;
import com.oracle.javafx.scenebuilder.kit.editor.job.atomic.AddPropertyValueJob;
import com.oracle.javafx.scenebuilder.kit.editor.selection.AbstractSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.editor.selection.ObjectSelectionGroup;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMCollection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import com.oracle.javafx.scenebuilder.kit.metadata.util.DesignHierarchyMask;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PropertyName;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class InsertAsAccessoryJob
extends BatchSelectionJob {
    private final FXOMObject newObject;
    private final FXOMObject targetObject;
    private final DesignHierarchyMask.Accessory accessory;

    public InsertAsAccessoryJob(FXOMObject newObject, FXOMObject targetObject, DesignHierarchyMask.Accessory accessory, EditorController editorController) {
        super(editorController);
        assert (newObject != null);
        assert (targetObject != null);
        assert (accessory != null);
        assert (newObject.getFxomDocument() == this.getEditorController().getFxomDocument());
        assert (targetObject.getFxomDocument() == this.getEditorController().getFxomDocument());
        this.newObject = newObject;
        this.targetObject = targetObject;
        this.accessory = accessory;
    }

    @Override
    protected List<Job> makeSubJobs() {
        DesignHierarchyMask mask;
        ArrayList<Job> result = new ArrayList<Job>();
        if (this.targetObject instanceof FXOMInstance && (mask = new DesignHierarchyMask(this.targetObject)).isAcceptingAccessory(this.accessory, this.newObject) && mask.getAccessory(this.accessory) == null) {
            PrunePropertiesJob pruneJob;
            FXOMDocument fxomDocument = this.getEditorController().getFxomDocument();
            FXOMInstance targetInstance = (FXOMInstance)this.targetObject;
            PropertyName accessoryName = mask.getPropertyNameForAccessory(this.accessory);
            assert (accessoryName != null);
            FXOMPropertyC targetProperty = new FXOMPropertyC(fxomDocument, accessoryName);
            AddPropertyValueJob addValueJob = new AddPropertyValueJob(this.newObject, targetProperty, -1, this.getEditorController());
            result.add(addValueJob);
            if (targetProperty.getParentInstance() == null) {
                assert (this.targetObject instanceof FXOMInstance);
                AddPropertyJob addPropertyJob = new AddPropertyJob(targetProperty, targetInstance, -1, this.getEditorController());
                result.add(addPropertyJob);
            }
            if (((Job)(pruneJob = new PrunePropertiesJob(this.newObject, this.targetObject, this.getEditorController()))).isExecutable()) {
                result.add(0, pruneJob);
            }
        }
        return result;
    }

    @Override
    protected String makeDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("Insert ");
        if (this.newObject instanceof FXOMInstance) {
            Object sceneGraphObject = this.newObject.getSceneGraphObject();
            if (sceneGraphObject != null) {
                sb.append(sceneGraphObject.getClass().getSimpleName());
            } else {
                sb.append("Unresolved Object");
            }
        } else if (this.newObject instanceof FXOMCollection) {
            sb.append("Collection");
        } else {
            assert (false);
            sb.append(this.newObject.getClass().getSimpleName());
        }
        String result = sb.toString();
        return result;
    }

    @Override
    protected AbstractSelectionGroup getNewSelectionGroup() {
        HashSet<FXOMObject> newObjects = new HashSet<FXOMObject>();
        newObjects.add(this.newObject);
        return new ObjectSelectionGroup(newObjects, this.newObject, null);
    }
}

