/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors;

import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.EditorUtils;
import com.oracle.javafx.scenebuilder.kit.editor.panel.inspector.editors.PropertyEditor;
import com.oracle.javafx.scenebuilder.kit.metadata.property.ValuePropertyMetadata;
import com.oracle.javafx.scenebuilder.kit.metadata.property.value.EnumerationPropertyMetadata;
import java.util.Set;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ChoiceBox;

public class EnumEditor
extends PropertyEditor {
    private final ChoiceBox<String> choiceBox = new ChoiceBox();

    public EnumEditor(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses) {
        super(propMeta, selectedClasses);
        this.choiceBox.disableProperty().bind((ObservableValue)this.disableProperty());
        EditorUtils.makeWidthStretchable(this.choiceBox);
        this.choiceBox.getSelectionModel().selectedItemProperty().addListener(o -> {
            if (!this.isUpdateFromModel()) {
                this.userUpdateValueProperty(this.getValue());
            }
        });
        this.initialize();
    }

    private void initialize() {
        this.updateItems();
    }

    @Override
    public Node getValueEditor() {
        return super.handleGenericModes((Node)this.choiceBox);
    }

    @Override
    public Object getValue() {
        return this.choiceBox.getSelectionModel().getSelectedItem();
    }

    @Override
    public void setValue(Object value) {
        this.setValueGeneric(value);
        if (this.isSetValueDone()) {
            return;
        }
        if (value != null) {
            this.choiceBox.getSelectionModel().select((Object)value.toString());
        } else {
            this.choiceBox.getSelectionModel().clearSelection();
        }
    }

    @Override
    public void reset(ValuePropertyMetadata propMeta, Set<Class<?>> selectedClasses) {
        super.reset(propMeta, selectedClasses);
        this.updateItems();
    }

    @Override
    protected void valueIsIndeterminate() {
        EnumEditor.handleIndeterminate(this.choiceBox);
    }

    protected ChoiceBox<String> getChoiceBox() {
        return this.choiceBox;
    }

    protected void updateItems() {
        assert (this.getPropertyMeta() instanceof EnumerationPropertyMetadata);
        EnumerationPropertyMetadata enumPropMeta = (EnumerationPropertyMetadata)this.getPropertyMeta();
        this.choiceBox.getItems().clear();
        for (String val : enumPropMeta.getValidValues()) {
            this.choiceBox.getItems().add((Object)val.toString());
        }
    }

    @Override
    public void requestFocus() {
        EditorUtils.doNextFrame(() -> this.choiceBox.requestFocus());
    }
}

