/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.panel.util.dialog;

import com.oracle.javafx.scenebuilder.kit.editor.panel.util.dialog.AbstractModalDialog;
import java.net.URL;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.stage.Window;

public class AlertDialog
extends AbstractModalDialog {
    @FXML
    protected Label messageLabel;
    @FXML
    protected Label detailsLabel;
    private Runnable actionRunnable;
    private static Image dialogImage;

    public AlertDialog(Window owner) {
        super(AlertDialog.class.getResource("AlertDialog.fxml"), null, owner);
        this.getStage().setResizable(false);
        this.setImageViewVisible(true);
        this.setImageViewImage(AlertDialog.getDialogImage());
    }

    public String getMessage() {
        return this.getMessageLabel().getText();
    }

    public void setMessage(String message) {
        this.getMessageLabel().setText(message);
    }

    public String getDetails() {
        return this.getDetailsLabel().getText();
    }

    public void setDetails(String details) {
        this.getDetailsLabel().setText(details);
    }

    public void setActionRunnable(Runnable runnable) {
        this.actionRunnable = runnable;
    }

    @Override
    public void controllerDidLoadContentFxml() {
        assert (this.messageLabel != null);
        assert (this.detailsLabel != null);
        this.messageLabel.setText(null);
        this.detailsLabel.setText(null);
    }

    @Override
    public void okButtonPressed(ActionEvent e) {
        this.getStage().close();
    }

    @Override
    public void cancelButtonPressed(ActionEvent e) {
        this.getStage().close();
    }

    @Override
    public void actionButtonPressed(ActionEvent e) {
        if (this.actionRunnable != null) {
            this.actionRunnable.run();
        } else {
            this.getStage().close();
        }
    }

    private Label getMessageLabel() {
        this.getContentRoot();
        return this.messageLabel;
    }

    private Label getDetailsLabel() {
        this.getContentRoot();
        return this.detailsLabel;
    }

    private static synchronized Image getDialogImage() {
        if (dialogImage == null) {
            URL dialogImageURL = AlertDialog.class.getResource("alert-question-mark.png");
            dialogImage = new Image(dialogImageURL.toExternalForm());
        }
        return dialogImage;
    }
}

