/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.editor.report;

import com.oracle.javafx.scenebuilder.kit.editor.report.CSSParsingReport;
import com.oracle.javafx.scenebuilder.kit.editor.report.ErrorReportEntry;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMAssetIndex;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMCollection;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMDocument;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMInstance;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMIntrinsic;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMNode;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMNodes;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMObject;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMProperty;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyC;
import com.oracle.javafx.scenebuilder.kit.fxom.FXOMPropertyT;
import com.oracle.javafx.scenebuilder.kit.metadata.util.PrefixedValue;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ErrorReport {
    private final Map<FXOMNode, List<ErrorReportEntry>> entries = new HashMap<FXOMNode, List<ErrorReportEntry>>();
    private final Map<Path, CSSParsingReport> cssParsingReports = new HashMap<Path, CSSParsingReport>();
    private FXOMDocument fxomDocument;
    private boolean dirty = true;

    public void setFxomDocument(FXOMDocument fxomDocument) {
        this.fxomDocument = fxomDocument;
        this.forget();
    }

    public void forget() {
        this.entries.clear();
        this.dirty = true;
    }

    public List<ErrorReportEntry> query(FXOMObject fxomObject, boolean recursive) {
        this.updateReport();
        ArrayList<ErrorReportEntry> collected = new ArrayList<ErrorReportEntry>();
        if (recursive) {
            this.collectEntries(fxomObject, collected);
        } else {
            if (this.entries.get(fxomObject) != null) {
                collected.addAll((Collection<ErrorReportEntry>)this.entries.get(fxomObject));
            }
            if (fxomObject instanceof FXOMInstance) {
                FXOMInstance fxomInstance = (FXOMInstance)fxomObject;
                for (FXOMProperty fxomProperty : fxomInstance.getProperties().values()) {
                    if (this.entries.get(fxomProperty) == null) continue;
                    collected.addAll((Collection<ErrorReportEntry>)this.entries.get(fxomProperty));
                }
            }
        }
        ArrayList<ErrorReportEntry> result = collected.isEmpty() ? null : collected;
        assert (result == null || result.size() >= 1);
        return result;
    }

    public Map<FXOMNode, List<ErrorReportEntry>> getEntries() {
        this.updateReport();
        return Collections.unmodifiableMap(this.entries);
    }

    public void cssFileDidChange(Path cssPath) {
        if (this.cssParsingReports.containsKey(cssPath)) {
            this.cssParsingReports.remove(cssPath);
            this.forget();
        }
    }

    private void updateReport() {
        if (this.dirty) {
            assert (this.entries.isEmpty());
            if (this.fxomDocument != null) {
                this.verifyAssets();
                this.verifyUnresolvedObjects();
                this.verifyBindingExpressions();
            }
            this.dirty = false;
        }
    }

    private void verifyAssets() {
        FXOMAssetIndex assetIndex = new FXOMAssetIndex(this.fxomDocument);
        for (Map.Entry<Path, FXOMNode> e : assetIndex.getFileAssets().entrySet()) {
            Path assetPath = e.getKey();
            if (!assetPath.toFile().canRead()) {
                ErrorReportEntry newEntry = new ErrorReportEntry(e.getValue(), ErrorReportEntry.Type.UNRESOLVED_LOCATION);
                this.addEntry(e.getValue(), newEntry);
                continue;
            }
            String assetPathName = assetPath.toString();
            if (!assetPathName.toLowerCase(Locale.ROOT).endsWith(".css")) continue;
            CSSParsingReport r = this.getCSSParsingReport(assetPath);
            assert (r != null);
            if (r.isEmpty()) continue;
            ErrorReportEntry newEntry = new ErrorReportEntry(e.getValue(), ErrorReportEntry.Type.INVALID_CSS_CONTENT, r);
            this.addEntry(e.getValue(), newEntry);
        }
    }

    private void verifyUnresolvedObjects() {
        for (FXOMObject fxomObject : FXOMNodes.serializeObjects(this.fxomDocument.getFxomRoot())) {
            Object sceneGraphObject;
            if (fxomObject instanceof FXOMIntrinsic) {
                FXOMIntrinsic fxomIntrinsic = (FXOMIntrinsic)fxomObject;
                sceneGraphObject = fxomIntrinsic.getSourceSceneGraphObject();
            } else {
                sceneGraphObject = fxomObject.getSceneGraphObject();
            }
            if (sceneGraphObject != null) continue;
            ErrorReportEntry newEntry = new ErrorReportEntry(fxomObject, ErrorReportEntry.Type.UNRESOLVED_CLASS);
            this.addEntry(fxomObject, newEntry);
        }
    }

    private void verifyBindingExpressions() {
        for (FXOMPropertyT p : this.fxomDocument.getFxomRoot().collectPropertiesT()) {
            PrefixedValue pv = new PrefixedValue(p.getValue());
            if (!pv.isBindingExpression()) continue;
            ErrorReportEntry newEntry = new ErrorReportEntry(p, ErrorReportEntry.Type.UNSUPPORTED_EXPRESSION);
            this.addEntry(p, newEntry);
        }
    }

    private void addEntry(FXOMNode fxomNode, ErrorReportEntry newEntry) {
        List<ErrorReportEntry> nodeEntries = this.entries.get(fxomNode);
        if (nodeEntries == null) {
            nodeEntries = new ArrayList<ErrorReportEntry>();
            this.entries.put(fxomNode, nodeEntries);
        }
        nodeEntries.add(newEntry);
    }

    private CSSParsingReport getCSSParsingReport(Path assetPath) {
        CSSParsingReport result = this.cssParsingReports.get(assetPath);
        if (result == null) {
            result = new CSSParsingReport(assetPath);
            this.cssParsingReports.put(assetPath, result);
        }
        return result;
    }

    private void collectEntries(FXOMNode fxomNode, List<ErrorReportEntry> collected) {
        block7: {
            block8: {
                block6: {
                    assert (fxomNode != null);
                    assert (collected != null);
                    List<ErrorReportEntry> nodeEntries = this.entries.get(fxomNode);
                    if (nodeEntries != null) {
                        collected.addAll(nodeEntries);
                    }
                    if (!(fxomNode instanceof FXOMCollection)) break block6;
                    FXOMCollection fxomCollection = (FXOMCollection)fxomNode;
                    for (FXOMObject item : fxomCollection.getItems()) {
                        this.collectEntries(item, collected);
                    }
                    break block7;
                }
                if (!(fxomNode instanceof FXOMInstance)) break block8;
                FXOMInstance fxomInstance = (FXOMInstance)fxomNode;
                for (FXOMProperty fxomProperty : fxomInstance.getProperties().values()) {
                    this.collectEntries(fxomProperty, collected);
                }
                break block7;
            }
            if (!(fxomNode instanceof FXOMPropertyC)) break block7;
            FXOMPropertyC fxomPropertyC = (FXOMPropertyC)fxomNode;
            for (FXOMObject value : fxomPropertyC.getValues()) {
                this.collectEntries(value, collected);
            }
        }
    }
}

