/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.javafx.scenebuilder.kit.metadata.util;

import com.oracle.javafx.scenebuilder.kit.metadata.util.BeanPropertyIntrospector;
import com.oracle.javafx.scenebuilder.kit.metadata.util.StaticPropertyIntrospector;

public class PropertyName
implements Comparable<PropertyName> {
    private final String name;
    private final Class<?> residenceClass;

    public PropertyName(String propertyName, Class<?> foreignClass) {
        assert (propertyName != null);
        this.residenceClass = foreignClass;
        this.name = propertyName;
    }

    public PropertyName(String propertyName) {
        this(propertyName, null);
    }

    public Class<?> getResidenceClass() {
        return this.residenceClass;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue(Object sceneGraphObject) {
        Object result;
        if (this.residenceClass == null) {
            BeanPropertyIntrospector bpi = new BeanPropertyIntrospector(sceneGraphObject);
            result = bpi.getValue(this.name);
        } else {
            StaticPropertyIntrospector spi = new StaticPropertyIntrospector(sceneGraphObject, this.residenceClass);
            result = spi.getValue(this.name);
        }
        return result;
    }

    public void setValue(Object sceneGraphObject, Object value) {
        if (this.residenceClass == null) {
            BeanPropertyIntrospector bpi = new BeanPropertyIntrospector(sceneGraphObject);
            bpi.setValue(this.name, value);
        } else {
            StaticPropertyIntrospector spi = new StaticPropertyIntrospector(sceneGraphObject, this.residenceClass);
            spi.setValue(this.name, value);
        }
    }

    public static String makeClassFullName(Class<?> aClass) {
        assert (aClass != null);
        StringBuilder result = new StringBuilder();
        result.append(aClass.getSimpleName());
        for (Class<?> declaringClass = aClass.getDeclaringClass(); declaringClass != null; declaringClass = declaringClass.getDeclaringClass()) {
            result.insert(0, '.');
            result.insert(0, declaringClass.getSimpleName());
        }
        return result.toString();
    }

    public boolean equals(Object o) {
        boolean result;
        if (this == o) {
            result = true;
        } else if (o == null || o.getClass() != this.getClass()) {
            result = false;
        } else {
            PropertyName other = (PropertyName)o;
            result = true;
            result = this.residenceClass == null ? result && other.residenceClass == null : result && this.residenceClass.equals(other.residenceClass);
            result = result && this.name.equals(other.name);
        }
        return result;
    }

    public int hashCode() {
        int result = 7;
        if (this.residenceClass != null) {
            result = 31 * result + this.residenceClass.hashCode();
        }
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public String toString() {
        String result = this.residenceClass == null ? this.name : PropertyName.makeClassFullName(this.residenceClass) + "." + this.name;
        return result;
    }

    @Override
    public int compareTo(PropertyName t) {
        int result;
        if (this == t) {
            result = 0;
        } else if (t == null) {
            result = -1;
        } else {
            result = this.residenceClass == null && t.residenceClass == null ? 0 : (t.residenceClass == null ? 1 : (this.residenceClass == null ? -1 : this.residenceClass.getCanonicalName().compareToIgnoreCase(t.residenceClass.getCanonicalName())));
            if (result == 0) {
                result = this.name.compareToIgnoreCase(t.name);
            }
        }
        return result;
    }
}

