/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.gitlab;

import com.intellij.tasks.Comment;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.gitlab.GitlabRepository;
import com.intellij.tasks.gitlab.model.GitlabIssue;
import com.intellij.tasks.gitlab.model.GitlabProject;
import icons.TasksIcons;
import java.util.Date;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitlabTask
extends Task {
    private final GitlabIssue myIssue;
    private final GitlabRepository myRepository;
    private final GitlabProject myProject;

    public GitlabTask(@NotNull GitlabRepository repository, @NotNull GitlabIssue issue) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/tasks/gitlab/GitlabTask", "<init>"));
        }
        if (issue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "issue", "com/intellij/tasks/gitlab/GitlabTask", "<init>"));
        }
        this.myRepository = repository;
        this.myIssue = issue;
        GitlabProject project = null;
        for (GitlabProject p : this.myRepository.getProjects()) {
            if (p.getId() != this.myIssue.getProjectId()) continue;
            project = p;
        }
        this.myProject = project;
    }

    @NotNull
    public String getId() {
        String string = String.valueOf(this.myIssue.getId());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/gitlab/GitlabTask", "getId"));
        }
        return string;
    }

    @NotNull
    public String getPresentableId() {
        String string = "#" + this.myIssue.getLocalId();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/gitlab/GitlabTask", "getPresentableId"));
        }
        return string;
    }

    @NotNull
    public String getSummary() {
        String string = this.myIssue.getTitle();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/gitlab/GitlabTask", "getSummary"));
        }
        return string;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    @NotNull
    public Comment[] getComments() {
        if (Comment.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/gitlab/GitlabTask", "getComments"));
        }
        return Comment.EMPTY_ARRAY;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = TasksIcons.Gitlab;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/gitlab/GitlabTask", "getIcon"));
        }
        return icon;
    }

    @NotNull
    public TaskType getType() {
        TaskType taskType = TaskType.BUG;
        if (taskType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/gitlab/GitlabTask", "getType"));
        }
        return taskType;
    }

    @Nullable
    public Date getUpdated() {
        return this.myIssue.getUpdatedAt();
    }

    @Nullable
    public Date getCreated() {
        return this.myIssue.getCreatedAt();
    }

    public boolean isClosed() {
        return this.myIssue.getState().equals("closed");
    }

    public boolean isIssue() {
        return true;
    }

    @NotNull
    public String getNumber() {
        String string = String.valueOf(this.myIssue.getLocalId());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/gitlab/GitlabTask", "getNumber"));
        }
        return string;
    }

    @Nullable
    public String getProject() {
        return this.myProject == null ? null : this.myProject.getName();
    }

    @Nullable
    public String getIssueUrl() {
        if (this.myProject != null) {
            return this.myProject.getWebUrl() + "/issues/" + this.myIssue.getLocalId();
        }
        return null;
    }

    @Nullable
    public TaskRepository getRepository() {
        return this.myRepository;
    }
}

