/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandlerFactory;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.context.WorkingContextManager;
import com.intellij.tasks.impl.TaskManagerImpl;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TaskCheckinHandlerFactory
extends CheckinHandlerFactory {
    @NotNull
    public CheckinHandler createHandler(final @NotNull CheckinProjectPanel panel, @NotNull CommitContext commitContext) {
        if (panel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "panel", "com/intellij/tasks/impl/TaskCheckinHandlerFactory", "createHandler"));
        }
        if (commitContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitContext", "com/intellij/tasks/impl/TaskCheckinHandlerFactory", "createHandler"));
        }
        CheckinHandler checkinHandler = new CheckinHandler(){

            public void checkinSuccessful() {
                String message = panel.getCommitMessage();
                Project project = panel.getProject();
                TaskManagerImpl manager = (TaskManagerImpl)TaskManager.getManager((Project)project);
                if (manager.getState().saveContextOnCommit) {
                    Object task = TaskCheckinHandlerFactory.findTaskInRepositories(message, manager);
                    if (task == null) {
                        task = manager.createLocalTask(message);
                    }
                    LocalTask localTask = manager.addTask((Task)task);
                    localTask.setUpdated(new Date());
                    ApplicationManager.getApplication().invokeLater(() -> WorkingContextManager.getInstance(project).saveContext((Task)localTask), project.getDisposed());
                }
            }
        };
        if (checkinHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/impl/TaskCheckinHandlerFactory", "createHandler"));
        }
        return checkinHandler;
    }

    @Nullable
    private static Task findTaskInRepositories(String message, TaskManager manager) {
        TaskRepository[] repositories;
        for (TaskRepository repository : repositories = manager.getAllRepositories()) {
            String id = repository.extractId(message);
            if (id == null) continue;
            LocalTask localTask = manager.findTask(id);
            if (localTask != null) {
                return localTask;
            }
            try {
                Task task = repository.findTask(id);
                if (task == null) continue;
                return task;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

