/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources;

import com.android.resources.ResourceEnum;

public enum ScreenSize implements ResourceEnum
{
    SMALL("small", "Small", "Small Screen"),
    NORMAL("normal", "Normal", "Normal Screen"),
    LARGE("large", "Large", "Large Screen"),
    XLARGE("xlarge", "X-Large", "Extra Large Screen");

    private final String mValue;
    private final String mShortDisplayValue;
    private final String mLongDisplayValue;

    private ScreenSize(String value, String shortDisplayValue, String longDisplayValue) {
        this.mValue = value;
        this.mShortDisplayValue = shortDisplayValue;
        this.mLongDisplayValue = longDisplayValue;
    }

    public static ScreenSize getEnum(String value) {
        for (ScreenSize orient : ScreenSize.values()) {
            if (!orient.mValue.equals(value)) continue;
            return orient;
        }
        return null;
    }

    @Override
    public String getResourceValue() {
        return this.mValue;
    }

    @Override
    public String getShortDisplayValue() {
        return this.mShortDisplayValue;
    }

    @Override
    public String getLongDisplayValue() {
        return this.mLongDisplayValue;
    }

    public static int getIndex(ScreenSize orientation) {
        int i = 0;
        for (ScreenSize orient : ScreenSize.values()) {
            if (orient == orientation) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static ScreenSize getByIndex(int index) {
        ScreenSize[] values = ScreenSize.values();
        if (index >= 0 && index < values.length) {
            return values[index];
        }
        return null;
    }

    @Override
    public boolean isFakeValue() {
        return false;
    }

    @Override
    public boolean isValidValueForDevice() {
        return true;
    }
}

