/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.annotator;

import com.intellij.codeInsight.ClassUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightClassUtil;
import com.intellij.codeInsight.generation.OverrideImplementExploreUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.ExpressionConverter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.SuperMethodsSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.GroovyLanguage;
import org.jetbrains.plugins.groovy.annotator.GrHighlightUtil;
import org.jetbrains.plugins.groovy.annotator.checkers.AnnotationChecker;
import org.jetbrains.plugins.groovy.annotator.checkers.CustomAnnotationChecker;
import org.jetbrains.plugins.groovy.annotator.intentions.ChangeExtendsImplementsQuickFix;
import org.jetbrains.plugins.groovy.annotator.intentions.GrMoveClassToCorrectPlaceFix;
import org.jetbrains.plugins.groovy.annotator.intentions.GrRemoveExceptionFix;
import org.jetbrains.plugins.groovy.annotator.intentions.GrReplacePrimitiveTypeWithWrapperFix;
import org.jetbrains.plugins.groovy.annotator.intentions.ReplaceDelimiterFix;
import org.jetbrains.plugins.groovy.codeInspection.bugs.GrModifierFix;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.findUsages.LiteralConstructorReference;
import org.jetbrains.plugins.groovy.highlighter.GroovySyntaxHighlighter;
import org.jetbrains.plugins.groovy.lang.documentation.GroovyPresentationUtil;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocReferenceElement;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifier;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationArrayInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationMemberValue;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotationNameValuePair;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLoopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrParametersOwner;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTryCatchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrBreakStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrContinueStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrFlowInterruptingStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForInClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnAmbiguousClosureContainer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrRegex;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringContent;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnnotationTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrEnumTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrExtendsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrImplementsClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrInterfaceDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrReferenceList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTraitTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAccessorMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrAnnotationMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrReflectedMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrArrayTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrBuiltInTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClassTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrDisjunctionTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrWildcardTypeArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrStatementOwner;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.modifiers.GrAnnotationCollector;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.psi.util.GrClassImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ast.InheritConstructorContributor;

public class GroovyAnnotator
extends GroovyElementVisitor {
    private static final Logger LOG = Logger.getInstance((String)"org.jetbrains.plugins.groovy.annotator.GroovyAnnotator");
    public static final Condition<PsiClass> IS_INTERFACE = aClass -> aClass.isInterface();
    private static final Condition<PsiClass> IS_NOT_INTERFACE = aClass -> !aClass.isInterface();
    public static final Condition<PsiClass> IS_TRAIT = aClass -> GrTraitUtil.isTrait(aClass);
    private final AnnotationHolder myHolder;

    public GroovyAnnotator(@NotNull AnnotationHolder holder) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/groovy/annotator/GroovyAnnotator", "<init>"));
        }
        this.myHolder = holder;
    }

    @Override
    public void visitTypeArgumentList(GrTypeArgumentList typeArgumentList) {
        PsiElement parent = typeArgumentList.getParent();
        if (!(parent instanceof GrReferenceElement)) {
            return;
        }
        GroovyResolveResult resolveResult = ((GrReferenceElement)parent).advancedResolve();
        PsiElement resolved = resolveResult.getElement();
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        if (resolved == null) {
            return;
        }
        if (!(resolved instanceof PsiTypeParameterListOwner)) {
            this.myHolder.createWarningAnnotation((PsiElement)typeArgumentList, GroovyBundle.message("type.argument.list.is.not.allowed.here", new Object[0]));
            return;
        }
        if (parent instanceof GrCodeReferenceElement && !GroovyAnnotator.checkDiamonds((GrCodeReferenceElement)parent, this.myHolder)) {
            return;
        }
        PsiTypeParameter[] parameters = ((PsiTypeParameterListOwner)resolved).getTypeParameters();
        GrTypeElement[] arguments = typeArgumentList.getTypeArgumentElements();
        if (arguments.length != parameters.length) {
            this.myHolder.createWarningAnnotation((PsiElement)typeArgumentList, GroovyBundle.message("wrong.number.of.type.arguments", arguments.length, parameters.length));
            return;
        }
        block0: for (int i = 0; i < parameters.length; ++i) {
            PsiTypeParameter parameter = parameters[i];
            PsiClassType[] superTypes = parameter.getExtendsListTypes();
            PsiType argType = arguments[i].getType();
            for (PsiClassType superType : superTypes) {
                PsiType substitutedSuper = substitutor.substitute((PsiType)superType);
                if (substitutedSuper == null || substitutedSuper.isAssignableFrom(argType)) continue;
                this.myHolder.createWarningAnnotation((PsiElement)arguments[i], GroovyBundle.message("type.argument.0.is.not.in.its.bound.should.extend.1", argType.getCanonicalText(), superType.getCanonicalText()));
                continue block0;
            }
        }
    }

    @Override
    public void visitNamedArgument(GrNamedArgument argument) {
        PsiElement pparent;
        PsiElement parent = argument.getParent();
        if (parent instanceof GrArgumentList && (pparent = parent.getParent()) instanceof GrIndexProperty) {
            this.myHolder.createErrorAnnotation((PsiElement)argument, GroovyBundle.message("named.arguments.are.not.allowed.inside.index.operations", new Object[0]));
        }
    }

    @Override
    public void visitApplicationStatement(GrApplicationStatement applicationStatement) {
        super.visitApplicationStatement(applicationStatement);
        this.checkForCommandExpressionSyntax(applicationStatement);
    }

    @Override
    public void visitMethodCallExpression(GrMethodCallExpression methodCallExpression) {
        super.visitMethodCallExpression(methodCallExpression);
        this.checkForCommandExpressionSyntax(methodCallExpression);
    }

    private void checkForCommandExpressionSyntax(GrMethodCall methodCall) {
        GroovyConfigUtils groovyConfig = GroovyConfigUtils.getInstance();
        if (methodCall.isCommandExpression() && !groovyConfig.isVersionAtLeast(methodCall, "1.8")) {
            this.myHolder.createErrorAnnotation((PsiElement)methodCall, GroovyBundle.message("is.not.supported.in.version", groovyConfig.getSDKVersion(methodCall)));
        }
    }

    @Override
    public void visitElement(GroovyPsiElement element) {
        if (element.getParent() instanceof GrDocReferenceElement) {
            GroovyAnnotator.checkGrDocReferenceElement(this.myHolder, element);
        }
    }

    @Override
    public void visitTryStatement(GrTryCatchStatement statement) {
        GrCatchClause[] clauses = statement.getCatchClauses();
        ArrayList<PsiType> usedExceptions = new ArrayList<PsiType>();
        for (GrCatchClause clause : clauses) {
            PsiType type;
            GrParameter parameter = clause.getParameter();
            if (parameter == null) continue;
            GrTypeElement typeElement = parameter.getTypeElementGroovy();
            Object object = type = typeElement != null ? typeElement.getType() : TypesUtil.createType("java.lang.Exception", statement);
            if (typeElement instanceof GrDisjunctionTypeElement) {
                GrTypeElement[] elements = ((GrDisjunctionTypeElement)typeElement).getTypeElements();
                PsiType[] types = PsiType.createArray((int)elements.length);
                for (int i = 0; i < elements.length; ++i) {
                    types[i] = elements[i].getType();
                }
                ArrayList<PsiType> usedInsideDisjunction = new ArrayList<PsiType>();
                for (int i = 0; i < types.length; ++i) {
                    if (!this.checkExceptionUsed(usedExceptions, parameter, elements[i], types[i])) continue;
                    usedInsideDisjunction.add(types[i]);
                    for (int j = 0; j < types.length; ++j) {
                        if (i == j || !types[j].isAssignableFrom(types[i])) continue;
                        this.myHolder.createWarningAnnotation((PsiElement)elements[i], GroovyBundle.message("unnecessary.type", types[i].getCanonicalText(), types[j].getCanonicalText())).registerFix((IntentionAction)new GrRemoveExceptionFix(true));
                    }
                }
                usedExceptions.addAll(usedInsideDisjunction);
                continue;
            }
            if (!this.checkExceptionUsed(usedExceptions, parameter, typeElement, type)) continue;
            usedExceptions.add(type);
        }
    }

    @Override
    public void visitCatchClause(GrCatchClause clause) {
        GrParameter parameter = clause.getParameter();
        if (parameter == null) {
            return;
        }
        GrTypeElement typeElement = parameter.getTypeElementGroovy();
        if (typeElement != null) {
            PsiType type = typeElement.getType();
            if (type instanceof PsiClassType && ((PsiClassType)type).resolve() == null) {
                return;
            }
            PsiClassType throwable = TypesUtil.createType("java.lang.Throwable", clause);
            if (!throwable.isAssignableFrom(type)) {
                this.myHolder.createErrorAnnotation((PsiElement)typeElement, GroovyBundle.message("catch.statement.parameter.type.should.be.a.subclass.of.throwable", new Object[0]));
            }
        }
    }

    @Override
    public void visitDocComment(GrDocComment comment) {
        String text = comment.getText();
        if (!text.endsWith("*/")) {
            TextRange range = comment.getTextRange();
            this.myHolder.createErrorAnnotation(new TextRange(range.getEndOffset() - 1, range.getEndOffset()), GroovyBundle.message("doc.end.expected", new Object[0]));
        }
    }

    @Override
    public void visitVariableDeclaration(GrVariableDeclaration variableDeclaration) {
        if (variableDeclaration.isTuple()) {
            GrModifierList list = variableDeclaration.getModifierList();
            PsiElement last = PsiUtil.skipWhitespacesAndComments(list.getLastChild(), false);
            if (last != null) {
                IElementType type = last.getNode().getElementType();
                if (type != GroovyTokenTypes.kDEF) {
                    this.myHolder.createErrorAnnotation((PsiElement)list, GroovyBundle.message("tuple.declaration.should.end.with.def.modifier", new Object[0]));
                }
            } else {
                this.myHolder.createErrorAnnotation((PsiElement)list, GroovyBundle.message("tuple.declaration.should.end.with.def.modifier", new Object[0]));
            }
        }
    }

    private boolean checkExceptionUsed(List<PsiType> usedExceptions, GrParameter parameter, GrTypeElement typeElement, PsiType type) {
        for (PsiType exception : usedExceptions) {
            if (!exception.isAssignableFrom(type)) continue;
            this.myHolder.createWarningAnnotation((PsiElement)(typeElement != null ? typeElement : parameter.getNameIdentifierGroovy()), GroovyBundle.message("exception.0.has.already.been.caught", type.getCanonicalText())).registerFix((IntentionAction)new GrRemoveExceptionFix(parameter.getTypeElementGroovy() instanceof GrDisjunctionTypeElement));
            return false;
        }
        return true;
    }

    @Override
    public void visitReferenceExpression(GrReferenceExpression referenceExpression) {
        this.checkStringNameIdentifier(referenceExpression);
        GroovyAnnotator.checkThisOrSuperReferenceExpression(referenceExpression, this.myHolder);
        this.checkFinalFieldAccess(referenceExpression);
        this.checkFinalParameterAccess(referenceExpression);
        if (ResolveUtil.isKeyOfMap(referenceExpression)) {
            PsiElement nameElement = referenceExpression.getReferenceNameElement();
            LOG.assertTrue(nameElement != null);
            this.myHolder.createInfoAnnotation(nameElement, null).setTextAttributes(GroovySyntaxHighlighter.MAP_KEY);
        } else if (ResolveUtil.isClassReference(referenceExpression)) {
            PsiElement nameElement = referenceExpression.getReferenceNameElement();
            LOG.assertTrue(nameElement != null);
            this.myHolder.createInfoAnnotation(nameElement, null).setTextAttributes(GroovySyntaxHighlighter.KEYWORD);
        }
    }

    private void checkFinalParameterAccess(GrReferenceExpression ref) {
        GrParameter parameter;
        PsiElement resolved = ref.resolve();
        if (resolved instanceof GrParameter && (parameter = (GrParameter)resolved).isPhysical() && parameter.hasModifierProperty("final") && PsiUtil.isLValue(ref) && parameter.getDeclarationScope() instanceof PsiMethod) {
            this.myHolder.createErrorAnnotation((PsiElement)ref, GroovyBundle.message("cannot.assign.a.value.to.final.parameter.0", parameter.getName()));
        }
    }

    private void checkFinalFieldAccess(@NotNull GrReferenceExpression ref) {
        GrField field;
        PsiClass containingClass;
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/plugins/groovy/annotator/GroovyAnnotator", "checkFinalFieldAccess"));
        }
        PsiElement resolved = ref.resolve();
        if (resolved instanceof GrField && resolved.isPhysical() && ((GrField)resolved).hasModifierProperty("final") && PsiUtil.isLValue(ref) && (containingClass = (field = (GrField)resolved).getContainingClass()) != null && PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)ref, (boolean)true)) {
            GrMember container = GrHighlightUtil.findClassMemberContainer(ref, containingClass);
            if (field.hasModifierProperty("static") ? container instanceof GrClassInitializer && ((GrClassInitializer)container).isStatic() : container instanceof GrMethod && ((GrMethod)container).isConstructor() || container instanceof GrClassInitializer && !((GrClassInitializer)container).isStatic()) {
                return;
            }
            this.myHolder.createErrorAnnotation((PsiElement)ref, GroovyBundle.message("cannot.assign.a.value.to.final.field.0", field.getName()));
        }
    }

    private void checkStringNameIdentifier(GrReferenceExpression ref) {
        PsiElement nameElement = ref.getReferenceNameElement();
        if (nameElement == null) {
            return;
        }
        IElementType elementType = nameElement.getNode().getElementType();
        if (elementType == GroovyTokenTypes.mSTRING_LITERAL || elementType == GroovyTokenTypes.mGSTRING_LITERAL) {
            this.checkStringLiteral(nameElement);
        } else if (elementType == GroovyTokenTypes.mREGEX_LITERAL || elementType == GroovyTokenTypes.mDOLLAR_SLASH_REGEX_LITERAL) {
            this.checkRegexLiteral(nameElement);
        }
    }

    @Override
    public void visitTypeDefinitionBody(GrTypeDefinitionBody typeDefinitionBody) {
        PsiElement parent = typeDefinitionBody.getParent();
        if (!(parent instanceof GrAnonymousClassDefinition)) {
            return;
        }
        PsiElement prev = typeDefinitionBody.getPrevSibling();
        if (!PsiUtil.isLineFeed(prev)) {
            return;
        }
        PsiElement newExpression = parent.getParent();
        if (!(newExpression instanceof GrNewExpression)) {
            return;
        }
        GrStatementOwner statementOwner = (GrStatementOwner)PsiTreeUtil.getParentOfType((PsiElement)newExpression, GrStatementOwner.class);
        GrParenthesizedExpression parenthesizedExpression = (GrParenthesizedExpression)PsiTreeUtil.getParentOfType((PsiElement)newExpression, GrParenthesizedExpression.class);
        if (parenthesizedExpression != null && PsiTreeUtil.isAncestor((PsiElement)statementOwner, (PsiElement)parenthesizedExpression, (boolean)true)) {
            return;
        }
        GrArgumentList argumentList = (GrArgumentList)PsiTreeUtil.getParentOfType((PsiElement)newExpression, GrArgumentList.class);
        if (argumentList != null && !(argumentList instanceof GrCommandArgumentList) && PsiTreeUtil.isAncestor((PsiElement)statementOwner, (PsiElement)argumentList, (boolean)true)) {
            return;
        }
        this.myHolder.createErrorAnnotation((PsiElement)typeDefinitionBody, GroovyBundle.message("ambiguous.code.block", new Object[0]));
    }

    @Override
    public void visitTypeDefinition(GrTypeDefinition typeDefinition) {
        PsiElement parent = typeDefinition.getParent();
        if (!(typeDefinition.isAnonymous() || parent instanceof GrTypeDefinitionBody || parent instanceof GroovyFile || typeDefinition instanceof GrTypeParameter)) {
            TextRange range = GrHighlightUtil.getClassHeaderTextRange(typeDefinition);
            Annotation errorAnnotation = this.myHolder.createErrorAnnotation(range, GroovyBundle.message("class.definition.is.not.expected.here", new Object[0]));
            errorAnnotation.registerFix((IntentionAction)new GrMoveClassToCorrectPlaceFix(typeDefinition));
        }
        GroovyAnnotator.checkTypeDefinition(this.myHolder, typeDefinition);
        GroovyAnnotator.checkImplementedMethodsOfClass(this.myHolder, typeDefinition);
        GroovyAnnotator.checkConstructors(this.myHolder, typeDefinition);
        GroovyAnnotator.checkAnnotationCollector(this.myHolder, typeDefinition);
        GroovyAnnotator.checkSameNameMethodsWithDifferentAccessModifiers(this.myHolder, typeDefinition.getCodeMethods());
    }

    private static void checkSameNameMethodsWithDifferentAccessModifiers(AnnotationHolder holder, GrMethod[] methods) {
        MultiMap map = MultiMap.create();
        for (GrMethod method : methods) {
            if (method.isConstructor()) continue;
            map.putValue((Object)method.getName(), (Object)method);
        }
        for (Map.Entry entry : map.entrySet()) {
            Collection collection = (Collection)entry.getValue();
            if (collection.size() <= 1 || GroovyAnnotator.sameAccessModifier(collection)) continue;
            for (GrMethod method : collection) {
                holder.createErrorAnnotation(GrHighlightUtil.getMethodHeaderTextRange(method), GroovyBundle.message("mixing.private.and.public.protected.methods.of.the.same.name", new Object[0]));
            }
        }
    }

    private static boolean sameAccessModifier(Collection<GrMethod> collection) {
        Iterator<GrMethod> iterator = collection.iterator();
        GrMethod method = iterator.next();
        boolean privateAccess = "private".equals(VisibilityUtil.getVisibilityModifier((PsiModifierList)method.getModifierList()));
        while (iterator.hasNext()) {
            GrMethod next = iterator.next();
            if (privateAccess == "private".equals(VisibilityUtil.getVisibilityModifier((PsiModifierList)next.getModifierList()))) continue;
            return false;
        }
        return true;
    }

    private static void checkAnnotationCollector(AnnotationHolder holder, GrTypeDefinition definition) {
        if (definition.isAnnotationType() && GrAnnotationCollector.findAnnotationCollector(definition) != null && definition.getCodeMethods().length > 0) {
            holder.createErrorAnnotation(definition.getNameIdentifierGroovy(), GroovyBundle.message("annotation.collector.cannot.have.attributes", new Object[0]));
        }
    }

    private static void checkConstructors(AnnotationHolder holder, GrTypeDefinition typeDefinition) {
        if (typeDefinition.isEnum() || typeDefinition.isInterface() || typeDefinition.isAnonymous() || typeDefinition instanceof GrTypeParameter) {
            return;
        }
        PsiClass superClass = typeDefinition.getSuperClass();
        if (superClass == null) {
            return;
        }
        if (InheritConstructorContributor.hasInheritConstructorsAnnotation(typeDefinition)) {
            return;
        }
        PsiMethod defConstructor = GroovyAnnotator.getDefaultConstructor(superClass);
        boolean hasImplicitDefConstructor = superClass.getConstructors().length == 0;
        PsiMethod[] constructors = typeDefinition.getCodeConstructors();
        String qName = superClass.getQualifiedName();
        if (constructors.length == 0) {
            if (!(hasImplicitDefConstructor || defConstructor != null && PsiUtil.isAccessible(typeDefinition, (PsiMember)defConstructor))) {
                TextRange range = GrHighlightUtil.getClassHeaderTextRange(typeDefinition);
                holder.createErrorAnnotation(range, GroovyBundle.message("there.is.no.default.constructor.available.in.class.0", qName)).registerFix(QuickFixFactory.getInstance().createCreateConstructorMatchingSuperFix((PsiClass)typeDefinition));
            }
            return;
        }
        for (GrMethod grMethod : constructors) {
            GrStatement[] statements;
            GrOpenBlock block;
            if (!(grMethod instanceof GrMethod) || (block = grMethod.getBlock()) == null || (statements = block.getStatements()).length > 0 && statements[0] instanceof GrConstructorInvocation || hasImplicitDefConstructor || defConstructor != null && PsiUtil.isAccessible(typeDefinition, (PsiMember)defConstructor)) continue;
            holder.createErrorAnnotation(GrHighlightUtil.getMethodHeaderTextRange(grMethod), GroovyBundle.message("there.is.no.default.constructor.available.in.class.0", qName));
        }
        GroovyAnnotator.checkRecursiveConstructors(holder, constructors);
    }

    @Override
    public void visitEnumConstant(GrEnumConstant enumConstant) {
        PsiMethod constructor;
        super.visitEnumConstant(enumConstant);
        GrArgumentList argumentList = enumConstant.getArgumentList();
        if (argumentList != null && PsiImplUtil.hasNamedArguments(argumentList) && !PsiImplUtil.hasExpressionArguments(argumentList) && (constructor = enumConstant.resolveConstructor()) != null && !PsiUtil.isConstructorHasRequiredParameters(constructor)) {
            this.myHolder.createErrorAnnotation((PsiElement)argumentList, GroovyBundle.message("the.usage.of.a.map.entry.expression.to.initialize.an.enum.is.currently.not.supported", new Object[0]));
        }
    }

    private static void checkRecursiveConstructors(AnnotationHolder holder, PsiMethod[] constructors) {
        HashMap<PsiMethod, PsiMethod> nodes = new HashMap<PsiMethod, PsiMethod>(constructors.length);
        Set set = ContainerUtil.set((Object[])constructors);
        for (PsiMethod constructor : constructors) {
            PsiMethod resolved;
            GrStatement[] statements;
            GrOpenBlock block;
            if (!(constructor instanceof GrMethod) || (block = ((GrMethod)constructor).getBlock()) == null || (statements = block.getStatements()).length <= 0 || !(statements[0] instanceof GrConstructorInvocation) || !set.contains(resolved = ((GrConstructorInvocation)statements[0]).resolveMethod())) continue;
            nodes.put(constructor, resolved);
        }
        com.intellij.util.containers.HashSet checked = new com.intellij.util.containers.HashSet();
        for (PsiMethod constructor : constructors) {
            if (!checked.add(constructor)) continue;
            com.intellij.util.containers.HashSet current = new com.intellij.util.containers.HashSet();
            current.add(constructor);
            constructor = (PsiMethod)nodes.get(constructor);
            while (constructor != null && current.add(constructor)) {
                checked.add(constructor);
                constructor = (PsiMethod)nodes.get(constructor);
            }
            if (constructor == null) continue;
            PsiMethod circleStart = constructor;
            do {
                holder.createErrorAnnotation(GrHighlightUtil.getMethodHeaderTextRange(constructor), GroovyBundle.message("recursive.constructor.invocation", new Object[0]));
            } while ((constructor = (PsiMethod)nodes.get(constructor)) != circleStart);
        }
    }

    @Override
    public void visitUnaryExpression(GrUnaryExpression expression) {
        PsiElement resolved;
        GrTraitTypeDefinition trait;
        GrExpression operand;
        if ((expression.getOperationTokenType() == GroovyTokenTypes.mINC || expression.getOperationTokenType() == GroovyTokenTypes.mDEC) && (operand = expression.getOperand()) instanceof GrReferenceExpression && ((GrReferenceExpression)operand).getQualifier() == null && (trait = (GrTraitTypeDefinition)PsiTreeUtil.getParentOfType((PsiElement)operand, GrTraitTypeDefinition.class)) != null && (resolved = ((GrReferenceExpression)operand).resolve()) instanceof GrField && ((GrField)resolved).getContainingClass() instanceof GrTraitTypeDefinition) {
            this.myHolder.createErrorAnnotation((PsiElement)expression, GroovyBundle.message("0.expressions.on.trait.fields.properties.are.not.supported.in.traits", expression.getOperationToken().getText()));
        }
    }

    @Override
    public void visitOpenBlock(GrOpenBlock block) {
        GrMethod method;
        if (block.getParent() instanceof GrMethod && ((method = (GrMethod)block.getParent()).getModifierList().hasExplicitModifier("abstract") || GrTraitUtil.isInterface(method.getContainingClass()))) {
            Annotation annotation = this.myHolder.createErrorAnnotation((PsiElement)block, GroovyBundle.message("abstract.methods.must.not.have.body", new Object[0]));
            GroovyAnnotator.registerMakeAbstractMethodNotAbstractFix(annotation, method, true);
        }
    }

    @Override
    public void visitMethod(GrMethod method) {
        GrOpenBlock block;
        this.checkDuplicateMethod(method);
        GroovyAnnotator.checkMethodWithTypeParamsShouldHaveReturnType(this.myHolder, method);
        GroovyAnnotator.checkInnerMethod(this.myHolder, method);
        GroovyAnnotator.checkOptionalParametersInAbstractMethod(this.myHolder, method);
        GroovyAnnotator.checkConstructorOfImmutableClass(this.myHolder, method);
        GroovyAnnotator.checkGetterOfImmutable(this.myHolder, method);
        PsiElement nameIdentifier = method.getNameIdentifierGroovy();
        if (nameIdentifier.getNode().getElementType() == GroovyTokenTypes.mSTRING_LITERAL) {
            this.checkStringLiteral(nameIdentifier);
        }
        if ((block = method.getBlock()) != null && TypeInferenceHelper.isTooComplexTooAnalyze(block)) {
            this.myHolder.createWeakWarningAnnotation(nameIdentifier, GroovyBundle.message("method.0.is.too.complex.too.analyze", method.getName()));
        }
        PsiClass containingClass = method.getContainingClass();
        if (method.isConstructor()) {
            if (containingClass instanceof GrAnonymousClassDefinition) {
                this.myHolder.createErrorAnnotation(nameIdentifier, GroovyBundle.message("constructors.are.not.allowed.in.anonymous.class", new Object[0]));
            } else if (containingClass != null && containingClass.isInterface()) {
                this.myHolder.createErrorAnnotation(nameIdentifier, GroovyBundle.message("constructors.are.not.allowed.in.interface", new Object[0]));
            }
        }
        if (method.getBlock() == null && !method.hasModifierProperty("native") && !GrTraitUtil.isMethodAbstract(method)) {
            Annotation annotation = this.myHolder.createErrorAnnotation(nameIdentifier, GroovyBundle.message("not.abstract.method.should.have.body", new Object[0]));
        }
        GroovyAnnotator.checkOverridingMethod(this.myHolder, method);
    }

    private static void checkGetterOfImmutable(AnnotationHolder holder, GrMethod method) {
        if (!GroovyPropertyUtils.isSimplePropertyGetter(method)) {
            return;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return;
        }
        PsiModifierList aClassModifierList = aClass.getModifierList();
        if (aClassModifierList == null) {
            return;
        }
        if (!PsiImplUtil.hasImmutableAnnotation(aClassModifierList)) {
            return;
        }
        PsiField field = GroovyPropertyUtils.findFieldForAccessor(method, false);
        if (field == null || !(field instanceof GrField)) {
            return;
        }
        GrModifierList fieldModifierList = ((GrField)field).getModifierList();
        if (fieldModifierList == null) {
            return;
        }
        if (fieldModifierList.hasExplicitVisibilityModifiers()) {
            return;
        }
        holder.createErrorAnnotation(method.getNameIdentifierGroovy(), GroovyBundle.message("repetitive.method.name.0", method.getName()));
    }

    private static void checkConstructorOfImmutableClass(AnnotationHolder holder, GrMethod method) {
        if (!method.isConstructor()) {
            return;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return;
        }
        PsiModifierList modifierList = aClass.getModifierList();
        if (modifierList == null) {
            return;
        }
        if (!PsiImplUtil.hasImmutableAnnotation(modifierList)) {
            return;
        }
        holder.createErrorAnnotation(method.getNameIdentifierGroovy(), GroovyBundle.message("explicit.constructors.are.not.allowed.in.immutable.class", new Object[0]));
    }

    private static void checkOverridingMethod(@NotNull AnnotationHolder holder, @NotNull GrMethod method) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/groovy/annotator/GroovyAnnotator", "checkOverridingMethod"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/groovy/annotator/GroovyAnnotator", "checkOverridingMethod"));
        }
        List signatures = method.getHierarchicalMethodSignature().getSuperSignatures();
        for (HierarchicalMethodSignature signature : signatures) {
            PsiMethod superMethod = signature.getMethod();
            if (superMethod.hasModifierProperty("final")) {
                String current = GroovyPresentationUtil.getSignaturePresentation(method.getSignature(PsiSubstitutor.EMPTY));
                String superPresentation = GroovyPresentationUtil.getSignaturePresentation((MethodSignature)signature);
                String superQName = GroovyAnnotator.getQNameOfMember((PsiMember)superMethod);
                holder.createErrorAnnotation(GrHighlightUtil.getMethodHeaderTextRange(method), GroovyBundle.message("method.0.cannot.override.method.1.in.2.overridden.method.is.final", current, superPresentation, superQName));
                return;
            }
            String currentModifier = VisibilityUtil.getVisibilityModifier((PsiModifierList)method.getModifierList());
            String superModifier = VisibilityUtil.getVisibilityModifier((PsiModifierList)superMethod.getModifierList());
            if ((!"public".equals(superModifier) || !"protected".equals(currentModifier) && !"private".equals(currentModifier)) && (!"protected".equals(superModifier) || !"private".equals(currentModifier))) continue;
            String currentPresentation = GroovyPresentationUtil.getSignaturePresentation(method.getSignature(PsiSubstitutor.EMPTY));
            String superPresentation = GroovyPresentationUtil.getSignaturePresentation((MethodSignature)signature);
            String superQName = GroovyAnnotator.getQNameOfMember((PsiMember)superMethod);
            PsiElement modifier = PsiUtil.findModifierInList(method.getModifierList(), currentModifier);
            holder.createErrorAnnotation(modifier != null ? modifier : method.getNameIdentifierGroovy(), GroovyBundle.message("method.0.cannot.have.weaker.access.privileges.1.than.2.in.3.4", currentPresentation, currentModifier, superPresentation, superQName, superModifier));
        }
    }

    private static void checkMethodWithTypeParamsShouldHaveReturnType(AnnotationHolder holder, GrMethod method) {
        GrTypeElement typeElement;
        PsiTypeParameterList parameterList = method.getTypeParameterList();
        if (parameterList != null && (typeElement = method.getReturnTypeElementGroovy()) == null) {
            TextRange parameterListTextRange = parameterList.getTextRange();
            TextRange range = new TextRange(parameterListTextRange.getEndOffset(), parameterListTextRange.getEndOffset() + 1);
            holder.createErrorAnnotation(range, GroovyBundle.message("method.with.type.parameters.should.have.return.type", new Object[0]));
        }
    }

    private static void checkOptionalParametersInAbstractMethod(AnnotationHolder holder, GrMethod method) {
        if (!method.hasModifierProperty("abstract")) {
            return;
        }
        if (!(method.getContainingClass() instanceof GrInterfaceDefinition)) {
            return;
        }
        for (GrParameter parameter : method.getParameters()) {
            GrExpression initializerGroovy = parameter.getInitializerGroovy();
            if (initializerGroovy == null) continue;
            PsiElement assignOperator = parameter.getNameIdentifierGroovy();
            TextRange textRange = new TextRange(assignOperator.getTextRange().getEndOffset(), initializerGroovy.getTextRange().getEndOffset());
            holder.createErrorAnnotation(textRange, GroovyBundle.message("default.initializers.are.not.allowed.in.abstract.method", new Object[0]));
        }
    }

    @Nullable
    private static PsiMethod getDefaultConstructor(PsiClass clazz) {
        String className = clazz.getName();
        if (className == null) {
            return null;
        }
        PsiMethod[] byName = clazz.findMethodsByName(className, true);
        if (byName.length == 0) {
            return null;
        }
        block0: for (PsiMethod method : byName) {
            GrParameter[] parameters;
            if (method.getParameterList().getParametersCount() == 0) {
                return method;
            }
            if (!(method instanceof GrMethod)) continue;
            for (GrParameter parameter : parameters = ((GrMethod)method).getParameterList().getParameters()) {
                if (!parameter.isOptional()) continue block0;
            }
            return method;
        }
        return null;
    }

    @Override
    public void visitVariable(GrVariable variable) {
        PsiType type;
        PsiNamedElement duplicate;
        PsiElement delimiter;
        this.checkName(variable);
        PsiElement parent = variable.getParent();
        if (parent instanceof GrForInClause && (delimiter = ((GrForInClause)parent).getDelimiter()).getNode().getElementType() == GroovyTokenTypes.mCOLON) {
            GrTypeElement typeElement = variable.getTypeElementGroovy();
            GrModifierList modifierList = variable.getModifierList();
            if (typeElement == null && StringUtil.isEmptyOrSpaces((String)modifierList.getText())) {
                Annotation annotation = this.myHolder.createErrorAnnotation(variable.getNameIdentifierGroovy(), GroovyBundle.message("java.style.for.each.statement.requires.a.type.declaration", new Object[0]));
                annotation.registerFix((IntentionAction)new ReplaceDelimiterFix());
            }
        }
        if ((duplicate = ResolveUtil.findDuplicate(variable)) instanceof GrVariable && (variable instanceof GrField || ResolveUtil.isScriptField(variable) || !(duplicate instanceof GrField))) {
            String key = duplicate instanceof GrField ? "field.already.defined" : "variable.already.defined";
            this.myHolder.createErrorAnnotation(variable.getNameIdentifierGroovy(), GroovyBundle.message(key, variable.getName()));
        }
        if ((type = variable.getDeclaredType()) instanceof PsiEllipsisType && !GroovyAnnotator.isLastParameter(variable)) {
            TextRange range = GroovyAnnotator.getEllipsisRange(variable);
            if (range == null) {
                range = GroovyAnnotator.getTypeRange(variable);
            }
            if (range != null) {
                this.myHolder.createErrorAnnotation(range, GroovyBundle.message("ellipsis.type.is.not.allowed.here", new Object[0]));
            }
        }
    }

    @Nullable
    private static TextRange getEllipsisRange(GrVariable variable) {
        PsiElement dots;
        if (variable instanceof GrParameter && (dots = ((GrParameter)variable).getEllipsisDots()) != null) {
            return dots.getTextRange();
        }
        return null;
    }

    @Nullable
    private static TextRange getTypeRange(GrVariable variable) {
        GrTypeElement typeElement = variable.getTypeElementGroovy();
        if (typeElement == null) {
            return null;
        }
        PsiElement sibling = typeElement.getNextSibling();
        if (sibling != null && sibling.getNode().getElementType() == GroovyTokenTypes.mTRIPLE_DOT) {
            return new TextRange(typeElement.getTextRange().getStartOffset(), sibling.getTextRange().getEndOffset());
        }
        return typeElement.getTextRange();
    }

    private static boolean isLastParameter(PsiVariable variable) {
        if (!(variable instanceof PsiParameter)) {
            return false;
        }
        PsiElement parent = variable.getParent();
        if (!(parent instanceof PsiParameterList)) {
            return false;
        }
        PsiParameter[] parameters = ((PsiParameterList)parent).getParameters();
        return parameters.length > 0 && parameters[parameters.length - 1] == variable;
    }

    private void checkName(GrVariable variable) {
        if (!"$".equals(variable.getName())) {
            return;
        }
        this.myHolder.createErrorAnnotation(variable.getNameIdentifierGroovy(), GroovyBundle.message("incorrect.variable.name", new Object[0]));
    }

    @Override
    public void visitAssignmentExpression(GrAssignmentExpression expression) {
        GrExpression lValue = expression.getLValue();
        if (!PsiUtil.mightBeLValue(lValue)) {
            this.myHolder.createErrorAnnotation((PsiElement)lValue, GroovyBundle.message("invalid.lvalue", new Object[0]));
        }
    }

    @Override
    public void visitReturnStatement(GrReturnStatement returnStatement) {
        GrParametersOwner owner;
        PsiType type;
        GrExpression value = returnStatement.getReturnValue();
        if (value != null && (type = value.getType()) != null && (owner = (GrParametersOwner)PsiTreeUtil.getParentOfType((PsiElement)returnStatement, (Class[])new Class[]{GrMethod.class, GrClosableBlock.class})) instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)owner;
            if (method.isConstructor()) {
                this.myHolder.createErrorAnnotation((PsiElement)value, GroovyBundle.message("cannot.return.from.constructor", new Object[0]));
            } else {
                PsiType methodType = method.getReturnType();
                if (methodType != null && PsiType.VOID.equals((Object)methodType)) {
                    this.myHolder.createErrorAnnotation((PsiElement)value, GroovyBundle.message("cannot.return.from.void.method", new Object[0]));
                }
            }
        }
    }

    @Override
    public void visitTypeParameterList(GrTypeParameterList list) {
        PsiElement parent = list.getParent();
        if (parent instanceof GrMethod && ((GrMethod)parent).isConstructor() || parent instanceof GrEnumTypeDefinition || parent instanceof GrAnnotationTypeDefinition) {
            this.myHolder.createErrorAnnotation((PsiElement)list, GroovyBundle.message("type.parameters.are.unexpected", new Object[0]));
        }
    }

    @Override
    public void visitListOrMap(GrListOrMap listOrMap) {
        PsiReference constructorReference = listOrMap.getReference();
        if (constructorReference instanceof LiteralConstructorReference && ((LiteralConstructorReference)constructorReference).getConstructedClassType() != null) {
            PsiElement endToken;
            PsiElement startToken = listOrMap.getFirstChild();
            if (startToken != null && startToken.getNode().getElementType() == GroovyTokenTypes.mLBRACK) {
                this.myHolder.createInfoAnnotation(startToken, null).setTextAttributes(GroovySyntaxHighlighter.LITERAL_CONVERSION);
            }
            if ((endToken = listOrMap.getLastChild()) != null && endToken.getNode().getElementType() == GroovyTokenTypes.mRBRACK) {
                this.myHolder.createInfoAnnotation(endToken, null).setTextAttributes(GroovySyntaxHighlighter.LITERAL_CONVERSION);
            }
        }
        GrNamedArgument[] namedArguments = listOrMap.getNamedArguments();
        GrExpression[] expressionArguments = listOrMap.getInitializers();
        if (namedArguments.length != 0 && expressionArguments.length != 0) {
            this.myHolder.createErrorAnnotation((PsiElement)listOrMap, GroovyBundle.message("collection.literal.contains.named.argument.and.expression.items", new Object[0]));
        }
        this.checkNamedArgs(namedArguments, false);
    }

    @Override
    public void visitClassTypeElement(GrClassTypeElement typeElement) {
        GrTypeElement[] elements;
        super.visitClassTypeElement(typeElement);
        GrCodeReferenceElement ref = typeElement.getReferenceElement();
        GrTypeArgumentList argList = ref.getTypeArgumentList();
        if (argList == null) {
            return;
        }
        for (GrTypeElement element : elements = argList.getTypeArgumentElements()) {
            this.checkTypeArgForPrimitive(element, GroovyBundle.message("primitive.type.parameters.are.not.allowed", new Object[0]));
        }
    }

    @Override
    public void visitCodeReferenceElement(GrCodeReferenceElement refElement) {
        PsiElement resolved = refElement.resolve();
        if (resolved instanceof PsiClass && (((PsiClass)resolved).isAnnotationType() || GrAnnotationCollector.findAnnotationCollector((PsiClass)resolved) != null && refElement.getParent() instanceof GrAnnotation)) {
            this.myHolder.createInfoAnnotation((PsiElement)refElement, null).setTextAttributes(GroovySyntaxHighlighter.ANNOTATION);
        }
    }

    @Override
    public void visitTypeElement(GrTypeElement typeElement) {
        PsiElement parent = typeElement.getParent();
        if (!(parent instanceof GrMethod)) {
            return;
        }
        if (parent instanceof GrAnnotationMethod) {
            GroovyAnnotator.checkAnnotationAttributeType(typeElement, this.myHolder);
        } else if (((GrMethod)parent).isConstructor()) {
            this.myHolder.createErrorAnnotation((PsiElement)typeElement, GroovyBundle.message("constructors.cannot.have.return.type", new Object[0]));
        } else {
            GroovyAnnotator.checkMethodReturnType((GrMethod)parent, typeElement, this.myHolder);
        }
    }

    @Override
    public void visitModifierList(GrModifierList modifierList) {
        PsiElement parent = modifierList.getParent();
        if (parent instanceof GrMethod) {
            GroovyAnnotator.checkMethodDefinitionModifiers(this.myHolder, (GrMethod)parent);
        } else if (parent instanceof GrTypeDefinition) {
            GroovyAnnotator.checkTypeDefinitionModifiers(this.myHolder, (GrTypeDefinition)parent);
        } else if (parent instanceof GrVariableDeclaration && parent.getParent() instanceof GrTypeDefinition) {
            GroovyAnnotator.checkFieldModifiers(this.myHolder, (GrVariableDeclaration)parent);
        } else if (parent instanceof GrClassInitializer) {
            GroovyAnnotator.checkClassInitializerModifiers(this.myHolder, modifierList);
        }
    }

    private static void checkClassInitializerModifiers(AnnotationHolder holder, GrModifierList modifierList) {
        for (GrAnnotation annotation : modifierList.getAnnotations()) {
            holder.createErrorAnnotation((PsiElement)annotation, GroovyBundle.message("initializer.cannot.have.annotations", new Object[0]));
        }
        for (String modifier : GrModifier.GROOVY_MODIFIERS) {
            if ("static".equals(modifier)) continue;
            GroovyAnnotator.checkModifierIsNotAllowed(modifierList, modifier, GroovyBundle.message("initializer.cannot.be.0", modifier), holder);
        }
    }

    @Override
    public void visitClassInitializer(GrClassInitializer initializer) {
        PsiClass aClass = initializer.getContainingClass();
        if (GrTraitUtil.isInterface(aClass)) {
            TextRange range = GrHighlightUtil.getInitializerHeaderTextRange(initializer);
            this.myHolder.createErrorAnnotation(range, GroovyBundle.message("initializers.are.not.allowed.in.interface", new Object[0]));
        }
    }

    private static void checkFieldModifiers(AnnotationHolder holder, GrVariableDeclaration fieldDeclaration) {
        GrVariable[] variables = fieldDeclaration.getVariables();
        if (variables.length == 0) {
            return;
        }
        GrVariable variable = variables[0];
        if (!(variable instanceof GrField)) {
            return;
        }
        GrField member = (GrField)variable;
        GrModifierList modifierList = fieldDeclaration.getModifierList();
        GroovyAnnotator.checkAccessModifiers(holder, modifierList, member);
        GroovyAnnotator.checkDuplicateModifiers(holder, modifierList, member);
        if (modifierList.hasExplicitModifier("volatile") && modifierList.hasExplicitModifier("final")) {
            Annotation annotation = holder.createErrorAnnotation((PsiElement)modifierList, GroovyBundle.message("illegal.combination.of.modifiers.volatile.and.final", new Object[0]));
            GroovyAnnotator.registerFix(annotation, new GrModifierFix(member, "volatile", true, false, GrModifierFix.MODIFIER_LIST), modifierList);
            GroovyAnnotator.registerFix(annotation, new GrModifierFix(member, "final", true, false, GrModifierFix.MODIFIER_LIST), modifierList);
        }
        GroovyAnnotator.checkModifierIsNotAllowed(modifierList, "native", GroovyBundle.message("variable.cannot.be.native", new Object[0]), holder);
        GroovyAnnotator.checkModifierIsNotAllowed(modifierList, "abstract", GroovyBundle.message("variable.cannot.be.abstract", new Object[0]), holder);
        if (member.getContainingClass() instanceof GrInterfaceDefinition) {
            GroovyAnnotator.checkModifierIsNotAllowed(modifierList, "private", GroovyBundle.message("interface.members.are.not.allowed.to.be", "private"), holder);
            GroovyAnnotator.checkModifierIsNotAllowed(modifierList, "protected", GroovyBundle.message("interface.members.are.not.allowed.to.be", "protected"), holder);
        }
    }

    private static void registerFix(Annotation annotation, LocalQuickFix fix, PsiElement place) {
        InspectionManager manager = InspectionManager.getInstance((Project)place.getProject());
        assert (!place.getTextRange().isEmpty()) : place.getContainingFile().getName();
        ProblemDescriptor descriptor = manager.createProblemDescriptor(place, place, annotation.getMessage(), annotation.getHighlightType(), true, LocalQuickFix.EMPTY_ARRAY);
        TextRange range = TextRange.create((int)annotation.getStartOffset(), (int)annotation.getEndOffset());
        annotation.registerFix(fix, range, null, descriptor);
    }

    private static void checkModifierIsNotAllowed(@NotNull GrModifierList modifierList, @NotNull @GrModifier.GrModifierConstant String modifier, @Nullable String message, @NotNull AnnotationHolder holder) {
        if (modifierList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierList", "org/jetbrains/plugins/groovy/annotator/GroovyAnnotator", "checkModifierIsNotAllowed"));
        }
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifier", "org/jetbrains/plugins/groovy/annotator/GroovyAnnotator", "checkModifierIsNotAllowed"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/groovy/annotator/GroovyAnnotator", "checkModifierIsNotAllowed"));
        }
        GroovyAnnotator.checkModifierIsNotAllowedImpl(modifierList, modifier, message, holder, false);
    }

    private static void checkModifierIsNotAllowedImpl(@NotNull GrModifierList modifierList, @NotNull @GrModifier.GrModifierConstant String modifier, @Nullable String message, @NotNull AnnotationHolder holder, boolean explicit) {
        if (modifierList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierList", "org/jetbrains/plugins/groovy/annotator/GroovyAnnotator", "checkModifierIsNotAllowedImpl"));
        }
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifier", "org/jetbrains/plugins/groovy/annotator/GroovyAnnotator", "checkModifierIsNotAllowedImpl"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/groovy/annotator/GroovyAnnotator", "checkModifierIsNotAllowedImpl"));
        }
        if (explicit ? modifierList.hasModifierProperty(modifier) : modifierList.hasExplicitModifier(modifier)) {
            PsiElement modifierOrList = GroovyAnnotator.getModifierOrList(modifierList, modifier);
            Annotation annotation = holder.createErrorAnnotation(modifierOrList, message);
            GroovyAnnotator.registerFix(annotation, new GrModifierFix((PsiMember)modifierList.getParent(), modifier, true, false, GrModifierFix.MODIFIER_LIST), modifierList);
        }
    }

    private static void checkAnnotationAttributeType(GrTypeElement element, AnnotationHolder holder) {
        PsiElement resolved;
        if (element instanceof GrBuiltInTypeElement) {
            return;
        }
        if (element instanceof GrArrayTypeElement) {
            GroovyAnnotator.checkAnnotationAttributeType(((GrArrayTypeElement)element).getComponentTypeElement(), holder);
            return;
        }
        if (element instanceof GrClassTypeElement && (resolved = ((GrClassTypeElement)element).getReferenceElement().resolve()) instanceof PsiClass) {
            if ("java.lang.String".equals(((PsiClass)resolved).getQualifiedName())) {
                return;
            }
            if ("java.lang.Class".equals(((PsiClass)resolved).getQualifiedName())) {
                return;
            }
            if (((PsiClass)resolved).isAnnotationType()) {
                return;
            }
            if (((PsiClass)resolved).isEnum()) {
                return;
            }
        }
        holder.createErrorAnnotation((PsiElement)element, GroovyBundle.message("unexpected.attribute.type.0", element.getType()));
    }

    static void checkMethodReturnType(PsiMethod method, PsiElement toHighlight, AnnotationHolder holder) {
        HierarchicalMethodSignature signature = method.getHierarchicalMethodSignature();
        List superSignatures = signature.getSuperSignatures();
        PsiType returnType = signature.getSubstitutor().substitute(method.getReturnType());
        for (HierarchicalMethodSignature superMethodSignature : superSignatures) {
            String highlightInfo;
            PsiClass superClass;
            PsiMethod superMethod = superMethodSignature.getMethod();
            PsiType declaredReturnType = superMethod.getReturnType();
            PsiType superReturnType = superMethodSignature.getSubstitutor().substitute(declaredReturnType);
            if (PsiType.VOID.equals((Object)superReturnType) && method instanceof GrMethod && ((GrMethod)method).getReturnTypeElementGroovy() == null) {
                return;
            }
            if (superMethodSignature.isRaw()) {
                superReturnType = TypeConversionUtil.erasure((PsiType)declaredReturnType);
            }
            if (returnType == null || superReturnType == null || method == superMethod || (superClass = superMethod.getContainingClass()) == null || (highlightInfo = GroovyAnnotator.checkSuperMethodSignature(superMethod, (MethodSignatureBackedByPsiMethod)superMethodSignature, superReturnType, method, (MethodSignatureBackedByPsiMethod)signature, returnType)) == null) continue;
            holder.createErrorAnnotation(toHighlight, highlightInfo);
            return;
        }
    }

    @Nullable
    private static String checkSuperMethodSignature(@NotNull PsiMethod superMethod, @NotNull MethodSignatureBackedByPsiMethod superMethodSignature, @NotNull PsiType superReturnType, @NotNull PsiMethod method, @NotNull MethodSignatureBackedByPsiMethod methodSignature, @NotNull PsiType returnType) {
        if (superMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superMethod", "org/jetbrains/plugins/groovy/annotator/GroovyAnnotator", "checkSuperMethodSignature"));
        }
        if (superMethodSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superMethodSignature", "org/jetbrains/plugins/groovy/annotator/GroovyAnnotator", "checkSuperMethodSignature"));
        }
        if (superReturnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superReturnType", "org/jetbrains/plugins/groovy/annotator/GroovyAnnotator", "checkSuperMethodSignature"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/groovy/annotator/GroovyAnnotator", "checkSuperMethodSignature"));
        }
        if (methodSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodSignature", "org/jetbrains/plugins/groovy/annotator/GroovyAnnotator", "checkSuperMethodSignature"));
        }
        if (returnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/jetbrains/plugins/groovy/annotator/GroovyAnnotator", "checkSuperMethodSignature"));
        }
        PsiType substitutedSuperReturnType = GroovyAnnotator.substituteSuperReturnType(superMethodSignature, methodSignature, superReturnType);
        if (returnType.equals(substitutedSuperReturnType)) {
            return null;
        }
        PsiType rawReturnType = TypeConversionUtil.erasure((PsiType)returnType);
        PsiType rawSuperReturnType = TypeConversionUtil.erasure((PsiType)substitutedSuperReturnType);
        if (returnType instanceof PsiClassType && substitutedSuperReturnType instanceof PsiClassType ? TypeConversionUtil.isAssignable((PsiType)rawSuperReturnType, (PsiType)rawReturnType) : returnType instanceof PsiArrayType && superReturnType instanceof PsiArrayType && rawReturnType.equals(rawSuperReturnType)) {
            return null;
        }
        String qName = GroovyAnnotator.getQNameOfMember((PsiMember)method);
        String baseQName = GroovyAnnotator.getQNameOfMember((PsiMember)superMethod);
        String presentation = returnType.getCanonicalText() + " " + GroovyPresentationUtil.getSignaturePresentation((MethodSignature)methodSignature);
        String basePresentation = superReturnType.getCanonicalText() + " " + GroovyPresentationUtil.getSignaturePresentation((MethodSignature)superMethodSignature);
        return GroovyBundle.message("return.type.is.incompatible", presentation, qName, basePresentation, baseQName);
    }

    @NotNull
    private static PsiType substituteSuperReturnType(@NotNull MethodSignatureBackedByPsiMethod superMethodSignature, @NotNull MethodSignatureBackedByPsiMethod methodSignature, @NotNull PsiType superReturnType) {
        PsiSubstitutor unifyingSubstitutor;
        if (superMethodSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superMethodSignature", "org/jetbrains/plugins/groovy/annotator/GroovyAnnotator", "substituteSuperReturnType"));
        }
        if (methodSignature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodSignature", "org/jetbrains/plugins/groovy/annotator/GroovyAnnotator", "substituteSuperReturnType"));
        }
        if (superReturnType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superReturnType", "org/jetbrains/plugins/groovy/annotator/GroovyAnnotator", "substituteSuperReturnType"));
        }
        PsiType substitutedSuperReturnType = !superMethodSignature.isRaw() && superMethodSignature.equals((Object)methodSignature) ? ((unifyingSubstitutor = MethodSignatureUtil.getSuperMethodSignatureSubstitutor((MethodSignature)methodSignature, (MethodSignature)superMethodSignature)) == null ? superReturnType : unifyingSubstitutor.substitute(superMethodSignature.getSubstitutor().substitute(superReturnType))) : TypeConversionUtil.erasure((PsiType)superReturnType);
        PsiType psiType = substitutedSuperReturnType;
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/GroovyAnnotator", "substituteSuperReturnType"));
        }
        return psiType;
    }

    @NotNull
    private static String getQNameOfMember(@NotNull PsiMember member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "org/jetbrains/plugins/groovy/annotator/GroovyAnnotator", "getQNameOfMember"));
        }
        PsiClass aClass = member.getContainingClass();
        String string = GroovyAnnotator.getQName(aClass);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/GroovyAnnotator", "getQNameOfMember"));
        }
        return string;
    }

    @NotNull
    private static String getQName(@Nullable PsiClass aClass) {
        String qname;
        if (aClass instanceof PsiAnonymousClass) {
            String string = GroovyBundle.message("anonymous.class.derived.from.0", ((PsiAnonymousClass)aClass).getBaseClassType().getCanonicalText());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/GroovyAnnotator", "getQName"));
            }
            return string;
        }
        if (aClass != null && (qname = aClass.getQualifiedName()) != null) {
            String string = qname;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/GroovyAnnotator", "getQName"));
            }
            return string;
        }
        if ("<null>" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/GroovyAnnotator", "getQName"));
        }
        return "<null>";
    }

    private void checkTypeArgForPrimitive(@Nullable GrTypeElement element, String message) {
        if (element == null || !(element.getType() instanceof PsiPrimitiveType)) {
            return;
        }
        Annotation annotation = this.myHolder.createErrorAnnotation((PsiElement)element, message);
        GroovyAnnotator.registerFix(annotation, new GrReplacePrimitiveTypeWithWrapperFix(element), element);
    }

    @Override
    public void visitWildcardTypeArgument(GrWildcardTypeArgument wildcardTypeArgument) {
        super.visitWildcardTypeArgument(wildcardTypeArgument);
        this.checkTypeArgForPrimitive(wildcardTypeArgument.getBoundTypeElement(), GroovyBundle.message("primitive.bound.types.are.not.allowed", new Object[0]));
    }

    private void highlightNamedArgs(GrNamedArgument[] namedArguments) {
        for (GrNamedArgument namedArgument : namedArguments) {
            GrArgumentLabel label = namedArgument.getLabel();
            if (label == null || label.getExpression() != null || label.getNameElement().getNode().getElementType() == GroovyTokenTypes.mSTAR) continue;
            this.myHolder.createInfoAnnotation((PsiElement)label, null).setTextAttributes(GroovySyntaxHighlighter.MAP_KEY);
        }
    }

    private void checkNamedArgs(GrNamedArgument[] namedArguments, boolean forArgList) {
        this.highlightNamedArgs(namedArguments);
        HashSet existingKeys = ContainerUtil.newHashSet();
        for (GrNamedArgument namedArgument : namedArguments) {
            GrArgumentLabel label = namedArgument.getLabel();
            Object value = PsiUtil.getLabelValue(label);
            if (value == null) continue;
            if (value == ObjectUtils.NULL) {
                value = null;
            }
            if (existingKeys.add(value)) continue;
            if (forArgList) {
                this.myHolder.createErrorAnnotation((PsiElement)label, GroovyBundle.message("duplicated.named.parameter", String.valueOf(value)));
                continue;
            }
            this.myHolder.createWarningAnnotation((PsiElement)label, GroovyBundle.message("duplicate.element.in.the.map", String.valueOf(value)));
        }
    }

    @Override
    public void visitNewExpression(GrNewExpression newExpression) {
        PsiClass clazz;
        GrTypeElement typeElement;
        GrTypeArgumentList constructorTypeArguments = newExpression.getConstructorTypeArguments();
        if (constructorTypeArguments != null) {
            this.myHolder.createErrorAnnotation((PsiElement)constructorTypeArguments, GroovyBundle.message("groovy.does.not.support.constructor.type.arguments", new Object[0]));
        }
        if ((typeElement = newExpression.getTypeElement()) instanceof GrBuiltInTypeElement && newExpression.getArrayCount() == 0) {
            this.myHolder.createErrorAnnotation((PsiElement)typeElement, GroovyBundle.message("create.instance.of.built-in.type", new Object[0]));
        }
        if (newExpression.getArrayCount() > 0) {
            return;
        }
        GrCodeReferenceElement refElement = newExpression.getReferenceElement();
        if (refElement == null) {
            return;
        }
        PsiElement element = refElement.resolve();
        if (element instanceof PsiClass && (clazz = (PsiClass)element).hasModifierProperty("abstract") && newExpression.getAnonymousClassDefinition() == null) {
            String message = clazz.isInterface() ? GroovyBundle.message("cannot.instantiate.interface", clazz.getName()) : GroovyBundle.message("cannot.instantiate.abstract.class", clazz.getName());
            this.myHolder.createErrorAnnotation((PsiElement)refElement, message);
        }
    }

    private static boolean checkDiamonds(GrCodeReferenceElement refElement, AnnotationHolder holder) {
        GrTypeArgumentList typeArgumentList = refElement.getTypeArgumentList();
        if (typeArgumentList == null) {
            return true;
        }
        if (!typeArgumentList.isDiamond()) {
            return true;
        }
        GroovyConfigUtils configUtils = GroovyConfigUtils.getInstance();
        if (!configUtils.isVersionAtLeast(refElement, "1.8")) {
            String message = GroovyBundle.message("diamonds.are.not.allowed.in.groovy.0", configUtils.getSDKVersion(refElement));
            holder.createErrorAnnotation((PsiElement)typeArgumentList, message);
        }
        return false;
    }

    @Override
    public void visitArgumentList(GrArgumentList list) {
        this.checkNamedArgs(list.getNamedArguments(), true);
    }

    @Override
    public void visitConstructorInvocation(GrConstructorInvocation invocation) {
        GroovyResolveResult resolveResult = invocation.advancedResolve();
        if (resolveResult.getElement() == null) {
            GroovyResolveResult[] results = invocation.multiResolve(false);
            GrArgumentList argList = invocation.getArgumentList();
            if (results.length > 0) {
                String message = GroovyBundle.message("ambiguous.constructor.call", new Object[0]);
                this.myHolder.createWarningAnnotation((PsiElement)argList, message);
            } else {
                PsiType[] argumentTypes;
                PsiClass clazz = invocation.getDelegatedClass();
                if (clazz != null && (argumentTypes = PsiUtil.getArgumentTypes(invocation.getInvokedExpression(), true)) != null && argumentTypes.length > 0) {
                    String message = GroovyBundle.message("cannot.apply.default.constructor", clazz.getName());
                    this.myHolder.createWarningAnnotation((PsiElement)argList, message);
                }
            }
        }
    }

    @Override
    public void visitBreakStatement(GrBreakStatement breakStatement) {
        GroovyAnnotator.checkFlowInterruptStatement(breakStatement, this.myHolder);
    }

    @Override
    public void visitContinueStatement(GrContinueStatement continueStatement) {
        GroovyAnnotator.checkFlowInterruptStatement(continueStatement, this.myHolder);
    }

    @Override
    public void visitPackageDefinition(GrPackageDefinition packageDefinition) {
        GrModifierList modifierList = packageDefinition.getAnnotationList();
        GroovyAnnotator.checkAnnotationList(this.myHolder, modifierList, GroovyBundle.message("package.definition.cannot.have.modifiers", new Object[0]));
    }

    @Override
    public void visitClosure(GrClosableBlock closure) {
        super.visitClosure(closure);
        if (!closure.hasParametersSection() && !GroovyAnnotator.followsError(closure) && GroovyAnnotator.isClosureAmbiguous(closure)) {
            this.myHolder.createErrorAnnotation((PsiElement)closure, GroovyBundle.message("ambiguous.code.block", new Object[0]));
        }
        if (TypeInferenceHelper.isTooComplexTooAnalyze(closure)) {
            int endOffset;
            int startOffset = closure.getTextRange().getStartOffset();
            PsiElement arrow = closure.getArrow();
            if (arrow != null) {
                endOffset = arrow.getTextRange().getEndOffset();
            } else {
                Document document = PsiDocumentManager.getInstance((Project)closure.getProject()).getDocument(closure.getContainingFile());
                if (document == null) {
                    return;
                }
                String text = document.getText();
                endOffset = Math.min(closure.getTextRange().getEndOffset(), text.indexOf(10, startOffset));
            }
            this.myHolder.createWeakWarningAnnotation(new TextRange(startOffset, endOffset), GroovyBundle.message("closure.is.too.complex.to.analyze", new Object[0]));
        }
    }

    private static boolean followsError(GrClosableBlock closure) {
        PsiElement prev = closure.getPrevSibling();
        return prev instanceof PsiErrorElement || prev instanceof PsiWhiteSpace && prev.getPrevSibling() instanceof PsiErrorElement;
    }

    private static boolean isClosureAmbiguous(GrClosableBlock closure) {
        GrClosableBlock place = closure;
        PsiElement parent;
        while ((parent = place.getParent()) != null && !(parent instanceof GrUnAmbiguousClosureContainer)) {
            if (PsiUtil.isExpressionStatement(place)) {
                return true;
            }
            if (parent.getFirstChild() != place) {
                return false;
            }
            place = parent;
        }
        return false;
    }

    @Override
    public void visitLiteralExpression(GrLiteral literal) {
        IElementType elementType = literal.getFirstChild().getNode().getElementType();
        if (elementType == GroovyTokenTypes.mSTRING_LITERAL || elementType == GroovyTokenTypes.mGSTRING_LITERAL) {
            this.checkStringLiteral(literal);
        } else if (elementType == GroovyTokenTypes.mREGEX_LITERAL || elementType == GroovyTokenTypes.mDOLLAR_SLASH_REGEX_LITERAL) {
            this.checkRegexLiteral(literal.getFirstChild());
        }
    }

    @Override
    public void visitRegexExpression(GrRegex regex) {
        this.checkRegexLiteral(regex);
    }

    private void checkRegexLiteral(PsiElement regex) {
        String text = regex.getText();
        String quote = GrStringUtil.getStartQuote(text);
        GroovyConfigUtils config = GroovyConfigUtils.getInstance();
        if ("$/".equals(quote) && !config.isVersionAtLeast(regex, "1.8")) {
            this.myHolder.createErrorAnnotation(regex, GroovyBundle.message("dollar.slash.strings.are.not.allowed.in.0", config.getSDKVersion(regex)));
        }
        String[] parts = regex instanceof GrRegex ? ((GrRegex)regex).getTextParts() : new String[]{regex.getFirstChild().getNextSibling().getText()};
        for (String part : parts) {
            if (GrStringUtil.parseRegexCharacters(part, new StringBuilder(part.length()), null, regex.getText().startsWith("/"))) continue;
            this.myHolder.createErrorAnnotation(regex, GroovyBundle.message("illegal.escape.character.in.string.literal", new Object[0]));
            return;
        }
        if ("/".equals(quote) && !config.isVersionAtLeast(regex, "1.8") && (text.contains("\n") || text.contains("\r"))) {
            this.myHolder.createErrorAnnotation(regex, GroovyBundle.message("multiline.slashy.strings.are.not.allowed.in.groovy.0", config.getSDKVersion(regex)));
            return;
        }
    }

    @Override
    public void visitGStringExpression(GrString gstring) {
        for (GrStringContent part : gstring.getContents()) {
            String text = part.getText();
            if (GrStringUtil.parseStringCharacters(text, new StringBuilder(text.length()), null)) continue;
            this.myHolder.createErrorAnnotation((PsiElement)part, GroovyBundle.message("illegal.escape.character.in.string.literal", new Object[0]));
            return;
        }
    }

    @Override
    public void visitGStringInjection(GrStringInjection injection) {
        if (((GrString)injection.getParent()).isPlainString() && StringUtil.indexOf((CharSequence)injection.getText(), (char)'\n') != -1) {
            this.myHolder.createErrorAnnotation((PsiElement)injection, GroovyBundle.message("injection.should.not.contain.line.feeds", new Object[0]));
        }
    }

    private void checkStringLiteral(PsiElement literal) {
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)literal.getProject());
        String text = injectedLanguageManager.isInjectedFragment(literal.getContainingFile()) ? injectedLanguageManager.getUnescapedText(literal) : literal.getText();
        assert (text != null);
        StringBuilder builder = new StringBuilder(text.length());
        String quote = GrStringUtil.getStartQuote(text);
        if (quote.isEmpty()) {
            return;
        }
        String substring = text.substring(quote.length());
        if (!GrStringUtil.parseStringCharacters(substring, new StringBuilder(text.length()), null)) {
            this.myHolder.createErrorAnnotation(literal, GroovyBundle.message("illegal.escape.character.in.string.literal", new Object[0]));
            return;
        }
        int[] offsets = new int[substring.length() + 1];
        boolean result = GrStringUtil.parseStringCharacters(substring, builder, offsets);
        LOG.assertTrue(result);
        if (!builder.toString().endsWith(quote) || substring.charAt(offsets[builder.length() - quote.length()]) == '\\') {
            this.myHolder.createErrorAnnotation(literal, GroovyBundle.message("string.end.expected", new Object[0]));
        }
    }

    @Override
    public void visitForInClause(GrForInClause forInClause) {
        PsiElement[] modifiers;
        GrVariable var = forInClause.getDeclaredVariable();
        if (var == null) {
            return;
        }
        GrModifierList modifierList = var.getModifierList();
        if (modifierList == null) {
            return;
        }
        for (PsiElement modifier : modifiers = modifierList.getModifiers()) {
            String modifierText;
            if (modifier instanceof PsiAnnotation || "final".equals(modifierText = modifier.getText()) || "def".equals(modifierText)) continue;
            this.myHolder.createErrorAnnotation(modifier, GroovyBundle.message("not.allowed.modifier.in.forin", modifierText));
        }
    }

    @Override
    public void visitFile(GroovyFileBase file) {
        PsiClass scriptClass = file.getScriptClass();
        if (scriptClass != null) {
            GroovyAnnotator.checkSameNameMethodsWithDifferentAccessModifiers(this.myHolder, file.getMethods());
        }
    }

    @Override
    public void visitAnnotation(GrAnnotation annotation) {
        new AnnotationChecker(this.myHolder).checkApplicability(annotation, annotation.getOwner());
    }

    @Override
    public void visitAnnotationArgumentList(GrAnnotationArgumentList annotationArgumentList) {
        new AnnotationChecker(this.myHolder).checkAnnotationArgumentList((GrAnnotation)annotationArgumentList.getParent());
    }

    @Override
    public void visitAnnotationMethod(GrAnnotationMethod annotationMethod) {
        super.visitAnnotationMethod(annotationMethod);
        GrAnnotationMemberValue value = annotationMethod.getDefaultValue();
        if (value == null) {
            return;
        }
        PsiType type = annotationMethod.getReturnType();
        CustomAnnotationChecker.checkAnnotationValueByType(this.myHolder, value, type, false);
    }

    @Override
    public void visitAnnotationNameValuePair(GrAnnotationNameValuePair nameValuePair) {
        GrAnnotationMemberValue value;
        int count;
        PsiElement parent;
        PsiElement identifier = nameValuePair.getNameIdentifierGroovy();
        if (identifier == null && (parent = nameValuePair.getParent()) instanceof GrAnnotationArgumentList && (count = ((GrAnnotationArgumentList)parent).getAttributes().length) > 1) {
            this.myHolder.createErrorAnnotation((PsiElement)nameValuePair, GroovyBundle.message("attribute.name.expected", new Object[0]));
        }
        if ((value = nameValuePair.getValue()) != null) {
            this.checkAnnotationAttributeValue(value, value);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkAnnotationAttributeValue(@Nullable GrAnnotationMemberValue value, @NotNull PsiElement toHighlight) {
        IElementType iElementType;
        if (toHighlight == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toHighlight", "org/jetbrains/plugins/groovy/annotator/GroovyAnnotator", "checkAnnotationAttributeValue"));
        }
        if (value == null) {
            return false;
        }
        if (value instanceof GrLiteral) {
            return false;
        }
        if (value instanceof GrClosableBlock) {
            return false;
        }
        if (value instanceof GrAnnotation) {
            return false;
        }
        if (value instanceof GrReferenceExpression) {
            void var3_5;
            PsiElement psiElement = ((GrReferenceExpression)value).resolve();
            if (psiElement instanceof PsiClass) {
                return false;
            }
            if (psiElement instanceof PsiEnumConstant) {
                return false;
            }
            if (psiElement == null && GroovyAnnotator.isClassReference(value)) {
                return false;
            }
            if (psiElement instanceof GrAccessorMethod) {
                GrField grField = ((GrAccessorMethod)psiElement).getProperty();
            }
            if (var3_5 instanceof PsiField) {
                GrExpression initializer;
                try {
                    PsiExpression _initializer;
                    initializer = var3_5 instanceof GrField ? ((GrField)var3_5).getInitializerGroovy() : ((_initializer = ((PsiField)var3_5).getInitializer()) != null ? (GrExpression)ExpressionConverter.getExpression((PsiElement)_initializer, (Language)GroovyLanguage.INSTANCE, (Project)value.getProject()) : null);
                }
                catch (IncorrectOperationException e) {
                    initializer = null;
                }
                if (initializer != null) {
                    return this.checkAnnotationAttributeValue(initializer, toHighlight);
                }
            }
        }
        if (value instanceof GrAnnotationArrayInitializer) {
            for (GrAnnotationMemberValue expression : ((GrAnnotationArrayInitializer)value).getInitializers()) {
                if (!this.checkAnnotationAttributeValue(expression, toHighlight)) continue;
                return true;
            }
            return false;
        }
        if (value instanceof GrUnaryExpression && ((iElementType = ((GrUnaryExpression)value).getOperationTokenType()) == GroovyTokenTypes.mMINUS || iElementType == GroovyTokenTypes.mPLUS)) {
            return this.checkAnnotationAttributeValue(((GrUnaryExpression)value).getOperand(), toHighlight);
        }
        this.myHolder.createErrorAnnotation(toHighlight, GroovyBundle.message("expected.0.to.be.inline.constant", value.getText()));
        return true;
    }

    private static boolean isClassReference(GrAnnotationMemberValue value) {
        PsiElement resolved;
        GrExpression qualifier;
        String referenceName;
        return value instanceof GrReferenceExpression && "class".equals(referenceName = ((GrReferenceExpression)value).getReferenceName()) && (qualifier = (GrExpression)((GrReferenceExpression)value).getQualifier()) instanceof GrReferenceExpression && (resolved = ((GrReferenceExpression)qualifier).resolve()) instanceof PsiClass;
    }

    @Override
    public void visitImportStatement(GrImportStatement importStatement) {
        GroovyAnnotator.checkAnnotationList(this.myHolder, importStatement.getAnnotationList(), GroovyBundle.message("import.statement.cannot.have.modifiers", new Object[0]));
    }

    @Override
    public void visitExtendsClause(GrExtendsClause extendsClause) {
        GrTypeDefinition typeDefinition = (GrTypeDefinition)extendsClause.getParent();
        if (typeDefinition.isAnnotationType()) {
            this.myHolder.createErrorAnnotation((PsiElement)extendsClause, GroovyBundle.message("annotation.types.may.not.have.extends.clause", new Object[0]));
        } else if (typeDefinition.isTrait()) {
            GroovyAnnotator.checkReferenceList(this.myHolder, extendsClause, IS_TRAIT, GroovyBundle.message("only.traits.expected.here", new Object[0]), null);
        } else if (typeDefinition.isInterface()) {
            GroovyAnnotator.checkReferenceList(this.myHolder, extendsClause, IS_INTERFACE, GroovyBundle.message("no.class.expected.here", new Object[0]), null);
        } else if (typeDefinition.isEnum()) {
            this.myHolder.createErrorAnnotation((PsiElement)extendsClause, GroovyBundle.message("enums.may.not.have.extends.clause", new Object[0]));
        } else {
            GroovyAnnotator.checkReferenceList(this.myHolder, extendsClause, IS_NOT_INTERFACE, GroovyBundle.message("no.interface.expected.here", new Object[0]), new ChangeExtendsImplementsQuickFix(typeDefinition));
            GroovyAnnotator.checkForWildCards(this.myHolder, extendsClause);
        }
    }

    @Override
    public void visitImplementsClause(GrImplementsClause implementsClause) {
        GrTypeDefinition typeDefinition = (GrTypeDefinition)implementsClause.getParent();
        if (typeDefinition.isAnnotationType()) {
            this.myHolder.createErrorAnnotation((PsiElement)implementsClause, GroovyBundle.message("annotation.types.may.not.have.implements.clause", new Object[0]));
        } else if (GrTraitUtil.isInterface(typeDefinition)) {
            this.myHolder.createErrorAnnotation((PsiElement)implementsClause, GroovyBundle.message("no.implements.clause.allowed.for.interface", new Object[0])).registerFix((IntentionAction)new ChangeExtendsImplementsQuickFix(typeDefinition));
        } else {
            GroovyAnnotator.checkReferenceList(this.myHolder, implementsClause, IS_INTERFACE, GroovyBundle.message("no.class.expected.here", new Object[0]), new ChangeExtendsImplementsQuickFix(typeDefinition));
            GroovyAnnotator.checkForWildCards(this.myHolder, implementsClause);
        }
    }

    private static void checkReferenceList(@NotNull AnnotationHolder holder, @NotNull GrReferenceList list, @NotNull Condition<PsiClass> applicabilityCondition, @NotNull String message, @Nullable IntentionAction fix) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/groovy/annotator/GroovyAnnotator", "checkReferenceList"));
        }
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/plugins/groovy/annotator/GroovyAnnotator", "checkReferenceList"));
        }
        if (applicabilityCondition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicabilityCondition", "org/jetbrains/plugins/groovy/annotator/GroovyAnnotator", "checkReferenceList"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/plugins/groovy/annotator/GroovyAnnotator", "checkReferenceList"));
        }
        for (GrCodeReferenceElement refElement : list.getReferenceElementsGroovy()) {
            PsiElement psiClass = refElement.resolve();
            if (!(psiClass instanceof PsiClass) || applicabilityCondition.value((Object)((PsiClass)psiClass))) continue;
            Annotation annotation = holder.createErrorAnnotation((PsiElement)refElement, message);
            if (fix == null) continue;
            annotation.registerFix(fix);
        }
    }

    private static void checkFlowInterruptStatement(GrFlowInterruptingStatement statement, AnnotationHolder holder) {
        GrStatement targetStatement;
        GrLabeledStatement resolved;
        PsiElement label = statement.getLabelIdentifier();
        if (label != null && (resolved = statement.resolveLabel()) == null) {
            holder.createErrorAnnotation(label, GroovyBundle.message("undefined.label", statement.getLabelName()));
        }
        if ((targetStatement = statement.findTargetStatement()) == null) {
            if (statement instanceof GrContinueStatement && label == null) {
                holder.createErrorAnnotation((PsiElement)statement, GroovyBundle.message("continue.outside.loop", new Object[0]));
            } else if (statement instanceof GrBreakStatement && label == null) {
                holder.createErrorAnnotation((PsiElement)statement, GroovyBundle.message("break.outside.loop.or.switch", new Object[0]));
            }
        }
        if (statement instanceof GrBreakStatement && label != null && GroovyAnnotator.findFirstLoop(statement) == null) {
            holder.createErrorAnnotation((PsiElement)statement, GroovyBundle.message("break.outside.loop", new Object[0]));
        }
    }

    @Nullable
    private static GrLoopStatement findFirstLoop(GrFlowInterruptingStatement statement) {
        return (GrLoopStatement)PsiTreeUtil.getParentOfType((PsiElement)statement, GrLoopStatement.class, (boolean)true, (Class[])new Class[]{GrClosableBlock.class, GrMember.class, GroovyFile.class});
    }

    private static void checkThisOrSuperReferenceExpression(GrReferenceExpression ref, AnnotationHolder holder) {
        GrMember container;
        PsiElement nameElement = ref.getReferenceNameElement();
        if (nameElement == null) {
            return;
        }
        IElementType elementType = nameElement.getNode().getElementType();
        if (elementType != GroovyTokenTypes.kSUPER && elementType != GroovyTokenTypes.kTHIS) {
            return;
        }
        GrExpression qualifier = (GrExpression)ref.getQualifier();
        if (qualifier instanceof GrReferenceExpression) {
            PsiElement resolved = ((GrReferenceExpression)qualifier).resolve();
            if (resolved instanceof PsiClass) {
                Object[] superTypes;
                GrTypeDefinition containingClass = (GrTypeDefinition)PsiTreeUtil.getParentOfType((PsiElement)ref, GrTypeDefinition.class, (boolean)true, (Class[])new Class[]{GroovyFile.class});
                if (elementType == GroovyTokenTypes.kSUPER && containingClass != null && GrTraitUtil.isTrait((PsiClass)resolved) && ContainerUtil.find((Object[])(superTypes = containingClass.getSuperTypes()), type -> ref.getManager().areElementsEquivalent((PsiElement)type.resolve(), resolved)) != null) {
                    holder.createInfoAnnotation(nameElement, null).setTextAttributes(GroovySyntaxHighlighter.KEYWORD);
                    return;
                }
                if (containingClass == null || containingClass.getContainingClass() == null && !containingClass.isAnonymous()) {
                    holder.createErrorAnnotation((PsiElement)ref, GroovyBundle.message("qualified.0.is.allowed.only.in.nested.or.inner.classes", nameElement.getText()));
                    return;
                }
                if (PsiTreeUtil.isAncestor((PsiElement)resolved, (PsiElement)ref, (boolean)true)) {
                    if (PsiUtil.hasEnclosingInstanceInScope((PsiClass)resolved, ref, true)) {
                        holder.createInfoAnnotation(nameElement, null).setTextAttributes(GroovySyntaxHighlighter.KEYWORD);
                    }
                } else {
                    String qname = ((PsiClass)resolved).getQualifiedName();
                    assert (qname != null);
                    holder.createErrorAnnotation((PsiElement)ref, GroovyBundle.message("is.not.enclosing.class", qname));
                }
            }
        } else if (qualifier == null && elementType == GroovyTokenTypes.kSUPER && (container = (GrMember)PsiTreeUtil.getParentOfType((PsiElement)ref, (Class[])new Class[]{GrMethod.class, GrClassInitializer.class})) != null && container.hasModifierProperty("static")) {
            holder.createErrorAnnotation((PsiElement)ref, GroovyBundle.message("super.cannot.be.used.in.static.context", new Object[0]));
        }
    }

    private static void checkGrDocReferenceElement(AnnotationHolder holder, PsiElement element) {
        ASTNode node = element.getNode();
        if (node != null && TokenSets.BUILT_IN_TYPES.contains(node.getElementType())) {
            Annotation annotation = holder.createInfoAnnotation(element, null);
            annotation.setTextAttributes(GroovySyntaxHighlighter.KEYWORD);
        }
    }

    private static void checkAnnotationList(AnnotationHolder holder, @NotNull GrModifierList modifierList, String message) {
        PsiElement[] modifiers;
        if (modifierList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierList", "org/jetbrains/plugins/groovy/annotator/GroovyAnnotator", "checkAnnotationList"));
        }
        for (PsiElement modifier : modifiers = modifierList.getModifiers()) {
            if (modifier instanceof PsiAnnotation) continue;
            holder.createErrorAnnotation(modifier, message);
        }
    }

    private static void checkImplementedMethodsOfClass(AnnotationHolder holder, GrTypeDefinition typeDefinition) {
        if (typeDefinition.hasModifierProperty("abstract")) {
            return;
        }
        if (typeDefinition.isAnnotationType()) {
            return;
        }
        if (typeDefinition instanceof GrTypeParameter) {
            return;
        }
        PsiMethod abstractMethod = ClassUtil.getAnyAbstractMethod((PsiClass)typeDefinition);
        if (abstractMethod == null) {
            return;
        }
        String notImplementedMethodName = abstractMethod.getName();
        TextRange range = GrHighlightUtil.getClassHeaderTextRange(typeDefinition);
        Annotation annotation = holder.createErrorAnnotation(range, GroovyBundle.message("method.is.not.implemented", notImplementedMethodName));
        GroovyAnnotator.registerImplementsMethodsFix(typeDefinition, abstractMethod, annotation);
    }

    private static void registerImplementsMethodsFix(@NotNull GrTypeDefinition typeDefinition, @NotNull PsiMethod abstractMethod, @NotNull Annotation annotation) {
        if (typeDefinition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeDefinition", "org/jetbrains/plugins/groovy/annotator/GroovyAnnotator", "registerImplementsMethodsFix"));
        }
        if (abstractMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abstractMethod", "org/jetbrains/plugins/groovy/annotator/GroovyAnnotator", "registerImplementsMethodsFix"));
        }
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotation", "org/jetbrains/plugins/groovy/annotator/GroovyAnnotator", "registerImplementsMethodsFix"));
        }
        if (!OverrideImplementExploreUtil.getMethodsToOverrideImplement((PsiClass)typeDefinition, (boolean)true).isEmpty()) {
            annotation.registerFix((IntentionAction)QuickFixFactory.getInstance().createImplementMethodsFix((PsiClass)typeDefinition));
        }
        if (!JavaPsiFacade.getInstance((Project)typeDefinition.getProject()).getResolveHelper().isAccessible((PsiMember)abstractMethod, (PsiElement)typeDefinition, null)) {
            GroovyAnnotator.registerFix(annotation, new GrModifierFix((PsiMember)abstractMethod, "public", true, true, GrModifierFix.MODIFIER_LIST_OWNER), (PsiElement)abstractMethod);
            GroovyAnnotator.registerFix(annotation, new GrModifierFix((PsiMember)abstractMethod, "protected", true, true, GrModifierFix.MODIFIER_LIST_OWNER), (PsiElement)abstractMethod);
        }
        if (!(typeDefinition instanceof GrAnnotationTypeDefinition) && typeDefinition.getModifierList() != null) {
            GroovyAnnotator.registerFix(annotation, new GrModifierFix(typeDefinition, "abstract", false, true, GrModifierFix.MODIFIER_LIST_OWNER), typeDefinition);
        }
    }

    private static void checkInnerMethod(AnnotationHolder holder, GrMethod grMethod) {
        PsiElement parent = grMethod.getParent();
        if (parent instanceof GrOpenBlock || parent instanceof GrClosableBlock) {
            holder.createErrorAnnotation(grMethod.getNameIdentifierGroovy(), GroovyBundle.message("Inner.methods.are.not.supported", new Object[0]));
        }
    }

    private static void registerMakeAbstractMethodNotAbstractFix(Annotation annotation, GrMethod method, boolean makeClassAbstract) {
        PsiModifierList list;
        PsiClass containingClass;
        if (method.getBlock() == null) {
            annotation.registerFix(QuickFixFactory.getInstance().createAddMethodBodyFix((PsiMethod)method));
        } else {
            annotation.registerFix(QuickFixFactory.getInstance().createDeleteMethodBodyFix((PsiMethod)method));
        }
        GroovyAnnotator.registerFix(annotation, new GrModifierFix(method, "abstract", false, false, GrModifierFix.MODIFIER_LIST_OWNER), method);
        if (makeClassAbstract && (containingClass = method.getContainingClass()) != null && (list = containingClass.getModifierList()) != null && !list.hasModifierProperty("abstract")) {
            GroovyAnnotator.registerFix(annotation, new GrModifierFix((PsiMember)containingClass, "abstract", false, true, GrModifierFix.MODIFIER_LIST_OWNER), (PsiElement)containingClass);
        }
    }

    private static void checkMethodDefinitionModifiers(AnnotationHolder holder, GrMethod method) {
        Annotation annotation;
        GrModifierList modifiersList = method.getModifierList();
        GroovyAnnotator.checkAccessModifiers(holder, modifiersList, method);
        GroovyAnnotator.checkDuplicateModifiers(holder, modifiersList, method);
        GroovyAnnotator.checkOverrideAnnotation(holder, modifiersList, method);
        GroovyAnnotator.checkModifierIsNotAllowed(modifiersList, "volatile", GroovyBundle.message("method.has.incorrect.modifier.volatile", new Object[0]), holder);
        GroovyAnnotator.checkForAbstractAndFinalCombination(holder, method, modifiersList);
        boolean isMethodAbstract = modifiersList.hasExplicitModifier("abstract");
        if (method.getParent() instanceof GroovyFileBase) {
            if (isMethodAbstract) {
                annotation = holder.createErrorAnnotation(GroovyAnnotator.getModifierOrList(modifiersList, "abstract"), GroovyBundle.message("script.method.cannot.have.modifier.abstract", new Object[0]));
                GroovyAnnotator.registerMakeAbstractMethodNotAbstractFix(annotation, method, false);
            }
            GroovyAnnotator.checkModifierIsNotAllowed(modifiersList, "native", GroovyBundle.message("script.cannot.have.modifier.native", new Object[0]), holder);
        } else if (method.getParent() != null && method.getParent().getParent() instanceof GrTypeDefinition) {
            GrTypeDefinition containingTypeDef = (GrTypeDefinition)method.getParent().getParent();
            if (containingTypeDef.isTrait()) {
                GroovyAnnotator.checkModifierIsNotAllowed(modifiersList, "protected", GroovyBundle.message("trait.method.cannot.be.protected", new Object[0]), holder);
            } else if (containingTypeDef.isInterface()) {
                GroovyAnnotator.checkModifierIsNotAllowed(modifiersList, "static", GroovyBundle.message("interface.must.have.no.static.method", new Object[0]), holder);
                GroovyAnnotator.checkModifierIsNotAllowed(modifiersList, "private", GroovyBundle.message("interface.members.are.not.allowed.to.be", "private"), holder);
                GroovyAnnotator.checkModifierIsNotAllowed(modifiersList, "protected", GroovyBundle.message("interface.members.are.not.allowed.to.be", "protected"), holder);
            } else if (containingTypeDef.isAnonymous()) {
                if (isMethodAbstract) {
                    Annotation annotation2 = holder.createErrorAnnotation(GroovyAnnotator.getModifierOrList(modifiersList, "abstract"), GroovyBundle.message("anonymous.class.cannot.have.abstract.method", new Object[0]));
                    GroovyAnnotator.registerMakeAbstractMethodNotAbstractFix(annotation2, method, false);
                }
            } else {
                GrModifierList typeDefModifiersList = containingTypeDef.getModifierList();
                LOG.assertTrue(typeDefModifiersList != null, (Object)"modifiers list must be not null");
                if (!typeDefModifiersList.hasModifierProperty("abstract") && isMethodAbstract) {
                    Annotation annotation3 = holder.createErrorAnnotation((PsiElement)modifiersList, GroovyBundle.message("only.abstract.class.can.have.abstract.method", new Object[0]));
                    GroovyAnnotator.registerMakeAbstractMethodNotAbstractFix(annotation3, method, true);
                }
            }
            if (method.isConstructor()) {
                GroovyAnnotator.checkModifierIsNotAllowed(modifiersList, "static", GroovyBundle.message("constructor.cannot.have.static.modifier", new Object[0]), holder);
            }
        }
        if (method.hasModifierProperty("native") && method.getBlock() != null) {
            annotation = holder.createErrorAnnotation(GroovyAnnotator.getModifierOrList(modifiersList, "native"), GroovyBundle.message("native.methods.cannot.have.body", new Object[0]));
            GroovyAnnotator.registerFix(annotation, new GrModifierFix((PsiMember)modifiersList.getParent(), "native", true, false, GrModifierFix.MODIFIER_LIST), modifiersList);
            annotation.registerFix(QuickFixFactory.getInstance().createDeleteMethodBodyFix((PsiMethod)method));
        }
    }

    private static void checkForAbstractAndFinalCombination(AnnotationHolder holder, GrMember member, GrModifierList modifiersList) {
        if (member.hasModifierProperty("final") && member.hasModifierProperty("abstract")) {
            Annotation annotation = holder.createErrorAnnotation((PsiElement)modifiersList, GroovyBundle.message("illegal.combination.of.modifiers.abstract.and.final", new Object[0]));
            GroovyAnnotator.registerFix(annotation, new GrModifierFix(member, "final", false, false, GrModifierFix.MODIFIER_LIST), modifiersList);
            GroovyAnnotator.registerFix(annotation, new GrModifierFix(member, "abstract", false, false, GrModifierFix.MODIFIER_LIST), modifiersList);
        }
    }

    @NotNull
    private static PsiElement getModifierOrList(@NotNull GrModifierList modifiersList, @GrModifier.GrModifierConstant String modifier) {
        if (modifiersList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifiersList", "org/jetbrains/plugins/groovy/annotator/GroovyAnnotator", "getModifierOrList"));
        }
        PsiElement m = PsiUtil.findModifierInList(modifiersList, modifier);
        Object object = m != null ? m : modifiersList;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/annotator/GroovyAnnotator", "getModifierOrList"));
        }
        return object;
    }

    private static void checkOverrideAnnotation(AnnotationHolder holder, GrModifierList list, GrMethod method) {
        PsiAnnotation overrideAnnotation = list.findAnnotation("java.lang.Override");
        if (overrideAnnotation == null) {
            return;
        }
        try {
            MethodSignatureBackedByPsiMethod superMethod = (MethodSignatureBackedByPsiMethod)SuperMethodsSearch.search((PsiMethod)method, null, (boolean)true, (boolean)false).findFirst();
            if (superMethod == null) {
                holder.createWarningAnnotation((PsiElement)overrideAnnotation, GroovyBundle.message("method.doesnot.override.super", new Object[0]));
            }
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
    }

    private static void checkTypeDefinitionModifiers(AnnotationHolder holder, GrTypeDefinition typeDefinition) {
        PsiClassType[] extendsListTypes;
        GrModifierList modifiersList = typeDefinition.getModifierList();
        if (modifiersList == null) {
            return;
        }
        GroovyAnnotator.checkAccessModifiers(holder, modifiersList, typeDefinition);
        GroovyAnnotator.checkDuplicateModifiers(holder, modifiersList, typeDefinition);
        for (PsiClassType classType : extendsListTypes = typeDefinition.getExtendsListTypes()) {
            PsiClass psiClass = classType.resolve();
            if (psiClass == null || !psiClass.hasModifierProperty("final")) continue;
            Annotation annotation = holder.createErrorAnnotation(typeDefinition.getNameIdentifierGroovy(), GroovyBundle.message("final.class.cannot.be.extended", new Object[0]));
            GroovyAnnotator.registerFix(annotation, new GrModifierFix(typeDefinition, "final", false, false, GrModifierFix.MODIFIER_LIST_OWNER), typeDefinition);
        }
        if (!typeDefinition.isEnum()) {
            GroovyAnnotator.checkForAbstractAndFinalCombination(holder, typeDefinition, modifiersList);
        }
        GroovyAnnotator.checkModifierIsNotAllowed(modifiersList, "transient", GroovyBundle.message("modifier.transient.not.allowed.here", new Object[0]), holder);
        GroovyAnnotator.checkModifierIsNotAllowed(modifiersList, "volatile", GroovyBundle.message("modifier.volatile.not.allowed.here", new Object[0]), holder);
        if (typeDefinition.isInterface()) {
            GroovyAnnotator.checkModifierIsNotAllowed(modifiersList, "final", GroovyBundle.message("intarface.cannot.have.modifier.final", new Object[0]), holder);
        }
    }

    private static void checkDuplicateModifiers(AnnotationHolder holder, @NotNull GrModifierList list, PsiMember member) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/plugins/groovy/annotator/GroovyAnnotator", "checkDuplicateModifiers"));
        }
        PsiElement[] modifiers = list.getModifiers();
        THashSet set = new THashSet(modifiers.length);
        for (PsiElement modifier : modifiers) {
            if (modifier instanceof GrAnnotation) continue;
            String name = modifier.getText();
            if (set.contains(name)) {
                Annotation annotation = holder.createErrorAnnotation((PsiElement)list, GroovyBundle.message("duplicate.modifier", name));
                GroovyAnnotator.registerFix(annotation, new GrModifierFix(member, name, false, false, GrModifierFix.MODIFIER_LIST), list);
                continue;
            }
            set.add(name);
        }
    }

    private static void checkAccessModifiers(AnnotationHolder holder, @NotNull GrModifierList modifierList, PsiMember member) {
        if (modifierList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierList", "org/jetbrains/plugins/groovy/annotator/GroovyAnnotator", "checkAccessModifiers"));
        }
        boolean hasPrivate = modifierList.hasExplicitModifier("private");
        boolean hasPublic = modifierList.hasExplicitModifier("public");
        boolean hasProtected = modifierList.hasExplicitModifier("protected");
        if (hasPrivate && hasPublic || hasPrivate && hasProtected || hasPublic && hasProtected) {
            Annotation annotation = holder.createErrorAnnotation((PsiElement)modifierList, GroovyBundle.message("illegal.combination.of.modifiers", new Object[0]));
            if (hasPrivate) {
                GroovyAnnotator.registerFix(annotation, new GrModifierFix(member, "private", false, false, GrModifierFix.MODIFIER_LIST), modifierList);
            }
            if (hasProtected) {
                GroovyAnnotator.registerFix(annotation, new GrModifierFix(member, "protected", false, false, GrModifierFix.MODIFIER_LIST), modifierList);
            }
            if (hasPublic) {
                GroovyAnnotator.registerFix(annotation, new GrModifierFix(member, "public", false, false, GrModifierFix.MODIFIER_LIST), modifierList);
            }
        } else if (member instanceof PsiClass && member.getContainingClass() == null && GroovyConfigUtils.getInstance().isVersionAtLeast((PsiElement)member, "2.0")) {
            GroovyAnnotator.checkModifierIsNotAllowed(modifierList, "private", GroovyBundle.message("top.level.class.maynot.have.private.modifier", new Object[0]), holder);
            GroovyAnnotator.checkModifierIsNotAllowed(modifierList, "protected", GroovyBundle.message("top.level.class.maynot.have.protected.modifier", new Object[0]), holder);
        }
    }

    private void checkDuplicateMethod(@NotNull GrMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/groovy/annotator/GroovyAnnotator", "checkDuplicateMethod"));
        }
        PsiClass clazz = method.getContainingClass();
        if (clazz == null) {
            return;
        }
        GrReflectedMethod[] reflectedMethods = method.getReflectedMethods();
        if (reflectedMethods.length == 0) {
            this.doCheckDuplicateMethod(method, clazz);
        } else {
            for (GrReflectedMethod reflectedMethod : reflectedMethods) {
                this.doCheckDuplicateMethod(reflectedMethod, clazz);
            }
        }
    }

    private void doCheckDuplicateMethod(@NotNull GrMethod method, @NotNull PsiClass clazz) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/groovy/annotator/GroovyAnnotator", "doCheckDuplicateMethod"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/plugins/groovy/annotator/GroovyAnnotator", "doCheckDuplicateMethod"));
        }
        MethodSignature signature = GrClassImplUtil.getDuplicatedMethods(clazz).get(method);
        if (signature == null) {
            return;
        }
        String signaturePresentation = GroovyPresentationUtil.getSignaturePresentation(signature);
        GrMethod original = method instanceof GrReflectedMethod ? ((GrReflectedMethod)method).getBaseMethod() : method;
        this.myHolder.createErrorAnnotation(GrHighlightUtil.getMethodHeaderTextRange(original), GroovyBundle.message("method.duplicate", signaturePresentation, clazz.getName()));
    }

    private static void checkTypeDefinition(AnnotationHolder holder, GrTypeDefinition typeDefinition) {
        GroovyConfigUtils configUtils = GroovyConfigUtils.getInstance();
        if (typeDefinition.isAnonymous()) {
            PsiClass superClass;
            if (!configUtils.isVersionAtLeast(typeDefinition, "1.7")) {
                holder.createErrorAnnotation(typeDefinition.getNameIdentifierGroovy(), GroovyBundle.message("anonymous.classes.are.not.supported", configUtils.getSDKVersion(typeDefinition)));
            }
            if ((superClass = ((PsiAnonymousClass)typeDefinition).getBaseClassType().resolve()) instanceof GrTypeDefinition && ((GrTypeDefinition)superClass).isTrait()) {
                holder.createErrorAnnotation(typeDefinition.getNameIdentifierGroovy(), GroovyBundle.message("anonymous.classes.cannot.be.created.from.traits", new Object[0]));
            }
        } else if (typeDefinition.isTrait()) {
            if (!configUtils.isVersionAtLeast(typeDefinition, "2.3")) {
                ASTNode keyword = typeDefinition.getNode().findChildByType(GroovyTokenTypes.kTRAIT);
                assert (keyword != null);
                holder.createErrorAnnotation(keyword, GroovyBundle.message("traits.are.not.supported.in.groovy.0", configUtils.getSDKVersion(typeDefinition)));
            }
        } else if (typeDefinition.getContainingClass() != null && !(typeDefinition instanceof GrEnumTypeDefinition) && !configUtils.isVersionAtLeast(typeDefinition, "1.7")) {
            holder.createErrorAnnotation(typeDefinition.getNameIdentifierGroovy(), GroovyBundle.message("inner.classes.are.not.supported", configUtils.getSDKVersion(typeDefinition)));
        }
        if (typeDefinition.isAnnotationType() && typeDefinition.getContainingClass() != null) {
            holder.createErrorAnnotation(typeDefinition.getNameIdentifierGroovy(), GroovyBundle.message("annotation.type.cannot.be.inner", new Object[0]));
        }
        GroovyAnnotator.checkDuplicateClass(typeDefinition, holder);
        GroovyAnnotator.checkCyclicInheritance(holder, typeDefinition);
    }

    private static void checkCyclicInheritance(AnnotationHolder holder, GrTypeDefinition typeDefinition) {
        PsiClass psiClass = HighlightClassUtil.getCircularClass((PsiClass)typeDefinition, (Collection)new com.intellij.util.containers.HashSet());
        if (psiClass != null) {
            String qname = psiClass.getQualifiedName();
            assert (qname != null);
            holder.createErrorAnnotation(GrHighlightUtil.getClassHeaderTextRange(typeDefinition), GroovyBundle.message("cyclic.inheritance.involving.0", qname));
        }
    }

    private static void checkForWildCards(AnnotationHolder holder, @Nullable GrReferenceList clause) {
        GrCodeReferenceElement[] elements;
        if (clause == null) {
            return;
        }
        for (GrCodeReferenceElement element : elements = clause.getReferenceElementsGroovy()) {
            GrTypeArgumentList list = element.getTypeArgumentList();
            if (list == null) continue;
            for (GrTypeElement type : list.getTypeArgumentElements()) {
                if (!(type instanceof GrWildcardTypeArgument)) continue;
                holder.createErrorAnnotation((PsiElement)type, GroovyBundle.message("wildcards.are.not.allowed.in.extends.list", new Object[0]));
            }
        }
    }

    private static void checkDuplicateClass(GrTypeDefinition typeDefinition, AnnotationHolder holder) {
        GlobalSearchScope scope;
        JavaPsiFacade facade;
        PsiClass[] classes;
        String qName;
        String containingClassName;
        PsiClass containingClass = typeDefinition.getContainingClass();
        String name = typeDefinition.getName();
        if (containingClass != null && (containingClassName = containingClass.getName()) != null && containingClassName.equals(name)) {
            holder.createErrorAnnotation(typeDefinition.getNameIdentifierGroovy(), GroovyBundle.message("duplicate.inner.class", name));
        }
        if ((qName = typeDefinition.getQualifiedName()) != null && (classes = (facade = JavaPsiFacade.getInstance((Project)typeDefinition.getProject())).findClasses(qName, scope = GroovyAnnotator.inferClassScopeForSearchingDuplicates(typeDefinition))).length > 1) {
            String packageName = GroovyAnnotator.getPackageName(typeDefinition);
            if (!GroovyAnnotator.isScriptGeneratedClass(classes)) {
                holder.createErrorAnnotation(typeDefinition.getNameIdentifierGroovy(), GroovyBundle.message("duplicate.class", name, packageName));
            } else {
                holder.createErrorAnnotation(typeDefinition.getNameIdentifierGroovy(), GroovyBundle.message("script.generated.with.same.name", qName));
            }
        }
    }

    private static GlobalSearchScope inferClassScopeForSearchingDuplicates(GrTypeDefinition typeDefinition) {
        Module module;
        GlobalSearchScope defaultScope = typeDefinition.getResolveScope();
        PsiFile file = typeDefinition.getContainingFile();
        if (file instanceof GroovyFile && ((GroovyFile)file).isScript() && (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file)) != null) {
            return defaultScope.intersectWith(module.getModuleScope());
        }
        return defaultScope;
    }

    private static String getPackageName(GrTypeDefinition typeDefinition) {
        String name;
        PsiFile file = typeDefinition.getContainingFile();
        String packageName = "<default package>";
        if (file instanceof GroovyFile && !(name = ((GroovyFile)file).getPackageName()).isEmpty()) {
            packageName = name;
        }
        return packageName;
    }

    private static boolean isScriptGeneratedClass(PsiClass[] allClasses) {
        return allClasses.length == 2 && (allClasses[0] instanceof GroovyScriptClass || allClasses[1] instanceof GroovyScriptClass);
    }
}

