/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.config;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.libraries.AddCustomLibraryDialog;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import com.intellij.ui.EditorNotificationPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.annotator.GroovyFrameworkConfigNotification;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.config.GroovyLibraryDescription;

public class DefaultGroovyFrameworkConfigNotification
extends GroovyFrameworkConfigNotification {
    @Override
    public boolean hasFrameworkStructure(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/config/DefaultGroovyFrameworkConfigNotification", "hasFrameworkStructure"));
        }
        return true;
    }

    @Override
    public boolean hasFrameworkLibrary(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/config/DefaultGroovyFrameworkConfigNotification", "hasFrameworkLibrary"));
        }
        Library[] libraries = GroovyConfigUtils.getInstance().getSDKLibrariesByModule(module);
        return libraries.length > 0;
    }

    public EditorNotificationPanel createConfigureNotificationPanel(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/config/DefaultGroovyFrameworkConfigNotification", "createConfigureNotificationPanel"));
        }
        EditorNotificationPanel panel = new EditorNotificationPanel();
        panel.setText(GroovyBundle.message("groovy.library.is.not.configured.for.module", module.getName()));
        panel.createActionLabel(GroovyBundle.message("configure.groovy.library", new Object[0]), () -> {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/groovy/config/DefaultGroovyFrameworkConfigNotification", "lambda$createConfigureNotificationPanel$0"));
            }
            AddCustomLibraryDialog.createDialog((CustomLibraryDescription)new GroovyLibraryDescription(), (Module)module, null).show();
        });
        return panel;
    }
}

