/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef;

import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef.code.BodyCodeMembersProvider;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef.code.GrCodeMembersProvider;
import org.jetbrains.plugins.groovy.lang.psi.util.GrClassImplUtil;
import org.jetbrains.plugins.groovy.transformations.TransformationResult;
import org.jetbrains.plugins.groovy.transformations.TransformationUtilKt;

public class GrTypeDefinitionMembersCache<T extends GrTypeDefinition> {
    private final SimpleModificationTracker myTreeChangeTracker;
    private final T myDefinition;
    private final GrCodeMembersProvider<? super T> myCodeMembersProvider;
    private final Collection<?> myDependencies;

    public GrTypeDefinitionMembersCache(@NotNull T definition) {
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionMembersCache", "<init>"));
        }
        this((GrTypeDefinition)definition, BodyCodeMembersProvider.INSTANCE);
    }

    public GrTypeDefinitionMembersCache(@NotNull T definition, @NotNull GrCodeMembersProvider<? super T> provider) {
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionMembersCache", "<init>"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionMembersCache", "<init>"));
        }
        this.myTreeChangeTracker = new SimpleModificationTracker();
        this.myDependencies = Arrays.asList(this.myTreeChangeTracker, PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT);
        this.myDefinition = definition;
        this.myCodeMembersProvider = provider;
    }

    public void dropCaches() {
        this.myTreeChangeTracker.incModificationCount();
    }

    public GrTypeDefinition[] getCodeInnerClasses() {
        return (GrTypeDefinition[])CachedValuesManager.getCachedValue(this.myDefinition, () -> CachedValueProvider.Result.create((Object)this.myCodeMembersProvider.getCodeInnerClasses(this.myDefinition), this.myDependencies));
    }

    public GrMethod[] getCodeMethods() {
        return (GrMethod[])CachedValuesManager.getCachedValue(this.myDefinition, () -> CachedValueProvider.Result.create((Object)this.myCodeMembersProvider.getCodeMethods(this.myDefinition), this.myDependencies));
    }

    public GrMethod[] getCodeConstructors() {
        return (GrMethod[])CachedValuesManager.getCachedValue(this.myDefinition, () -> CachedValueProvider.Result.create((Object)GrClassImplUtil.getCodeConstructors(this.myDefinition), this.myDependencies));
    }

    public GrField[] getCodeFields() {
        return (GrField[])CachedValuesManager.getCachedValue(this.myDefinition, () -> CachedValueProvider.Result.create((Object)this.myCodeMembersProvider.getCodeFields(this.myDefinition), this.myDependencies));
    }

    public PsiClass[] getInnerClasses() {
        return this.getTransformationResult().getInnerClasses();
    }

    public PsiMethod[] getMethods() {
        return this.getTransformationResult().getMethods();
    }

    public PsiMethod[] getConstructors() {
        assert (!TransformationUtilKt.isUnderTransformation(this.myDefinition));
        return (PsiMethod[])CachedValuesManager.getCachedValue(this.myDefinition, () -> CachedValueProvider.Result.create((Object)GrClassImplUtil.getConstructors(this.myDefinition), this.myDependencies));
    }

    public GrField[] getFields() {
        return this.getTransformationResult().getFields();
    }

    @NotNull
    public PsiClassType[] getExtendsListTypes(boolean includeSynthetic) {
        if (includeSynthetic && TransformationUtilKt.isUnderTransformation(this.myDefinition)) {
            includeSynthetic = false;
        }
        PsiClassType[] psiClassTypeArray = (PsiClassType[])CachedValuesManager.getCachedValue(this.myDefinition, (CachedValueProvider)(includeSynthetic ? () -> {
            PsiClassType[] extendsTypes = this.getTransformationResult().getExtendsTypes();
            PsiClassType[] result = GrClassImplUtil.getExtendsListTypes(this.myDefinition, extendsTypes);
            return CachedValueProvider.Result.create((Object)result, this.myDependencies);
        } : () -> {
            PsiClassType[] extendsTypes = GrClassImplUtil.getReferenceListTypes(this.myDefinition.getExtendsClause());
            PsiClassType[] result = GrClassImplUtil.getExtendsListTypes(this.myDefinition, extendsTypes);
            return CachedValueProvider.Result.create((Object)result, this.myDependencies);
        }));
        if (psiClassTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionMembersCache", "getExtendsListTypes"));
        }
        return psiClassTypeArray;
    }

    @NotNull
    public PsiClassType[] getImplementsListTypes(boolean includeSynthetic) {
        if (includeSynthetic && TransformationUtilKt.isUnderTransformation(this.myDefinition)) {
            includeSynthetic = false;
        }
        PsiClassType[] psiClassTypeArray = (PsiClassType[])CachedValuesManager.getCachedValue(this.myDefinition, (CachedValueProvider)(includeSynthetic ? () -> {
            PsiClassType[] implementsTypes = this.getTransformationResult().getImplementsTypes();
            PsiClassType[] result = GrClassImplUtil.getImplementsListTypes(this.myDefinition, implementsTypes);
            return CachedValueProvider.Result.create((Object)result, this.myDependencies);
        } : () -> {
            PsiClassType[] implementsTypes = GrClassImplUtil.getReferenceListTypes(this.myDefinition.getImplementsClause());
            PsiClassType[] result = GrClassImplUtil.getImplementsListTypes(this.myDefinition, implementsTypes);
            return CachedValueProvider.Result.create((Object)result, this.myDependencies);
        }));
        if (psiClassTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionMembersCache", "getImplementsListTypes"));
        }
        return psiClassTypeArray;
    }

    @NotNull
    private TransformationResult getTransformationResult() {
        assert (!TransformationUtilKt.isUnderTransformation(this.myDefinition));
        TransformationResult transformationResult = (TransformationResult)CachedValuesManager.getCachedValue(this.myDefinition, () -> CachedValueProvider.Result.create((Object)TransformationUtilKt.transformDefinition(this.myDefinition), this.myDependencies));
        if (transformationResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/GrTypeDefinitionMembersCache", "getTransformationResult"));
        }
        return transformationResult;
    }
}

