/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.statements.typedef.members;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiSuperMethodImplUtil;
import com.intellij.psi.presentation.java.JavaPresentationUtil;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.ui.RowIcon;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import icons.JetgroovyIcons;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentDescriptor;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.impl.GrDocCommentUtil;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GrNamedElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifier;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrNamedArgumentSearchVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrCodeBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrReflectedMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeParameterList;
import org.jetbrains.plugins.groovy.lang.psi.dataFlow.types.TypeInferenceHelper;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrStubElementBase;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyFileImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrReflectedMethodImpl;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrMethodStub;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.MethodTypeInferencer;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public abstract class GrMethodBaseImpl
extends GrStubElementBase<GrMethodStub>
implements GrMethod,
StubBasedPsiElement<GrMethodStub> {
    private static final Logger LOG = Logger.getInstance(GrMethodBaseImpl.class);
    private static final Function<GrMethodBaseImpl, PsiType> ourTypesCalculator = new NullableFunction<GrMethodBaseImpl, PsiType>(){

        private boolean hasTypeParametersToInfer(PsiClassType classType) {
            PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
            PsiClass aClass = resolveResult.getElement();
            if (aClass == null) {
                return false;
            }
            Iterable iterable = com.intellij.psi.util.PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)aClass);
            if (!iterable.iterator().hasNext()) {
                return false;
            }
            for (PsiTypeParameter parameter : iterable) {
                PsiType type = resolveResult.getSubstitutor().substitute(parameter);
                if (type == null || type instanceof PsiWildcardType && ((PsiWildcardType)type).getBound() == null) continue;
                return false;
            }
            return true;
        }

        public PsiType fun(GrMethodBaseImpl method) {
            PsiType inferred;
            PsiType nominal = method.getNominalType();
            if (!(nominal == null || nominal instanceof PsiClassType && this.hasTypeParametersToInfer((PsiClassType)nominal))) {
                return nominal;
            }
            GrOpenBlock block = method.getBlock();
            if (block != null && (inferred = GroovyPsiManager.inferType(method, new MethodTypeInferencer(block))) != null && (nominal == null || nominal.isAssignableFrom(inferred))) {
                return inferred;
            }
            if (nominal != null) {
                return nominal;
            }
            return TypesUtil.getJavaLangObject(method);
        }
    };

    protected GrMethodBaseImpl(GrMethodStub stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    public GrMethodBaseImpl(ASTNode node) {
        super(node);
    }

    @Override
    public PsiElement getParent() {
        return this.getDefinitionParent();
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitMethod(this);
    }

    public int getTextOffset() {
        return this.getNameIdentifierGroovy().getTextRange().getStartOffset();
    }

    @Override
    @NotNull
    public PsiElement getNameIdentifierGroovy() {
        PsiElement psiElement = this.findNotNullChildByType(TokenSets.PROPERTY_NAMES);
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl", "getNameIdentifierGroovy"));
        }
        return psiElement;
    }

    @Override
    @Nullable
    public GrOpenBlock getBlock() {
        return (GrOpenBlock)this.findChildByClass(GrOpenBlock.class);
    }

    @Override
    public void setBlock(GrCodeBlock newBlock) {
        ASTNode newNode = newBlock.getNode().copyElement();
        GrOpenBlock oldBlock = this.getBlock();
        if (oldBlock == null) {
            this.getNode().addChild(newNode);
            return;
        }
        this.getNode().replaceChild(oldBlock.getNode(), newNode);
    }

    @Override
    public GrParameter[] getParameters() {
        return this.getParameterList().getParameters();
    }

    @Override
    @Nullable
    public GrTypeElement getReturnTypeElementGroovy() {
        GrMethodStub stub = (GrMethodStub)this.getStub();
        if (stub != null) {
            String typeText = stub.getTypeText();
            if (typeText != null) {
                return GroovyPsiElementFactory.getInstance(this.getProject()).createTypeElement(typeText, this);
            }
            return null;
        }
        return (GrTypeElement)this.findChildByType(TokenSets.TYPE_ELEMENTS);
    }

    @Override
    public PsiType getInferredReturnType() {
        if (this.isConstructor()) {
            return null;
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            // empty if block
        }
        return TypeInferenceHelper.getCurrentContext().getExpressionType(this, ourTypesCalculator);
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, @Nullable PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl", "processDeclarations"));
        }
        ElementClassHint classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
        if (ResolveUtil.shouldProcessClasses(classHint)) {
            for (GrNamedElement grNamedElement : this.getTypeParameters()) {
                if (ResolveUtil.processElement(processor, grNamedElement, state)) continue;
                return false;
            }
        }
        if (ResolveUtil.shouldProcessProperties(classHint)) {
            for (GrNamedElement grNamedElement : this.getParameters()) {
                if (ResolveUtil.processElement(processor, grNamedElement, state)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public GrMember[] getMembers() {
        return new GrMember[]{this};
    }

    @Override
    @Nullable
    public PsiType getReturnType() {
        if (this.isConstructor()) {
            return null;
        }
        PsiType type = this.getNominalType();
        if (type != null) {
            return type;
        }
        return TypesUtil.getJavaLangObject(this);
    }

    @Nullable
    private PsiType getNominalType() {
        if (PsiImplUtil.isMainMethod(this)) {
            return PsiType.VOID;
        }
        GrTypeElement element = this.getReturnTypeElementGroovy();
        if (element != null) {
            return element.getType();
        }
        return null;
    }

    @Override
    @Nullable
    public GrTypeElement setReturnType(@Nullable PsiType newReturnType) {
        GrTypeElement newTypeElement;
        GrTypeElement typeElement = this.getReturnTypeElementGroovy();
        if (newReturnType == null || newReturnType == PsiType.NULL) {
            if (typeElement != null) {
                typeElement.delete();
            }
            this.insertPlaceHolderToModifierList();
            return null;
        }
        GrTypeElement stub = GroovyPsiElementFactory.getInstance(this.getProject()).createTypeElement(newReturnType);
        if (typeElement == null) {
            GrTypeParameterList typeParemeterList = this.getTypeParameterList();
            GroovyPsiElement anchor = typeParemeterList != null ? typeParemeterList : this.getModifierList();
            newTypeElement = (GrTypeElement)this.addAfter(stub, anchor);
        } else {
            newTypeElement = (GrTypeElement)typeElement.replace(stub);
        }
        return newTypeElement;
    }

    private void insertPlaceHolderToModifierList() {
        GrModifierList list = this.getModifierList();
        PsiImplUtil.insertPlaceHolderToModifierListAtEndIfNeeded(list);
    }

    protected boolean isVisibilitySupported() {
        return true;
    }

    @Nullable
    protected Icon getElementIcon(@Iconable.IconFlags int flags) {
        RowIcon baseIcon = ElementPresentationUtil.createLayeredIcon((Icon)JetgroovyIcons.Groovy.Method, (PsiModifierListOwner)this, (boolean)false);
        return ElementPresentationUtil.addVisibilityIcon((PsiModifierListOwner)this, (int)flags, (RowIcon)baseIcon);
    }

    public ItemPresentation getPresentation() {
        return JavaPresentationUtil.getMethodPresentation((PsiMethod)this);
    }

    @Nullable
    public PsiTypeElement getReturnTypeElement() {
        return PsiImplUtil.getOrCreateTypeElement(this.getReturnTypeElementGroovy());
    }

    @Override
    @NotNull
    public GrParameterList getParameterList() {
        GrParameterList parameterList = (GrParameterList)this.getStubOrPsiChild((IStubElementType)GroovyElementTypes.PARAMETERS_LIST);
        LOG.assertTrue(parameterList != null);
        GrParameterList grParameterList = parameterList;
        if (grParameterList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl", "getParameterList"));
        }
        return grParameterList;
    }

    @NotNull
    public PsiReferenceList getThrowsList() {
        PsiReferenceList psiReferenceList = (PsiReferenceList)ObjectUtils.assertNotNull((Object)this.getStubOrPsiChild(GroovyElementTypes.THROW_CLAUSE));
        if (psiReferenceList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl", "getThrowsList"));
        }
        return psiReferenceList;
    }

    @Nullable
    public PsiCodeBlock getBody() {
        return PsiImplUtil.getOrCreatePsiCodeBlock(this.getBlock());
    }

    public boolean isConstructor() {
        return false;
    }

    @Override
    public boolean isVarArgs() {
        return PsiImplUtil.isVarArgs(this.getParameters());
    }

    @NotNull
    public MethodSignature getSignature(@NotNull PsiSubstitutor substitutor) {
        if (substitutor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "substitutor", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl", "getSignature"));
        }
        MethodSignatureBackedByPsiMethod methodSignatureBackedByPsiMethod = MethodSignatureBackedByPsiMethod.create((PsiMethod)this, (PsiSubstitutor)substitutor);
        if (methodSignatureBackedByPsiMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl", "getSignature"));
        }
        return methodSignatureBackedByPsiMethod;
    }

    @Nullable
    public PsiIdentifier getNameIdentifier() {
        return PsiUtil.getJavaNameIdentifier(this);
    }

    @NotNull
    public PsiMethod[] findDeepestSuperMethods() {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findDeepestSuperMethods((PsiMethod)this);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl", "findDeepestSuperMethods"));
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiMethod[] findSuperMethods(boolean checkAccess) {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this, (boolean)checkAccess);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl", "findSuperMethods"));
        }
        return psiMethodArray;
    }

    @NotNull
    public PsiMethod[] findSuperMethods(PsiClass parentClass) {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this, (PsiClass)parentClass);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl", "findSuperMethods"));
        }
        return psiMethodArray;
    }

    @NotNull
    public List<MethodSignatureBackedByPsiMethod> findSuperMethodSignaturesIncludingStatic(boolean checkAccess) {
        List list = PsiSuperMethodImplUtil.findSuperMethodSignaturesIncludingStatic((PsiMethod)this, (boolean)checkAccess);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl", "findSuperMethodSignaturesIncludingStatic"));
        }
        return list;
    }

    @NotNull
    public PsiMethod[] findSuperMethods() {
        PsiMethod[] psiMethodArray = PsiSuperMethodImplUtil.findSuperMethods((PsiMethod)this);
        if (psiMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl", "findSuperMethods"));
        }
        return psiMethodArray;
    }

    @Nullable
    public PsiMethod findDeepestSuperMethod() {
        PsiMethod[] methods = this.findDeepestSuperMethods();
        if (methods.length > 0) {
            return methods[0];
        }
        return null;
    }

    @Override
    @NotNull
    public GrModifierList getModifierList() {
        GrModifierList grModifierList = (GrModifierList)ObjectUtils.assertNotNull((Object)this.getStubOrPsiChild(GroovyElementTypes.MODIFIERS));
        if (grModifierList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl", "getModifierList"));
        }
        return grModifierList;
    }

    public boolean hasModifierProperty(@GrModifier.GrModifierConstant @NonNls @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl", "hasModifierProperty"));
        }
        return this.getModifierList().hasModifierProperty(name);
    }

    @Override
    @NotNull
    public String getName() {
        GrMethodStub stub = (GrMethodStub)this.getStub();
        if (stub != null) {
            String string = stub.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl", "getName"));
            }
            return string;
        }
        String string = PsiImplUtil.getName(this);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl", "getName"));
        }
        return string;
    }

    @NotNull
    public HierarchicalMethodSignature getHierarchicalMethodSignature() {
        HierarchicalMethodSignature hierarchicalMethodSignature = PsiSuperMethodImplUtil.getHierarchicalMethodSignature((PsiMethod)this);
        if (hierarchicalMethodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl", "getHierarchicalMethodSignature"));
        }
        return hierarchicalMethodSignature;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        PsiElement newNameElement;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl", "setName"));
        }
        PsiElement nameElement = this.getNameIdentifierGroovy();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(nameElement.getProject());
        if (PsiNameHelper.getInstance((Project)this.getProject()).isIdentifier(name)) {
            try {
                GrMethod method = factory.createMethod(name, null);
                newNameElement = method.getNameIdentifierGroovy();
            }
            catch (IncorrectOperationException e) {
                newNameElement = factory.createLiteralFromValue(name).getFirstChild();
            }
        } else {
            newNameElement = factory.createLiteralFromValue(name).getFirstChild();
        }
        nameElement.replace(newNameElement);
        return this;
    }

    @Override
    public boolean hasTypeParameters() {
        return this.getTypeParameters().length > 0;
    }

    @Override
    @Nullable
    public GrTypeParameterList getTypeParameterList() {
        return (GrTypeParameterList)this.getStubOrPsiChild((IStubElementType)GroovyElementTypes.TYPE_PARAMETER_LIST);
    }

    @NotNull
    public GrTypeParameter[] getTypeParameters() {
        GrTypeParameterList list = this.getTypeParameterList();
        if (list != null) {
            GrTypeParameter[] grTypeParameterArray = list.getTypeParameters();
            if (grTypeParameterArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl", "getTypeParameters"));
            }
            return grTypeParameterArray;
        }
        if (GrTypeParameter.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl", "getTypeParameters"));
        }
        return GrTypeParameter.EMPTY_ARRAY;
    }

    public PsiClass getContainingClass() {
        PsiElement pparent;
        PsiElement parent = this.getParent();
        if (parent instanceof GrTypeDefinitionBody && (pparent = parent.getParent()) instanceof PsiClass) {
            return (PsiClass)pparent;
        }
        PsiFile file = this.getContainingFile();
        if (file instanceof GroovyFileBase) {
            return ((GroovyFileBase)file).getScriptClass();
        }
        return null;
    }

    @Override
    @Nullable
    public GrDocComment getDocComment() {
        return GrDocCommentUtil.findDocComment(this);
    }

    @Override
    public boolean isDeprecated() {
        GrMethodStub stub = (GrMethodStub)this.getStub();
        if (stub != null) {
            return stub.isDeprecatedByDoc() || com.intellij.psi.impl.PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)this);
        }
        return com.intellij.psi.impl.PsiImplUtil.isDeprecatedByDocTag((PsiDocCommentOwner)this) || com.intellij.psi.impl.PsiImplUtil.isDeprecatedByAnnotation((PsiModifierListOwner)this);
    }

    @NotNull
    public SearchScope getUseScope() {
        SearchScope searchScope = com.intellij.psi.impl.PsiImplUtil.getMemberUseScope((PsiMember)this);
        if (searchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl", "getUseScope"));
        }
        return searchScope;
    }

    public PsiElement getOriginalElement() {
        PsiClass containingClass = this.getContainingClass();
        if (containingClass == null) {
            return this;
        }
        PsiClass originalClass = (PsiClass)containingClass.getOriginalElement();
        PsiMethod originalMethod = originalClass.findMethodBySignature((PsiMethod)this, false);
        return originalMethod != null ? originalMethod : this;
    }

    @Override
    public void delete() throws IncorrectOperationException {
        PsiElement parent = this.getParent();
        if (parent instanceof GroovyFileImpl || parent instanceof GrTypeDefinitionBody) {
            super.delete();
            return;
        }
        throw new IncorrectOperationException("Invalid enclosing type definition");
    }

    @Override
    @NotNull
    public Map<String, NamedArgumentDescriptor> getNamedParameters() {
        GrMethodStub stub = (GrMethodStub)this.getStub();
        if (stub != null) {
            String[] namedParameters = stub.getNamedParameters();
            if (namedParameters.length == 0) {
                Map<String, NamedArgumentDescriptor> map = Collections.emptyMap();
                if (map == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl", "getNamedParameters"));
                }
                return map;
            }
            HashMap result = ContainerUtil.newHashMap();
            for (String parameter : namedParameters) {
                result.put(parameter, GrNamedArgumentSearchVisitor.CODE_NAMED_ARGUMENTS_DESCR);
            }
            HashMap hashMap = result;
            if (hashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl", "getNamedParameters"));
            }
            return hashMap;
        }
        GrOpenBlock body = this.getBlock();
        if (body == null) {
            Map<String, NamedArgumentDescriptor> map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl", "getNamedParameters"));
            }
            return map;
        }
        GrParameter[] parameters = this.getParameters();
        if (parameters.length == 0) {
            Map<String, NamedArgumentDescriptor> map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl", "getNamedParameters"));
            }
            return map;
        }
        GrParameter firstParameter = parameters[0];
        PsiType type = firstParameter.getTypeGroovy();
        GrTypeElement typeElement = firstParameter.getTypeElementGroovy();
        if (type != null && typeElement != null && type.getPresentableText() != null && !type.getPresentableText().endsWith("Map")) {
            Map<String, NamedArgumentDescriptor> map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl", "getNamedParameters"));
            }
            return map;
        }
        GrNamedArgumentSearchVisitor visitor = new GrNamedArgumentSearchVisitor(firstParameter.getNameIdentifierGroovy().getText());
        body.accept(visitor);
        Map<String, NamedArgumentDescriptor> map = visitor.getResult();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl", "getNamedParameters"));
        }
        return map;
    }

    public boolean isEquivalentTo(PsiElement another) {
        return PsiClassImplUtil.isMethodEquivalentTo((PsiMethod)this, (PsiElement)another);
    }

    @Override
    @NotNull
    public GrReflectedMethod[] getReflectedMethods() {
        GrReflectedMethod[] grReflectedMethodArray = GrReflectedMethodImpl.createReflectedMethods(this);
        if (grReflectedMethodArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/statements/typedef/members/GrMethodBaseImpl", "getReflectedMethods"));
        }
        return grReflectedMethodArray;
    }
}

