/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.stubs.elements;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.ArrayUtil;
import java.io.IOException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrReferenceList;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrReferenceListStub;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrStubUtils;
import org.jetbrains.plugins.groovy.lang.psi.stubs.elements.GrStubElementType;
import org.jetbrains.plugins.groovy.lang.psi.stubs.index.GrDirectInheritorsIndex;

public abstract class GrReferenceListElementType<T extends GrReferenceList>
extends GrStubElementType<GrReferenceListStub, T> {
    public GrReferenceListElementType(String debugName) {
        super(debugName);
    }

    public GrReferenceListStub createStub(@NotNull T psi, StubElement parentStub) {
        if (psi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psi", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrReferenceListElementType", "createStub"));
        }
        ArrayList<String> refNames = new ArrayList<String>();
        for (GrCodeReferenceElement element : psi.getReferenceElementsGroovy()) {
            String name = GrStubUtils.getReferenceName(element);
            if (!StringUtil.isNotEmpty((String)name)) continue;
            refNames.add(name);
        }
        return new GrReferenceListStub(parentStub, this, ArrayUtil.toStringArray(refNames));
    }

    public void serialize(@NotNull GrReferenceListStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrReferenceListElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrReferenceListElementType", "serialize"));
        }
        GrStubUtils.writeStringArray(dataStream, stub.getBaseClasses());
    }

    @NotNull
    public GrReferenceListStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrReferenceListElementType", "deserialize"));
        }
        GrReferenceListStub grReferenceListStub = new GrReferenceListStub(parentStub, this, GrStubUtils.readStringArray(dataStream));
        if (grReferenceListStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrReferenceListElementType", "deserialize"));
        }
        return grReferenceListStub;
    }

    @Override
    public void indexStub(@NotNull GrReferenceListStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrReferenceListElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "org/jetbrains/plugins/groovy/lang/psi/stubs/elements/GrReferenceListElementType", "indexStub"));
        }
        for (String name : stub.getBaseClasses()) {
            if (name == null) continue;
            sink.occurrence(GrDirectInheritorsIndex.KEY, (Object)PsiNameHelper.getShortClassName((String)name));
        }
    }

    public boolean isLeftBound() {
        return true;
    }
}

