/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.introduce.field;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduceField.IntroduceFieldHandler;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.refactoring.util.RadioUpDownListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyNamesUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceContext;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceDialog;
import org.jetbrains.plugins.groovy.refactoring.introduce.GrIntroduceHandlerBase;
import org.jetbrains.plugins.groovy.refactoring.introduce.StringPartInfo;
import org.jetbrains.plugins.groovy.refactoring.introduce.field.GrFieldNameSuggester;
import org.jetbrains.plugins.groovy.refactoring.introduce.field.GrIntroduceFieldHandler;
import org.jetbrains.plugins.groovy.refactoring.introduce.field.GrIntroduceFieldSettings;
import org.jetbrains.plugins.groovy.refactoring.introduce.field.GroovyFieldValidator;
import org.jetbrains.plugins.groovy.refactoring.ui.GrTypeComboBox;

public class GrIntroduceFieldDialog
extends DialogWrapper
implements GrIntroduceDialog<GrIntroduceFieldSettings>,
GrIntroduceFieldSettings {
    private JPanel myContentPane;
    private NameSuggestionsField myNameField;
    private JRadioButton myPrivateRadioButton;
    private JRadioButton myProtectedRadioButton;
    private JRadioButton myPublicRadioButton;
    private JRadioButton myPropertyRadioButton;
    private JRadioButton myCurrentMethodRadioButton;
    private JRadioButton myFieldDeclarationRadioButton;
    private JRadioButton myClassConstructorSRadioButton;
    private JBRadioButton mySetUpMethodRadioButton;
    private JCheckBox myDeclareFinalCheckBox;
    private JCheckBox myReplaceAllOccurrencesCheckBox;
    private GrTypeComboBox myTypeComboBox;
    private JLabel myNameLabel;
    private JLabel myTypeLabel;
    private final boolean myIsStatic;
    private final boolean isInvokedInAlwaysInvokedConstructor;
    private final boolean hasLHSUsages;
    private final String myInvokedOnLocalVar;
    private final boolean myCanBeInitializedOutsideBlock;
    private final GrIntroduceContext myContext;

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    public GrIntroduceFieldDialog(GrIntroduceContext context) {
        super(context.getProject(), true);
        this.myContext = context;
        this.$$$setupUI$$$();
        PsiClass clazz = (PsiClass)context.getScope();
        PsiClass scope = clazz instanceof GroovyScriptClass ? clazz.getContainingFile() : clazz;
        this.myIsStatic = GrIntroduceFieldHandler.shouldBeStatic(context.getPlace(), (PsiElement)scope);
        this.initVisibility();
        ButtonGroup initialization = new ButtonGroup();
        ArrayList inits = ContainerUtil.newArrayList();
        inits.add(this.myCurrentMethodRadioButton);
        inits.add(this.myFieldDeclarationRadioButton);
        inits.add(this.myClassConstructorSRadioButton);
        if (TestFrameworks.getInstance().isTestClass(clazz)) {
            inits.add(this.mySetUpMethodRadioButton);
        } else {
            this.mySetUpMethodRadioButton.setVisible(false);
        }
        for (JRadioButton init : inits) {
            initialization.add(init);
        }
        new RadioUpDownListener(inits.toArray(new JRadioButton[inits.size()]));
        if (clazz instanceof GroovyScriptClass) {
            this.myClassConstructorSRadioButton.setEnabled(false);
        }
        this.myCanBeInitializedOutsideBlock = GrIntroduceFieldDialog.canBeInitializedOutsideBlock(context, clazz);
        GrMember container = GrIntroduceFieldHandler.getContainer(context.getPlace(), (PsiElement)scope);
        if (container == null) {
            this.myCurrentMethodRadioButton.setEnabled(false);
        }
        if (this.myCurrentMethodRadioButton.isEnabled()) {
            this.myCurrentMethodRadioButton.setSelected(true);
        } else {
            this.myFieldDeclarationRadioButton.setSelected(true);
        }
        String string = this.myInvokedOnLocalVar = context.getVar() == null ? GrIntroduceFieldDialog.getInvokedOnLocalVar(context.getExpression()) : context.getVar().getName();
        if (this.myInvokedOnLocalVar != null) {
            this.myReplaceAllOccurrencesCheckBox.setText("Replace all occurrences and remove variable '" + this.myInvokedOnLocalVar + "'");
            if (context.getVar() != null) {
                this.myReplaceAllOccurrencesCheckBox.setEnabled(false);
                this.myReplaceAllOccurrencesCheckBox.setSelected(true);
            }
        } else if (context.getOccurrences().length == 1) {
            this.myReplaceAllOccurrencesCheckBox.setSelected(false);
            this.myReplaceAllOccurrencesCheckBox.setVisible(false);
        }
        this.myNameField.addDataChangedListener(new NameSuggestionsField.DataChanged(){

            public void dataChanged() {
                GrIntroduceFieldDialog.this.validateOKAction();
            }
        });
        ItemListener l = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GrIntroduceFieldDialog.this.myNameField.requestFocusInWindow();
                GrIntroduceFieldDialog.this.checkErrors();
                if (GrIntroduceFieldDialog.this.myReplaceAllOccurrencesCheckBox.isSelected()) {
                    PsiElement anchor = GrIntroduceHandlerBase.findAnchor(GrIntroduceFieldDialog.this.myContext.getOccurrences(), GrIntroduceFieldDialog.this.myContext.getScope());
                    if (anchor != null && anchor != GrIntroduceFieldDialog.this.myContext.getScope() && anchor != ((GrTypeDefinition)GrIntroduceFieldDialog.this.myContext.getScope()).getBody()) {
                        GrIntroduceFieldDialog.this.myCurrentMethodRadioButton.setEnabled(true);
                    } else if (GrIntroduceFieldDialog.this.myCurrentMethodRadioButton.isEnabled()) {
                        GrIntroduceFieldDialog.this.myCurrentMethodRadioButton.setEnabled(false);
                        GrIntroduceFieldDialog.this.myFieldDeclarationRadioButton.setSelected(true);
                    }
                } else if (!GrIntroduceFieldDialog.this.myCurrentMethodRadioButton.isEnabled()) {
                    GrIntroduceFieldDialog.this.myCurrentMethodRadioButton.setEnabled(true);
                }
            }
        };
        this.myPrivateRadioButton.addItemListener(l);
        this.myProtectedRadioButton.addItemListener(l);
        this.myPublicRadioButton.addItemListener(l);
        this.myPropertyRadioButton.addItemListener(l);
        this.myCurrentMethodRadioButton.addItemListener(l);
        this.myFieldDeclarationRadioButton.addItemListener(l);
        this.myClassConstructorSRadioButton.addItemListener(l);
        this.myDeclareFinalCheckBox.addItemListener(l);
        this.myReplaceAllOccurrencesCheckBox.addItemListener(l);
        this.myTypeComboBox.addItemListener(l);
        this.isInvokedInAlwaysInvokedConstructor = container instanceof PsiMethod && GrIntroduceFieldDialog.allOccurrencesInOneMethod(this.myContext.getOccurrences(), (PsiElement)scope) && GrIntroduceFieldDialog.isAlwaysInvokedConstructor((PsiMethod)container, clazz);
        this.hasLHSUsages = GrIntroduceFieldDialog.hasLhsUsages(this.myContext);
        this.setTitle(IntroduceFieldHandler.REFACTORING_NAME);
        this.init();
        this.checkErrors();
    }

    private void checkErrors() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.myCurrentMethodRadioButton.isSelected() && this.myDeclareFinalCheckBox.isSelected() && !this.isInvokedInAlwaysInvokedConstructor) {
            errors.add(GroovyRefactoringBundle.message("final.field.cant.be.initialized.in.cur.method", new Object[0]));
        }
        if (this.myDeclareFinalCheckBox.isSelected() && this.myReplaceAllOccurrencesCheckBox.isSelected() && this.myInvokedOnLocalVar != null && this.hasLHSUsages) {
            errors.add(GroovyRefactoringBundle.message("Field.cannot.be.final.because.replaced.variable.has.lhs.usages", new Object[0]));
        }
        if (!this.myCanBeInitializedOutsideBlock) {
            if (this.myFieldDeclarationRadioButton.isSelected()) {
                errors.add(GroovyRefactoringBundle.message("field.cannot.be.initialized.in.field.declaration", new Object[0]));
            } else if (this.myClassConstructorSRadioButton.isSelected()) {
                errors.add(GroovyRefactoringBundle.message("field.cannot.be.initialized.in.constructor(s)", new Object[0]));
            }
        }
        if (errors.isEmpty()) {
            this.setErrorText(null);
        } else {
            this.setErrorText(StringUtil.join(errors, (String)"\n"));
        }
    }

    private static boolean hasLhsUsages(@NotNull GrIntroduceContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldDialog", "hasLhsUsages"));
        }
        if (context.getVar() == null && !(context.getExpression() instanceof GrReferenceExpression)) {
            return false;
        }
        return GrIntroduceHandlerBase.hasLhs(context.getOccurrences());
    }

    private void initVisibility() {
        ButtonGroup visibility = new ButtonGroup();
        visibility.add(this.myPrivateRadioButton);
        visibility.add(this.myProtectedRadioButton);
        visibility.add(this.myPublicRadioButton);
        visibility.add(this.myPropertyRadioButton);
        if (this.myContext.getScope() instanceof GroovyScriptClass) {
            this.myPropertyRadioButton.setSelected(true);
            this.myPrivateRadioButton.setEnabled(false);
            this.myProtectedRadioButton.setEnabled(false);
            this.myPublicRadioButton.setEnabled(false);
            this.myPropertyRadioButton.setEnabled(false);
        } else {
            this.myPrivateRadioButton.setSelected(true);
        }
        new RadioUpDownListener(new JRadioButton[]{this.myPrivateRadioButton, this.myProtectedRadioButton, this.myPublicRadioButton, this.myPropertyRadioButton});
    }

    private static boolean isAlwaysInvokedConstructor(@Nullable PsiMethod method, @NotNull PsiClass clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldDialog", "isAlwaysInvokedConstructor"));
        }
        if (method == null) {
            return false;
        }
        if (!method.isConstructor()) {
            return false;
        }
        PsiMethod[] constructors = clazz.getConstructors();
        if (constructors.length == 1) {
            return true;
        }
        GrConstructorInvocation invocation = PsiImplUtil.getChainingConstructorInvocation((GrMethod)method);
        if (invocation != null && invocation.isThisCall()) {
            return false;
        }
        for (PsiMethod constructor : constructors) {
            GrConstructorInvocation inv;
            if (constructor == method || (inv = PsiImplUtil.getChainingConstructorInvocation((GrMethod)constructor)) != null && !inv.isSuperCall()) continue;
            return false;
        }
        return true;
    }

    private static boolean allOccurrencesInOneMethod(@NotNull PsiElement[] occurrences, PsiElement scope) {
        if (occurrences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "occurrences", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldDialog", "allOccurrencesInOneMethod"));
        }
        if (occurrences.length == 0) {
            return true;
        }
        GrMember container = GrIntroduceFieldHandler.getContainer(occurrences[0], scope);
        if (container == null) {
            return false;
        }
        for (int i = 1; i < occurrences.length; ++i) {
            GrMember other = GrIntroduceFieldHandler.getContainer(occurrences[i], scope);
            if (other == container) continue;
            return false;
        }
        return true;
    }

    protected JComponent createCenterPanel() {
        this.myNameLabel.setLabelFor((Component)this.myNameField);
        this.myTypeLabel.setLabelFor((Component)((Object)this.myTypeComboBox));
        return this.myContentPane;
    }

    @Override
    public GrIntroduceFieldSettings getSettings() {
        return this;
    }

    @Override
    @NotNull
    public LinkedHashSet<String> suggestNames() {
        LinkedHashSet<String> linkedHashSet = new GrFieldNameSuggester(this.myContext, new GroovyFieldValidator(this.myContext), false).suggestNames();
        if (linkedHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldDialog", "suggestNames"));
        }
        return linkedHashSet;
    }

    private void createUIComponents() {
        GrExpression expression = this.myContext.getExpression();
        GrVariable var = this.myContext.getVar();
        StringPartInfo stringPart = this.myContext.getStringPart();
        ArrayList<String> list = new ArrayList<String>();
        if (var != null) {
            list.add(var.getName());
        }
        ContainerUtil.addAll(list, this.suggestNames());
        this.myNameField = new NameSuggestionsField(ArrayUtil.toStringArray(list), this.myContext.getProject(), (FileType)GroovyFileType.GROOVY_FILE_TYPE);
        this.myTypeComboBox = expression != null ? GrTypeComboBox.createTypeComboBoxFromExpression(expression) : (stringPart != null ? GrTypeComboBox.createTypeComboBoxFromExpression(stringPart.getLiteral()) : GrTypeComboBox.createTypeComboBoxWithDefType(var.getDeclaredType(), var));
        GrTypeComboBox.registerUpDownHint((JComponent)this.myNameField, this.myTypeComboBox);
    }

    @Override
    public boolean declareFinal() {
        return this.myDeclareFinalCheckBox.isSelected();
    }

    @Override
    @NotNull
    public GrIntroduceFieldSettings.Init initializeIn() {
        if (this.myCurrentMethodRadioButton.isSelected()) {
            GrIntroduceFieldSettings.Init init = GrIntroduceFieldSettings.Init.CUR_METHOD;
            if (init == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldDialog", "initializeIn"));
            }
            return init;
        }
        if (this.myFieldDeclarationRadioButton.isSelected()) {
            GrIntroduceFieldSettings.Init init = GrIntroduceFieldSettings.Init.FIELD_DECLARATION;
            if (init == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldDialog", "initializeIn"));
            }
            return init;
        }
        if (this.myClassConstructorSRadioButton.isSelected()) {
            GrIntroduceFieldSettings.Init init = GrIntroduceFieldSettings.Init.CONSTRUCTOR;
            if (init == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldDialog", "initializeIn"));
            }
            return init;
        }
        if (this.mySetUpMethodRadioButton.isSelected()) {
            GrIntroduceFieldSettings.Init init = GrIntroduceFieldSettings.Init.SETUP_METHOD;
            if (init == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldDialog", "initializeIn"));
            }
            return init;
        }
        throw new IncorrectOperationException("no initialization place is selected");
    }

    @Override
    @NotNull
    public String getVisibilityModifier() {
        if (this.myPrivateRadioButton.isSelected()) {
            if ("private" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldDialog", "getVisibilityModifier"));
            }
            return "private";
        }
        if (this.myProtectedRadioButton.isSelected()) {
            if ("protected" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldDialog", "getVisibilityModifier"));
            }
            return "protected";
        }
        if (this.myPublicRadioButton.isSelected()) {
            if ("public" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldDialog", "getVisibilityModifier"));
            }
            return "public";
        }
        if (this.myPropertyRadioButton.isSelected()) {
            if ("packageLocal" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldDialog", "getVisibilityModifier"));
            }
            return "packageLocal";
        }
        throw new IncorrectOperationException("no visibility selected");
    }

    @Override
    public boolean isStatic() {
        return this.myIsStatic;
    }

    @Override
    public boolean removeLocalVar() {
        return this.myInvokedOnLocalVar != null && this.myReplaceAllOccurrencesCheckBox.isSelected();
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myNameField.getEnteredName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldDialog", "getName"));
        }
        return string;
    }

    @Override
    public boolean replaceAllOccurrences() {
        return this.myReplaceAllOccurrencesCheckBox.isSelected();
    }

    @Override
    public PsiType getSelectedType() {
        return this.myTypeComboBox.getSelectedType();
    }

    @Nullable
    private static String getInvokedOnLocalVar(GrExpression expression) {
        PsiElement resolved;
        if (expression instanceof GrReferenceExpression && PsiUtil.isLocalVariable(resolved = ((GrReferenceExpression)expression).resolve())) {
            return ((GrVariable)resolved).getName();
        }
        return null;
    }

    private static boolean canBeInitializedOutsideBlock(@NotNull GrIntroduceContext context, @NotNull PsiClass clazz) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldDialog", "canBeInitializedOutsideBlock"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldDialog", "canBeInitializedOutsideBlock"));
        }
        StringPartInfo part = context.getStringPart();
        GrExpression expression = context.getExpression();
        if (expression != null) {
            PsiElement resolved;
            if ((expression = (GrExpression)PsiUtil.skipParentheses(expression, false)) == null) {
                return false;
            }
            if (expression instanceof GrReferenceExpression && PsiUtil.isLocalVariable(resolved = ((GrReferenceExpression)expression).resolve()) && (expression = ((GrVariable)resolved).getInitializerGroovy()) == null) {
                return false;
            }
            ExpressionChecker visitor = new ExpressionChecker(clazz, expression);
            expression.accept(visitor);
            return visitor.isResult();
        }
        if (part != null) {
            for (GrStringInjection injection : part.getInjections()) {
                GrExpression scope;
                GrExpression grExpression = scope = injection.getExpression() != null ? injection.getExpression() : injection.getClosableBlock();
                assert (scope != null);
                ExpressionChecker visitor = new ExpressionChecker(clazz, scope);
                scope.accept(visitor);
                if (visitor.isResult()) continue;
                return visitor.isResult();
            }
            return true;
        }
        return false;
    }

    private void validateOKAction() {
        this.setOKActionEnabled(GroovyNamesUtil.isIdentifier(this.getName()));
    }

    protected void doOKAction() {
        PsiClass clazz = (PsiClass)this.myContext.getScope();
        String name = this.getName();
        String message = RefactoringBundle.message((String)"field.exists", (Object[])new Object[]{name, clazz.getQualifiedName()});
        if (clazz.findFieldByName(name, true) != null && Messages.showYesNoDialog((Project)this.myContext.getProject(), (String)message, (String)IntroduceFieldHandler.REFACTORING_NAME, (Icon)Messages.getWarningIcon()) != 0) {
            return;
        }
        super.doOKAction();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JBRadioButton jBRadioButton;
        JRadioButton jRadioButton5;
        JRadioButton jRadioButton6;
        JRadioButton jRadioButton7;
        JLabel jLabel;
        JLabel jLabel2;
        JPanel jPanel;
        this.createUIComponents();
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myTypeLabel = jLabel2 = new JLabel();
        jLabel2.setText("Type:");
        jLabel2.setDisplayedMnemonic('T');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNameLabel = jLabel = new JLabel();
        jLabel.setText("Name:");
        jLabel.setDisplayedMnemonic('N');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        NameSuggestionsField nameSuggestionsField = this.myNameField;
        jPanel2.add((Component)nameSuggestionsField, new GridConstraints(1, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        GrTypeComboBox grTypeComboBox = this.myTypeComboBox;
        jPanel2.add((Component)((Object)grTypeComboBox), new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel4.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Initialize in", (int)0, (int)0, null, null));
        this.myCurrentMethodRadioButton = jRadioButton7 = new JRadioButton();
        jRadioButton7.setText("Current method");
        jRadioButton7.setMnemonic('M');
        jRadioButton7.setDisplayedMnemonicIndex(8);
        jPanel4.add((Component)jRadioButton7, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myFieldDeclarationRadioButton = jRadioButton6 = new JRadioButton();
        jRadioButton6.setText("Field declaration");
        jRadioButton6.setMnemonic('D');
        jRadioButton6.setDisplayedMnemonicIndex(6);
        jPanel4.add((Component)jRadioButton6, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myClassConstructorSRadioButton = jRadioButton5 = new JRadioButton();
        jRadioButton5.setText("Class constructor(s)");
        jRadioButton5.setMnemonic('C');
        jRadioButton5.setDisplayedMnemonicIndex(6);
        jPanel4.add((Component)jRadioButton5, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySetUpMethodRadioButton = jBRadioButton = new JBRadioButton();
        jBRadioButton.setText("setUp method");
        jBRadioButton.setHorizontalAlignment(10);
        jPanel4.add((Component)jBRadioButton, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel5, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel5.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Visibility", (int)0, (int)0, null, null));
        this.myPrivateRadioButton = jRadioButton4 = new JRadioButton();
        jRadioButton4.setText("Private");
        jRadioButton4.setMnemonic('V');
        jRadioButton4.setDisplayedMnemonicIndex(3);
        jPanel5.add((Component)jRadioButton4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myProtectedRadioButton = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("Protected");
        jRadioButton3.setMnemonic('O');
        jRadioButton3.setDisplayedMnemonicIndex(2);
        jPanel5.add((Component)jRadioButton3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPublicRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Public");
        jRadioButton2.setMnemonic('B');
        jRadioButton2.setDisplayedMnemonicIndex(2);
        jPanel5.add((Component)jRadioButton2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPropertyRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setText("Property");
        jRadioButton.setMnemonic('R');
        jRadioButton.setDisplayedMnemonicIndex(1);
        jPanel5.add((Component)jRadioButton, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myDeclareFinalCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Declare final");
        jCheckBox2.setMnemonic('F');
        jCheckBox2.setDisplayedMnemonicIndex(8);
        jPanel.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 7, 0, null, null, null));
        this.myReplaceAllOccurrencesCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Replace all occurrences");
        jCheckBox.setMnemonic('A');
        jCheckBox.setDisplayedMnemonicIndex(8);
        jPanel.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 7, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private static class ExpressionChecker
    extends GroovyRecursiveElementVisitor {
        private final PsiClass myClass;
        private final PsiElement myScope;
        private boolean result;

        private ExpressionChecker(@NotNull PsiClass aClass, @NotNull PsiElement scope) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldDialog$ExpressionChecker", "<init>"));
            }
            if (scope == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/plugins/groovy/refactoring/introduce/field/GrIntroduceFieldDialog$ExpressionChecker", "<init>"));
            }
            this.result = true;
            this.myClass = aClass;
            this.myScope = scope;
        }

        @Override
        public void visitReferenceExpression(GrReferenceExpression refExpr) {
            super.visitReferenceExpression(refExpr);
            PsiElement resolved = refExpr.resolve();
            if (!(resolved instanceof GrVariable)) {
                return;
            }
            if (resolved instanceof GrField && this.myClass.getManager().areElementsEquivalent((PsiElement)this.myClass, (PsiElement)((GrField)resolved).getContainingClass())) {
                return;
            }
            if (resolved instanceof PsiParameter && PsiTreeUtil.isAncestor((PsiElement)this.myScope, (PsiElement)((PsiParameter)resolved).getDeclarationScope(), (boolean)false)) {
                return;
            }
            this.result = false;
        }

        private boolean isResult() {
            return this.result;
        }
    }
}

