/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.conversion;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.http.HttpFileSystem;
import com.intellij.util.Function;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.EPathCommonUtil;
import org.jetbrains.idea.eclipse.conversion.EPathUtil;

public class EJavadocUtil {
    private EJavadocUtil() {
    }

    static void appendJavadocRoots(Element element, ModuleRootModel model, List<String> currentRoots, Library.ModifiableModel modifiableModel) {
        Element attributes = element.getChild("attributes");
        if (attributes == null) {
            return;
        }
        for (Object o : attributes.getChildren("attribute")) {
            if (!Comparing.strEqual((String)((Element)o).getAttributeValue("name"), (String)"javadoc_location")) continue;
            Element attribute = (Element)o;
            String javadocPath = attribute.getAttributeValue("value");
            if (!SystemInfo.isWindows) {
                javadocPath = javadocPath.replaceFirst("file:/", "file://");
            }
            modifiableModel.addRoot(EJavadocUtil.toIdeaJavadocUrl(model, javadocPath, currentRoots), JavadocOrderRootType.getInstance());
        }
    }

    private static String toIdeaJavadocUrl(ModuleRootModel model, String javadocPath, List<String> currentRoots) {
        if (javadocPath.startsWith("file:/")) {
            if (new File(javadocPath.substring("file:/".length())).exists()) {
                return VfsUtil.pathToUrl((String)javadocPath.substring("file:/".length()));
            }
        } else {
            String protocol = VirtualFileManager.extractProtocol((String)javadocPath);
            if (Comparing.strEqual((String)protocol, (String)HttpFileSystem.getInstance().getProtocol())) {
                return javadocPath;
            }
            if (javadocPath.startsWith("jar:")) {
                String localFile;
                String jarJavadocPath = javadocPath.substring("jar:".length());
                if (jarJavadocPath.startsWith("platform:/")) {
                    String relativeToPlatform = jarJavadocPath.substring("platform:/".length() + "resource".length());
                    VirtualFile currentRoot = EPathUtil.getContentRoot(model);
                    String currentModulePath = (currentRoot != null ? currentRoot.getParent().getPath() : model.getModule().getProject().getBaseDir().getPath()) + relativeToPlatform;
                    if (EJavadocUtil.isJarFileExist(currentModulePath)) {
                        return VirtualFileManager.constructUrl((String)"jar", (String)currentModulePath);
                    }
                    String moduleName = EPathCommonUtil.getRelativeModuleName((String)relativeToPlatform);
                    String relativeToModulePathWithJarSuffix = EPathCommonUtil.getRelativeToModulePath((String)relativeToPlatform);
                    String relativeToModulePath = EJavadocUtil.stripPathInsideJar(relativeToModulePathWithJarSuffix);
                    Module otherModule = ModuleManager.getInstance((Project)model.getModule().getProject()).findModuleByName(moduleName);
                    String url = null;
                    if (otherModule != null && otherModule != model.getModule()) {
                        url = EPathUtil.expandEclipseRelative2OtherModule(otherModule, relativeToModulePath);
                    } else if (currentRoots != null) {
                        url = EPathCommonUtil.expandEclipseRelative2ContentRoots(currentRoots, (String)moduleName, (String)relativeToModulePath);
                    }
                    if (url != null) {
                        assert (relativeToModulePathWithJarSuffix != null);
                        assert (relativeToModulePath != null);
                        if (relativeToModulePath.length() < relativeToModulePathWithJarSuffix.length()) {
                            url = url + relativeToModulePathWithJarSuffix.substring(relativeToModulePath.length());
                        }
                        return VirtualFileManager.constructUrl((String)"jar", (String)VfsUtil.urlToPath((String)url));
                    }
                } else if (jarJavadocPath.startsWith("file:/") && EJavadocUtil.isJarFileExist(localFile = jarJavadocPath.substring("file:/".length()))) {
                    return VirtualFileManager.constructUrl((String)"jar", (String)localFile);
                }
            }
        }
        return javadocPath;
    }

    @Nullable
    private static String stripPathInsideJar(@Nullable String relativeToModulePathWithJarSuffix) {
        int jarSufIdx;
        String relativeToModulePath = relativeToModulePathWithJarSuffix;
        if (relativeToModulePath != null && (jarSufIdx = relativeToModulePathWithJarSuffix.indexOf("!/")) != -1) {
            relativeToModulePath = relativeToModulePath.substring(0, jarSufIdx);
        }
        return relativeToModulePath;
    }

    static boolean isJarFileExist(String path) {
        int jarSufIdx = path.indexOf("!/");
        if (jarSufIdx != -1) {
            path = path.substring(0, jarSufIdx);
        }
        return new File(path).exists();
    }

    private static String toEclipseJavadocPath(ModuleRootModel model, String javadocPath) {
        String protocol = VirtualFileManager.extractProtocol((String)javadocPath);
        if (!Comparing.strEqual((String)protocol, (String)HttpFileSystem.getInstance().getProtocol())) {
            VirtualFile baseDir;
            String path = VfsUtil.urlToPath((String)javadocPath);
            VirtualFile contentRoot = EPathUtil.getContentRoot(model);
            Project project = model.getModule().getProject();
            VirtualFile virtualFile = baseDir = contentRoot != null ? contentRoot.getParent() : project.getBaseDir();
            if (Comparing.strEqual((String)protocol, (String)JarFileSystem.getInstance().getProtocol())) {
                VirtualFile javadocFile = JarFileSystem.getInstance().getVirtualFileForJar(VirtualFileManager.getInstance().findFileByUrl(javadocPath));
                if (javadocFile != null) {
                    String relativeUrl = contentRoot != null && VfsUtilCore.isAncestor((VirtualFile)contentRoot, (VirtualFile)javadocFile, (boolean)false) ? "/" + VfsUtilCore.getRelativePath((VirtualFile)javadocFile, (VirtualFile)baseDir, (char)'/') : EPathUtil.collapse2eclipseRelative2OtherModule(project, javadocFile);
                    if (relativeUrl != null) {
                        if (!javadocPath.contains("!/")) {
                            javadocPath = StringUtil.trimEnd((String)javadocPath, (String)"/") + "!/";
                        }
                        javadocPath = "jar:platform:/resource" + relativeUrl + javadocPath.substring(javadocFile.getUrl().length() - 1);
                    } else {
                        EPathUtil.LOG.info("Javadoc path: " + javadocPath);
                        Module module = ModuleUtil.findModuleForFile((VirtualFile)javadocFile, (Project)project);
                        EPathUtil.LOG.info("Module: " + (module != null ? module.getName() : "not found"));
                        if (module != null) {
                            EPathUtil.LOG.info("Content roots: " + Arrays.toString(ModuleRootManager.getInstance((Module)module).getContentRoots()));
                        }
                        javadocPath = "jar:file:/" + StringUtil.trimStart((String)path, (String)"/");
                    }
                } else {
                    javadocPath = "jar:file:/" + StringUtil.trimStart((String)path, (String)"/");
                }
            } else if (new File(path).exists()) {
                javadocPath = "file:/" + StringUtil.trimStart((String)path, (String)"/");
            }
        }
        return javadocPath;
    }

    static void setupJavadocAttributes(Element orderEntry, LibraryOrderEntry libraryOrderEntry, ModuleRootModel model) {
        EJavadocUtil.setupAttributes(orderEntry, (Function<String, String>)((Function)s -> EJavadocUtil.toEclipseJavadocPath(model, s)), "javadoc_location", libraryOrderEntry.getRootUrls(JavadocOrderRootType.getInstance()));
    }

    static void setupAttributes(Element orderEntry, Function<String, String> fun, String attributeName, String[] roots) {
        ArrayList<Object> eclipseUrls = new ArrayList<Object>();
        if (roots.length > 0) {
            eclipseUrls.add(fun.fun((Object)roots[0]));
        }
        ArrayList children = new ArrayList(orderEntry.getChildren("attributes"));
        for (Object e : children) {
            Element attsElement = (Element)e;
            ArrayList attTags = new ArrayList(attsElement.getChildren("attribute"));
            for (Object a : attTags) {
                String javadocPath;
                Element attElement = (Element)a;
                if (!Comparing.strEqual((String)attElement.getAttributeValue("name"), (String)attributeName) || eclipseUrls.remove(javadocPath = attElement.getAttributeValue("value"))) continue;
                attElement.detach();
            }
        }
        for (String string : eclipseUrls) {
            Element child = orderEntry.getChild("attributes");
            if (child == null) {
                child = new Element("attributes");
                orderEntry.addContent(child);
            }
            Element attrElement = new Element("attribute");
            child.addContent(attrElement);
            attrElement.setAttribute("name", attributeName);
            attrElement.setAttribute("value", string);
        }
    }
}

