/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle;

import com.intellij.application.options.ImportSourceChooserDialog;
import com.intellij.application.options.SaveSchemeDialog;
import com.intellij.application.options.SchemesToImportPopup;
import com.intellij.application.options.codeStyle.CodeStyleSchemeExporterUI;
import com.intellij.application.options.codeStyle.CodeStyleSchemesModel;
import com.intellij.application.options.codeStyle.CodeStyleSchemesUIConfiguration;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeExporterEP;
import com.intellij.openapi.options.SchemeFactory;
import com.intellij.openapi.options.SchemeImportException;
import com.intellij.openapi.options.SchemeImportUtil;
import com.intellij.openapi.options.SchemeImporter;
import com.intellij.openapi.options.SchemeImporterEP;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.impl.source.codeStyle.CodeStyleSchemesImpl;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManageCodeStyleSchemesDialog
extends DialogWrapper {
    private JPanel myContentPane;
    private JBTable mySchemesTable;
    private JButton myDeleteButton;
    private JButton mySaveAsButton;
    private JButton myCopyToProjectButton;
    private JButton myCloseButton;
    private JButton myExportButton;
    private JButton myImportButton;
    private final MySchemesTableModel mySchemesTableModel;
    private final CodeStyleSchemesModel myModel;
    private final Component myParent;

    protected ManageCodeStyleSchemesDialog(Component parent, CodeStyleSchemesModel schemesModel) {
        super(parent, true);
        this.myParent = parent;
        this.myModel = schemesModel;
        this.$$$setupUI$$$();
        this.setTitle("Code Style Schemes");
        this.mySchemesTableModel = new MySchemesTableModel(schemesModel);
        this.mySchemesTable.setModel((TableModel)this.mySchemesTableModel);
        this.mySchemesTable.setSelectionMode(0);
        this.mySchemesTable.getSelectionModel().addListSelectionListener(e -> this.updateActions());
        this.setDefaultSelection();
        this.myDeleteButton.addActionListener(e -> this.deleteSelected());
        this.mySaveAsButton.addActionListener(e -> this.onSaveAs());
        this.myCopyToProjectButton.addActionListener(e -> this.onCopyToProject());
        this.myCloseButton.addActionListener(e -> this.doCancelAction());
        this.myExportButton.setVisible(false);
        if (SchemeImporterEP.getExtensions(CodeStyleScheme.class).isEmpty()) {
            this.myImportButton.setVisible(false);
        } else {
            this.myImportButton.setVisible(true);
            this.myImportButton.addActionListener(e -> this.chooseAndImport());
        }
        if (SchemeExporterEP.getExtensions(CodeStyleScheme.class).isEmpty()) {
            this.myExportButton.setVisible(false);
        } else {
            this.myExportButton.setVisible(true);
            this.myExportButton.addActionListener(e -> this.exportSelectedScheme());
        }
        this.init();
    }

    private void chooseAndImport() {
        ImportSourceChooserDialog<CodeStyleScheme> importSourceChooserDialog = new ImportSourceChooserDialog<CodeStyleScheme>(this.myContentPane, CodeStyleScheme.class);
        if (importSourceChooserDialog.showAndGet()) {
            if (importSourceChooserDialog.isImportFromSharedSelected()) {
                new SchemesToImportPopup<CodeStyleScheme>((Component)this.myContentPane){

                    @Override
                    protected void onSchemeSelected(CodeStyleScheme scheme) {
                        if (scheme != null) {
                            ManageCodeStyleSchemesDialog.this.myModel.addScheme(scheme, true);
                        }
                    }
                }.show(this.myModel.getSchemes());
            } else {
                String selectedImporterName = importSourceChooserDialog.getSelectedSourceName();
                if (selectedImporterName != null) {
                    SchemeImporter<CodeStyleScheme> importer = SchemeImporterEP.getImporter(selectedImporterName, CodeStyleScheme.class);
                    if (importer == null) {
                        return;
                    }
                    try {
                        CodeStyleScheme scheme = this.importExternalCodeStyle(importer);
                        if (scheme != null) {
                            String additionalImportInfo = StringUtil.notNullize((String)importer.getAdditionalImportInfo((Scheme)scheme));
                            SchemeImportUtil.showStatus(this.myImportButton, ApplicationBundle.message((String)"message.code.style.scheme.import.success", (Object[])new Object[]{selectedImporterName, scheme.getName(), additionalImportInfo}), MessageType.INFO);
                        }
                    }
                    catch (SchemeImportException e) {
                        if (e.isWarning()) {
                            SchemeImportUtil.showStatus(this.myImportButton, e.getMessage(), MessageType.WARNING);
                            return;
                        }
                        String message = ApplicationBundle.message((String)"message.code.style.scheme.import.failure", (Object[])new Object[]{selectedImporterName, e.getMessage()});
                        SchemeImportUtil.showStatus(this.myImportButton, message, MessageType.ERROR);
                    }
                }
            }
        }
    }

    @Nullable
    private CodeStyleScheme importExternalCodeStyle(SchemeImporter<CodeStyleScheme> importer) throws SchemeImportException {
        VirtualFile selectedFile = SchemeImportUtil.selectImportSource(importer.getSourceExtensions(), this.myContentPane, CodeStyleSchemesUIConfiguration.Util.getRecentImportFile());
        if (selectedFile != null) {
            CodeStyleSchemesUIConfiguration.Util.setRecentImportFile(selectedFile);
            SchemeCreator schemeCreator = new SchemeCreator();
            CodeStyleScheme schemeImported = (CodeStyleScheme)importer.importScheme(this.myModel.getProject(), selectedFile, (Scheme)this.getSelectedScheme(), (SchemeFactory)schemeCreator);
            if (schemeImported != null) {
                if (schemeCreator.isSchemeWasCreated()) {
                    this.myModel.fireSchemeListChanged();
                } else {
                    this.myModel.fireSchemeChanged(schemeImported);
                }
                return schemeImported;
            }
        }
        return null;
    }

    private void updateActions() {
        CodeStyleScheme selectedScheme = this.getSelectedInTableScheme();
        this.myDeleteButton.setEnabled(selectedScheme != null && !selectedScheme.isDefault() && !this.mySchemesTableModel.isProjectScheme(selectedScheme));
        this.myCopyToProjectButton.setEnabled(selectedScheme != null && !this.mySchemesTableModel.isProjectScheme(selectedScheme));
    }

    @Nullable
    private CodeStyleScheme getSelectedInTableScheme() {
        int row = this.mySchemesTable.getSelectedRow();
        if (row < 0) {
            return null;
        }
        return this.mySchemesTableModel.getSchemeAt(row);
    }

    @NotNull
    private CodeStyleScheme getSelectedScheme() {
        int row = this.mySchemesTable.getSelectedRow();
        if (row < 0) {
            row = this.mySchemesTableModel.getDefaultRow();
        }
        CodeStyleScheme codeStyleScheme = this.mySchemesTableModel.getSchemeAt(row);
        if (codeStyleScheme == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/ManageCodeStyleSchemesDialog", "getSelectedScheme"));
        }
        return codeStyleScheme;
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/ManageCodeStyleSchemesDialog", "createActions"));
        }
        return actionArray;
    }

    private void deleteSelected() {
        int row = this.mySchemesTable.getSelectedRow();
        if (row >= 0) {
            int rowToSelect = row + 1;
            if (rowToSelect >= this.mySchemesTableModel.getRowCount()) {
                rowToSelect = this.mySchemesTableModel.getDefaultRow();
            }
            this.mySchemesTable.getSelectionModel().setSelectionInterval(rowToSelect, rowToSelect);
            this.mySchemesTableModel.deleteAt(row);
        }
    }

    protected JComponent createCenterPanel() {
        return this.myContentPane;
    }

    private void createUIComponents() {
        this.mySchemesTable = new MySchemesTable();
    }

    private void onSaveAs() {
        if (this.mySchemesTableModel.isProjectScheme(this.getSelectedScheme())) {
            int rowToSelect = this.mySchemesTableModel.exportProjectScheme();
            if (rowToSelect > 0) {
                this.mySchemesTable.getSelectionModel().setSelectionInterval(rowToSelect, rowToSelect);
            }
        } else {
            Collection names = CodeStyleSchemesImpl.getSchemeManager().getAllSchemeNames();
            String selectedName = this.getSelectedScheme().getName();
            SaveSchemeDialog saveDialog = new SaveSchemeDialog(this.myParent, ApplicationBundle.message((String)"title.save.code.style.scheme.as", (Object[])new Object[0]), names, selectedName);
            if (saveDialog.showAndGet()) {
                int row = this.mySchemesTableModel.createNewScheme(this.getSelectedScheme(), saveDialog.getSchemeName());
                this.mySchemesTable.getSelectionModel().setSelectionInterval(row, row);
            }
        }
    }

    private void onCopyToProject() {
        this.mySchemesTableModel.copyToProject(this.getSelectedScheme());
    }

    private void setDefaultSelection() {
        CodeStyleScheme selectedScheme = this.myModel.getSelectedScheme();
        for (int i = 0; i < this.mySchemesTableModel.getRowCount(); ++i) {
            if (!this.mySchemesTableModel.getSchemeAt(i).equals(selectedScheme)) continue;
            this.mySchemesTable.getSelectionModel().setSelectionInterval(i, i);
            return;
        }
    }

    private void exportSelectedScheme() {
        new CodeStyleSchemeExporterUI(this.myExportButton, this.getSelectedScheme(), (message, messageType) -> SchemeImportUtil.showStatus(this.myExportButton, message, messageType)).export();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JButton jButton4;
        JButton jButton5;
        JButton jButton6;
        JPanel jPanel;
        this.createUIComponents();
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        JBTable jBTable = this.mySchemesTable;
        jBTable.setStriped(true);
        jBScrollPane.setViewportView((Component)jBTable);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(7, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDeleteButton = jButton6 = new JButton();
        jButton6.setText("Delete");
        jButton6.setMnemonic('D');
        jButton6.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jButton6, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.mySaveAsButton = jButton5 = new JButton();
        jButton5.setText("Save As...");
        jButton5.setMnemonic('S');
        jButton5.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jButton5, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myCopyToProjectButton = jButton4 = new JButton();
        jButton4.setText("Copy to Project");
        jButton4.setMnemonic('P');
        jButton4.setDisplayedMnemonicIndex(8);
        jPanel2.add((Component)jButton4, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myCloseButton = jButton3 = new JButton();
        jButton3.setText("Close");
        jButton3.setMnemonic('C');
        jButton3.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jButton3, new GridConstraints(5, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myExportButton = jButton2 = new JButton();
        jButton2.setText("Export...");
        jButton2.setMnemonic('X');
        jButton2.setDisplayedMnemonicIndex(1);
        jPanel2.add((Component)jButton2, new GridConstraints(3, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myImportButton = jButton = new JButton();
        jButton.setText("Import...");
        jPanel2.add((Component)jButton, new GridConstraints(4, 0, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private static class MySchemesTableModel
    extends AbstractTableModel {
        private final CodeStyleSchemesModel mySchemesModel;
        private final List<CodeStyleScheme> mySchemes;

        public MySchemesTableModel(CodeStyleSchemesModel schemesModel) {
            this.mySchemesModel = schemesModel;
            this.mySchemes = new ArrayList<CodeStyleScheme>();
            this.updateSchemes();
        }

        @Override
        @NotNull
        public String getColumnName(int column) {
            assert (column == 0);
            if ("Name" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/ManageCodeStyleSchemesDialog$MySchemesTableModel", "getColumnName"));
            }
            return "Name";
        }

        @Override
        public int getRowCount() {
            return this.mySchemes.size();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            assert (columnIndex == 0);
            return this.mySchemes.get(rowIndex);
        }

        public CodeStyleScheme getSchemeAt(int row) {
            return this.mySchemes.get(row);
        }

        public void deleteAt(int row) {
            CodeStyleScheme scheme = this.mySchemes.get(row);
            this.mySchemesModel.removeScheme(scheme);
            this.updateSchemes();
            this.fireTableRowsDeleted(row, row);
        }

        public int createNewScheme(CodeStyleScheme selectedScheme, String schemeName) {
            CodeStyleScheme newScheme = this.mySchemesModel.createNewScheme(schemeName, selectedScheme);
            this.mySchemesModel.addScheme(newScheme, true);
            this.updateSchemes();
            int row = 0;
            for (CodeStyleScheme scheme : this.mySchemes) {
                if (scheme == newScheme) {
                    this.fireTableRowsInserted(row, row);
                    break;
                }
                ++row;
            }
            return row;
        }

        public int getDefaultRow() {
            int row = 0;
            for (CodeStyleScheme scheme : this.mySchemes) {
                if (scheme.isDefault()) {
                    return row;
                }
                ++row;
            }
            return 0;
        }

        public void copyToProject(CodeStyleScheme scheme) {
            this.mySchemesModel.copyToProject(scheme);
            int switchToProject = Messages.showYesNoDialog((String)("Scheme '" + scheme.getName() + "' was copied to be used as the project scheme.\nSwitch to this created scheme?"), (String)"Copy Scheme to Project", (Icon)Messages.getQuestionIcon());
            if (switchToProject == 0) {
                this.mySchemesModel.setUsePerProjectSettings(true, true);
            }
        }

        public int exportProjectScheme() {
            String name = Messages.showInputDialog((String)"Enter new scheme name:", (String)"Copy Project Scheme to Global List", (Icon)Messages.getQuestionIcon());
            if (name != null && !"Project".equals(name)) {
                CodeStyleScheme newScheme = this.mySchemesModel.exportProjectScheme(name);
                this.updateSchemes();
                int switchToGlobal = Messages.showYesNoDialog((String)("Project scheme was copied to global scheme list as '" + newScheme.getName() + "'.\nSwitch to this created scheme?"), (String)"Copy Project Scheme to Global List", (Icon)Messages.getQuestionIcon());
                if (switchToGlobal == 0) {
                    this.mySchemesModel.setUsePerProjectSettings(false);
                    this.mySchemesModel.selectScheme(newScheme, null);
                }
                int row = 0;
                for (CodeStyleScheme scheme : this.mySchemes) {
                    if (scheme == newScheme) {
                        this.fireTableRowsInserted(row, row);
                        return switchToGlobal == 0 ? row : -1;
                    }
                    ++row;
                }
            }
            return -1;
        }

        private void updateSchemes() {
            this.mySchemes.clear();
            this.mySchemes.addAll(this.mySchemesModel.getAllSortedSchemes());
        }

        public boolean isProjectScheme(CodeStyleScheme scheme) {
            return this.mySchemesModel.isProjectScheme(scheme);
        }
    }

    private class MySchemesTable
    extends JBTable {
        private final TableCellRenderer myFixedItemsRenderer;

        private MySchemesTable() {
            this.myFixedItemsRenderer = new DefaultTableCellRenderer(){

                @Override
                @NotNull
                public Component getTableCellRendererComponent(@NotNull JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    CodeStyleScheme scheme;
                    if (table == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/application/options/codeStyle/ManageCodeStyleSchemesDialog$MySchemesTable$1", "getTableCellRendererComponent"));
                    }
                    Component defaultComponent = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (value instanceof CodeStyleScheme && ((scheme = (CodeStyleScheme)value).isDefault() || ManageCodeStyleSchemesDialog.this.myModel.isProjectScheme(scheme))) {
                        defaultComponent.setFont(defaultComponent.getFont().deriveFont(1));
                    }
                    Component component = defaultComponent;
                    if (component == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/codeStyle/ManageCodeStyleSchemesDialog$MySchemesTable$1", "getTableCellRendererComponent"));
                    }
                    return component;
                }
            };
        }

        public TableCellRenderer getCellRenderer(int row, int column) {
            return this.myFixedItemsRenderer;
        }
    }

    private class SchemeCreator
    implements SchemeFactory<CodeStyleScheme> {
        private boolean mySchemeWasCreated;

        private SchemeCreator() {
        }

        public CodeStyleScheme createNewScheme(@Nullable String targetName) {
            this.mySchemeWasCreated = true;
            if (targetName == null) {
                targetName = ApplicationBundle.message((String)"code.style.scheme.import.unnamed", (Object[])new Object[0]);
            }
            int row = ManageCodeStyleSchemesDialog.this.mySchemesTableModel.createNewScheme(ManageCodeStyleSchemesDialog.this.getSelectedScheme(), targetName);
            ManageCodeStyleSchemesDialog.this.mySchemesTable.getSelectionModel().setSelectionInterval(row, row);
            return ManageCodeStyleSchemesDialog.this.mySchemesTableModel.getSchemeAt(row);
        }

        public boolean isSchemeWasCreated() {
            return this.mySchemeWasCreated;
        }
    }
}

