/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.editor;

import com.intellij.application.options.editor.EditorOptionsPanel;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.GutterIconDescriptor;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.daemon.LineMarkerSettings;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.ui.EmptyIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GutterIconsConfigurable
implements Configurable,
Configurable.NoScroll {
    private JPanel myPanel;
    private CheckBoxList<GutterIconDescriptor> myList;
    private JBCheckBox myShowGutterIconsJBCheckBox;
    private List<GutterIconDescriptor> myDescriptors;
    private Map<GutterIconDescriptor, PluginDescriptor> myFirstDescriptors;

    public GutterIconsConfigurable() {
        this.$$$setupUI$$$();
        this.myFirstDescriptors = new HashMap<GutterIconDescriptor, PluginDescriptor>();
    }

    @Nls
    public String getDisplayName() {
        return "Gutter Icons";
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.settings.editor.gutter.icons";
    }

    @Nullable
    public JComponent createComponent() {
        ExtensionPoint point = Extensions.getRootArea().getExtensionPoint("com.intellij.codeInsight.lineMarkerProvider");
        LanguageExtensionPoint[] extensions = (LanguageExtensionPoint[])point.getExtensions();
        NullableFunction function = point1 -> {
            LineMarkerProvider instance = (LineMarkerProvider)point1.getInstance();
            return instance instanceof LineMarkerProviderDescriptor && ((LineMarkerProviderDescriptor)instance).getName() != null ? point1.getPluginDescriptor() : null;
        };
        MultiMap map = ContainerUtil.groupBy(Arrays.asList(extensions), (NullableFunction)function);
        HashMap pluginDescriptorMap = ContainerUtil.newHashMap();
        HashSet ids = new HashSet();
        this.myDescriptors = new ArrayList<GutterIconDescriptor>();
        for (PluginDescriptor descriptor2 : map.keySet()) {
            Collection points = map.get((Object)descriptor2);
            for (LanguageExtensionPoint extensionPoint : points) {
                GutterIconDescriptor instance = (GutterIconDescriptor)extensionPoint.getInstance();
                if (instance.getOptions().length > 0) {
                    for (GutterIconDescriptor.Option option : instance.getOptions()) {
                        if (ids.add(option.getId())) {
                            this.myDescriptors.add((GutterIconDescriptor)option);
                        }
                        pluginDescriptorMap.put(option, descriptor2);
                    }
                    continue;
                }
                if (ids.add(instance.getId())) {
                    this.myDescriptors.add(instance);
                }
                pluginDescriptorMap.put(instance, descriptor2);
            }
        }
        this.myDescriptors.sort((o1, o2) -> {
            if (pluginDescriptorMap.get(o1) != pluginDescriptorMap.get(o2)) {
                return 0;
            }
            return Comparing.compare((Comparable)((Object)o1.getName()), (Comparable)((Object)o2.getName()));
        });
        PluginDescriptor current = null;
        for (GutterIconDescriptor descriptor3 : this.myDescriptors) {
            PluginDescriptor pluginDescriptor = (PluginDescriptor)pluginDescriptorMap.get(descriptor3);
            if (pluginDescriptor == current) continue;
            this.myFirstDescriptors.put(descriptor3, pluginDescriptor);
            current = pluginDescriptor;
        }
        this.myList.setItems(this.myDescriptors, descriptor -> descriptor.getName());
        this.myShowGutterIconsJBCheckBox.addChangeListener(e -> this.myList.setEnabled(this.myShowGutterIconsJBCheckBox.isSelected()));
        return this.myPanel;
    }

    public boolean isModified() {
        for (GutterIconDescriptor descriptor : this.myDescriptors) {
            if (this.myList.isItemSelected((Object)descriptor) == LineMarkerSettings.getSettings().isEnabled(descriptor)) continue;
            return true;
        }
        return this.myShowGutterIconsJBCheckBox.isSelected() != EditorSettingsExternalizable.getInstance().areGutterIconsShown();
    }

    public void apply() throws ConfigurationException {
        EditorSettingsExternalizable editorSettings = EditorSettingsExternalizable.getInstance();
        if (this.myShowGutterIconsJBCheckBox.isSelected() != editorSettings.areGutterIconsShown()) {
            editorSettings.setGutterIconsShown(this.myShowGutterIconsJBCheckBox.isSelected());
            EditorOptionsPanel.reinitAllEditors();
        }
        for (GutterIconDescriptor descriptor : this.myDescriptors) {
            LineMarkerSettings.getSettings().setEnabled(descriptor, this.myList.isItemSelected((Object)descriptor));
        }
        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            DaemonCodeAnalyzer.getInstance((Project)project2).restart();
        }
    }

    public void reset() {
        for (GutterIconDescriptor descriptor : this.myDescriptors) {
            this.myList.setItemSelected((Object)descriptor, LineMarkerSettings.getSettings().isEnabled(descriptor));
        }
        boolean gutterIconsShown = EditorSettingsExternalizable.getInstance().areGutterIconsShown();
        this.myShowGutterIconsJBCheckBox.setSelected(gutterIconsShown);
        this.myList.setEnabled(gutterIconsShown);
    }

    public void disposeUIResources() {
        for (ChangeListener listener2 : this.myShowGutterIconsJBCheckBox.getChangeListeners()) {
            this.myShowGutterIconsJBCheckBox.removeChangeListener(listener2);
        }
    }

    private void createUIComponents() {
        this.myList = new CheckBoxList<GutterIconDescriptor>(){

            protected JComponent adjustRendering(JComponent rootComponent, JCheckBox checkBox, int index, boolean selected, boolean hasFocus) {
                JPanel panel = new JPanel(new BorderLayout());
                panel.setBorder(BorderFactory.createEmptyBorder());
                GutterIconDescriptor descriptor = (GutterIconDescriptor)GutterIconsConfigurable.this.myList.getItemAt(index);
                Icon icon = descriptor == null ? null : descriptor.getIcon();
                JLabel label = new JLabel(icon == null ? EmptyIcon.ICON_16 : icon);
                label.setOpaque(true);
                label.setPreferredSize(new Dimension(25, -1));
                label.setHorizontalAlignment(0);
                panel.add((Component)label, "West");
                panel.add((Component)checkBox, "Center");
                panel.setBackground(this.getBackground(false));
                label.setBackground(this.getBackground(selected));
                if (!checkBox.isOpaque()) {
                    checkBox.setOpaque(true);
                }
                checkBox.setBorder(null);
                PluginDescriptor pluginDescriptor = (PluginDescriptor)GutterIconsConfigurable.this.myFirstDescriptors.get(descriptor);
                if (pluginDescriptor instanceof IdeaPluginDescriptor) {
                    SeparatorWithText separator = new SeparatorWithText();
                    String name = ((IdeaPluginDescriptor)pluginDescriptor).getName();
                    separator.setCaption("IDEA CORE".equals(name) ? "Common" : name);
                    panel.add((Component)separator, "North");
                }
                return panel;
            }

            @Nullable
            protected Point findPointRelativeToCheckBox(int x, int y, @NotNull JCheckBox checkBox, int index) {
                if (checkBox == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkBox", "com/intellij/application/options/editor/GutterIconsConfigurable$1", "findPointRelativeToCheckBox"));
                }
                return super.findPointRelativeToCheckBoxWithAdjustedRendering(x, y, checkBox, index);
            }
        };
        this.myList.setBorder(BorderFactory.createEmptyBorder());
    }

    public List<GutterIconDescriptor> getDescriptors() {
        return this.myDescriptors;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        CheckBoxList<GutterIconDescriptor> checkBoxList = this.myList;
        jBScrollPane.setViewportView((Component)checkBoxList);
        this.myShowGutterIconsJBCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("messages/ApplicationBundle").getString("checkbox.show.gutter.icons"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

