/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.actions.AbstractLayoutCodeProcessor;
import com.intellij.codeInsight.actions.LayoutCodeInfoCollector;
import com.intellij.lang.ImportOptimizer;
import com.intellij.lang.LanguageImportStatements;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.codeStyle.CodeStyleManagerImpl;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.FutureTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptimizeImportsProcessor
extends AbstractLayoutCodeProcessor {
    private static final String PROGRESS_TEXT = CodeInsightBundle.message((String)"progress.text.optimizing.imports", (Object[])new Object[0]);
    public static final String COMMAND_NAME = CodeInsightBundle.message((String)"process.optimize.imports", (Object[])new Object[0]);
    private List<NotificationInfo> myOptimizerNotifications = ContainerUtil.newSmartList();

    public OptimizeImportsProcessor(Project project2) {
        super(project2, COMMAND_NAME, PROGRESS_TEXT, false);
    }

    public OptimizeImportsProcessor(Project project2, Module module2) {
        super(project2, module2, COMMAND_NAME, PROGRESS_TEXT, false);
    }

    public OptimizeImportsProcessor(Project project2, PsiDirectory directory, boolean includeSubdirs) {
        super(project2, directory, includeSubdirs, PROGRESS_TEXT, COMMAND_NAME, false);
    }

    public OptimizeImportsProcessor(Project project2, PsiDirectory directory, boolean includeSubdirs, boolean processOnlyVcsChangedFiles) {
        super(project2, directory, includeSubdirs, PROGRESS_TEXT, COMMAND_NAME, processOnlyVcsChangedFiles);
    }

    public OptimizeImportsProcessor(Project project2, PsiFile file2) {
        super(project2, file2, PROGRESS_TEXT, COMMAND_NAME, false);
    }

    public OptimizeImportsProcessor(Project project2, PsiFile[] files, Runnable postRunnable) {
        this(project2, files, COMMAND_NAME, postRunnable);
    }

    public OptimizeImportsProcessor(Project project2, PsiFile[] files, String commandName, Runnable postRunnable) {
        super(project2, files, PROGRESS_TEXT, commandName, postRunnable, false);
    }

    public OptimizeImportsProcessor(AbstractLayoutCodeProcessor processor2) {
        super(processor2, COMMAND_NAME, PROGRESS_TEXT);
    }

    @Override
    @NotNull
    protected FutureTask<Boolean> prepareTask(@NotNull PsiFile file2, boolean processChangedTextOnly) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/actions/OptimizeImportsProcessor", "prepareTask"));
        }
        Set optimizers = LanguageImportStatements.INSTANCE.forFile(file2);
        ArrayList<Runnable> runnables = new ArrayList<Runnable>();
        List files = file2.getViewProvider().getAllFiles();
        for (ImportOptimizer optimizer : optimizers) {
            for (PsiFile psiFile : files) {
                if (!optimizer.supports(psiFile)) continue;
                runnables.add(optimizer.processFile(psiFile));
            }
        }
        Runnable runnable2 = !runnables.isEmpty() ? () -> {
            CodeStyleManagerImpl.setSequentialProcessingAllowed(false);
            try {
                for (Runnable runnable1 : runnables) {
                    runnable1.run();
                    this.retrieveAndStoreNotificationInfo(runnable1);
                }
                this.putNotificationInfoIntoCollector();
            }
            finally {
                CodeStyleManagerImpl.setSequentialProcessingAllowed(true);
            }
        } : EmptyRunnable.getInstance();
        FutureTask<Boolean> futureTask = new FutureTask<Boolean>(runnable2, true);
        if (futureTask == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/actions/OptimizeImportsProcessor", "prepareTask"));
        }
        return futureTask;
    }

    private void retrieveAndStoreNotificationInfo(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/codeInsight/actions/OptimizeImportsProcessor", "retrieveAndStoreNotificationInfo"));
        }
        if (runnable2 instanceof ImportOptimizer.CollectingInfoRunnable) {
            String optimizerMessage = ((ImportOptimizer.CollectingInfoRunnable)runnable2).getUserNotificationInfo();
            this.myOptimizerNotifications.add(optimizerMessage != null ? new NotificationInfo(optimizerMessage) : NotificationInfo.NOTHING_CHANGED_NOTIFICATION);
        } else if (runnable2 == EmptyRunnable.getInstance()) {
            this.myOptimizerNotifications.add(NotificationInfo.NOTHING_CHANGED_NOTIFICATION);
        } else {
            this.myOptimizerNotifications.add(NotificationInfo.SOMETHING_CHANGED_WITHOUT_MESSAGE_NOTIFICATION);
        }
    }

    private void putNotificationInfoIntoCollector() {
        LayoutCodeInfoCollector collector = this.getInfoCollector();
        if (collector == null) {
            return;
        }
        boolean atLeastOneOptimizerChangedSomething = false;
        for (NotificationInfo info : this.myOptimizerNotifications) {
            atLeastOneOptimizerChangedSomething |= info.isSomethingChanged();
            if (info.getMessage() == null) continue;
            collector.setOptimizeImportsNotification(info.getMessage());
            return;
        }
        collector.setOptimizeImportsNotification(atLeastOneOptimizerChangedSomething ? "imports optimized" : null);
    }

    static class NotificationInfo {
        public static final NotificationInfo NOTHING_CHANGED_NOTIFICATION = new NotificationInfo(false, null);
        public static final NotificationInfo SOMETHING_CHANGED_WITHOUT_MESSAGE_NOTIFICATION = new NotificationInfo(true, null);
        private final boolean mySomethingChanged;
        private final String myMessage;

        NotificationInfo(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/codeInsight/actions/OptimizeImportsProcessor$NotificationInfo", "<init>"));
            }
            this(true, message);
        }

        public boolean isSomethingChanged() {
            return this.mySomethingChanged;
        }

        public String getMessage() {
            return this.myMessage;
        }

        private NotificationInfo(boolean isSomethingChanged, @Nullable String message) {
            this.mySomethingChanged = isSomethingChanged;
            this.myMessage = message;
        }
    }
}

