/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.psi.PsiClass;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCompletionSession
implements Consumer<LookupElement> {
    private final Set<String> myAddedClasses = new HashSet<String>();
    private Set<String> myKeywords = new HashSet<String>();
    private final CompletionResultSet myResult;

    public JavaCompletionSession(CompletionResultSet result2) {
        this.myResult = result2;
    }

    public void consume(LookupElement lookupElement) {
        Object object = lookupElement.getObject();
        if (object instanceof PsiClass) {
            this.registerClass((PsiClass)object);
        }
        this.myResult.addElement(AutoCompletionPolicy.NEVER_AUTOCOMPLETE.applyPolicy(lookupElement));
    }

    public void registerClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/codeInsight/completion/JavaCompletionSession", "registerClass"));
        }
        ContainerUtil.addIfNotNull(this.myAddedClasses, (Object)JavaCompletionSession.getClassName(psiClass));
    }

    @Nullable
    private static String getClassName(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/codeInsight/completion/JavaCompletionSession", "getClassName"));
        }
        String name = psiClass.getQualifiedName();
        return name == null ? psiClass.getName() : name;
    }

    public boolean alreadyProcessed(@NotNull LookupElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/completion/JavaCompletionSession", "alreadyProcessed"));
        }
        Object object = element.getObject();
        return object instanceof PsiClass && this.alreadyProcessed((PsiClass)object);
    }

    public boolean alreadyProcessed(@NotNull PsiClass object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/codeInsight/completion/JavaCompletionSession", "alreadyProcessed"));
        }
        String name = JavaCompletionSession.getClassName(object);
        return name == null || this.myAddedClasses.contains(name);
    }

    public boolean isKeywordAlreadyProcessed(@NotNull String keyword) {
        if (keyword == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyword", "com/intellij/codeInsight/completion/JavaCompletionSession", "isKeywordAlreadyProcessed"));
        }
        return this.myKeywords.contains(keyword);
    }

    public void registerKeyword(@NotNull String keyword) {
        if (keyword == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyword", "com/intellij/codeInsight/completion/JavaCompletionSession", "registerKeyword"));
        }
        this.myKeywords.add(keyword);
    }
}

