/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.simple;

import com.intellij.codeInsight.TailType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.java.IJavaElementType;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NonNls;

public abstract class RParenthTailType
extends TailType {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.simple.RParenthSimpleTailType");

    private static TextRange getRangeToCheckParensBalance(PsiFile file2, Document document2, int startOffset) {
        PsiElement parent;
        PsiElement element = file2.findElementAt(startOffset);
        if ((element = PsiTreeUtil.getParentOfType((PsiElement)element, PsiStatement.class, (boolean)false)) != null && (parent = element.getParent()) instanceof PsiLoopStatement) {
            element = parent;
        }
        return element == null ? new TextRange(0, document2.getTextLength()) : element.getTextRange();
    }

    protected abstract boolean isSpaceWithinParentheses(CommonCodeStyleSettings var1, Editor var2, int var3);

    public int processTail(Editor editor, int tailOffset) {
        return RParenthTailType.addRParenth(editor, tailOffset, this.isSpaceWithinParentheses(RParenthTailType.getLocalCodeStyleSettings((Editor)editor, (int)tailOffset), editor, tailOffset));
    }

    public static int addRParenth(Editor editor, int offset, boolean spaceWithinParens) {
        int existingRParenthOffset = RParenthTailType.getExistingRParenthOffset(editor, offset);
        if (existingRParenthOffset < 0) {
            if (spaceWithinParens) {
                offset = RParenthTailType.insertChar((Editor)editor, (int)offset, (char)' ');
            }
            editor.getDocument().insertString(offset, (CharSequence)")");
            return RParenthTailType.moveCaret((Editor)editor, (int)offset, (int)1);
        }
        if (spaceWithinParens && offset == existingRParenthOffset) {
            existingRParenthOffset = RParenthTailType.insertChar((Editor)editor, (int)offset, (char)' ');
        }
        return RParenthTailType.moveCaret((Editor)editor, (int)existingRParenthOffset, (int)1);
    }

    @NonNls
    public String toString() {
        return "RParenth";
    }

    private static int getExistingRParenthOffset(Editor editor, int tailOffset) {
        Document document2 = editor.getDocument();
        if (tailOffset >= document2.getTextLength()) {
            return -1;
        }
        CharSequence charsSequence = document2.getCharsSequence();
        EditorHighlighter highlighter = ((EditorEx)editor).getHighlighter();
        int existingRParenthOffset = -1;
        HighlighterIterator iterator = highlighter.createIterator(tailOffset);
        while (!iterator.atEnd()) {
            IElementType tokenType = iterator.getTokenType();
            if (!(tokenType instanceof IJavaElementType && ElementType.JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(tokenType) || tokenType == TokenType.WHITE_SPACE)) {
                int start = iterator.getStart();
                if (iterator.getEnd() != start + 1 || ')' != charsSequence.charAt(start)) break;
                existingRParenthOffset = start;
                break;
            }
            iterator.advance();
        }
        if (existingRParenthOffset >= 0) {
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)editor.getProject());
            psiDocumentManager.commitDocument(document2);
            TextRange range = RParenthTailType.getRangeToCheckParensBalance(psiDocumentManager.getPsiFile(document2), document2, editor.getCaretModel().getOffset());
            int balance = RParenthTailType.calcParensBalance(document2, highlighter, range.getStartOffset(), range.getEndOffset());
            if (balance > 0) {
                return -1;
            }
        }
        return existingRParenthOffset;
    }

    private static int calcParensBalance(Document document2, EditorHighlighter highlighter, int rangeStart, int rangeEnd) {
        LOG.assertTrue(0 <= rangeStart);
        LOG.assertTrue(rangeStart <= rangeEnd);
        LOG.assertTrue(rangeEnd <= document2.getTextLength());
        HighlighterIterator iterator = highlighter.createIterator(rangeStart);
        int balance = 0;
        while (!iterator.atEnd() && iterator.getStart() < rangeEnd) {
            IElementType tokenType = iterator.getTokenType();
            if (tokenType == JavaTokenType.LPARENTH) {
                ++balance;
            } else if (tokenType == JavaTokenType.RPARENTH) {
                --balance;
            }
            iterator.advance();
        }
        return balance;
    }
}

