/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoComposite;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.TrafficTooltipRendererImpl;
import com.intellij.codeInsight.daemon.impl.actions.ShowErrorDescriptionAction;
import com.intellij.codeInsight.hint.LineTooltipRenderer;
import com.intellij.codeInsight.hint.TooltipLinkHandlerEP;
import com.intellij.codeInsight.hint.TooltipRenderer;
import com.intellij.codeInspection.ui.DefaultInspectionToolPresentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.ErrorStripTooltipRendererProvider;
import com.intellij.openapi.editor.impl.TrafficTooltipRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.Html;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DaemonTooltipRendererProvider
implements ErrorStripTooltipRendererProvider {
    @NonNls
    private static final String END_MARKER = "<!-- end marker -->";
    private final Project myProject;

    public DaemonTooltipRendererProvider(Project project2) {
        this.myProject = project2;
    }

    @Override
    public TooltipRenderer calcTooltipRenderer(@NotNull Collection<RangeHighlighter> highlighters) {
        if (highlighters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighters", "com/intellij/codeInsight/daemon/impl/DaemonTooltipRendererProvider", "calcTooltipRenderer"));
        }
        LineTooltipRenderer bigRenderer = null;
        SmartList infos = new SmartList();
        THashSet tooltips = new THashSet();
        for (RangeHighlighter marker : highlighters) {
            Object tooltipObject = marker.getErrorStripeTooltip();
            if (tooltipObject == null) continue;
            if (tooltipObject instanceof HighlightInfo) {
                HighlightInfo info = (HighlightInfo)tooltipObject;
                if (info.getToolTip() == null || !tooltips.add(info.getToolTip())) continue;
                infos.add(info);
                continue;
            }
            String text = tooltipObject.toString();
            if (!tooltips.add(text)) continue;
            if (bigRenderer == null) {
                bigRenderer = new MyRenderer(text, new Object[]{highlighters});
                continue;
            }
            bigRenderer.addBelow(text);
        }
        if (!infos.isEmpty()) {
            ContainerUtil.quickSort((List)infos, (o1, o2) -> {
                int i = SeverityRegistrar.getSeverityRegistrar(this.myProject).compare(o2.getSeverity(), o1.getSeverity());
                if (i != 0) {
                    return i;
                }
                return o1.getToolTip().compareTo(o2.getToolTip());
            });
            HighlightInfoComposite composite = new HighlightInfoComposite((List<HighlightInfo>)infos);
            if (bigRenderer == null) {
                bigRenderer = new MyRenderer(UIUtil.convertSpace2Nbsp((String)composite.getToolTip()), new Object[]{highlighters});
            } else {
                MyRenderer renderer = new MyRenderer(UIUtil.convertSpace2Nbsp((String)composite.getToolTip()), new Object[]{highlighters});
                renderer.addBelow(bigRenderer.getText());
                bigRenderer = renderer;
            }
        }
        return bigRenderer;
    }

    @Override
    @NotNull
    public TooltipRenderer calcTooltipRenderer(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/daemon/impl/DaemonTooltipRendererProvider", "calcTooltipRenderer"));
        }
        MyRenderer myRenderer = new MyRenderer(text, new Object[]{text});
        if (myRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DaemonTooltipRendererProvider", "calcTooltipRenderer"));
        }
        return myRenderer;
    }

    @Override
    @NotNull
    public TooltipRenderer calcTooltipRenderer(@NotNull String text, int width) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/codeInsight/daemon/impl/DaemonTooltipRendererProvider", "calcTooltipRenderer"));
        }
        MyRenderer myRenderer = new MyRenderer(text, width, new Object[]{text});
        if (myRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DaemonTooltipRendererProvider", "calcTooltipRenderer"));
        }
        return myRenderer;
    }

    @Override
    @NotNull
    public TrafficTooltipRenderer createTrafficTooltipRenderer(@NotNull Runnable onHide, @NotNull Editor editor) {
        if (onHide == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onHide", "com/intellij/codeInsight/daemon/impl/DaemonTooltipRendererProvider", "createTrafficTooltipRenderer"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/DaemonTooltipRendererProvider", "createTrafficTooltipRenderer"));
        }
        TrafficTooltipRendererImpl trafficTooltipRendererImpl = new TrafficTooltipRendererImpl(onHide, editor);
        if (trafficTooltipRendererImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/DaemonTooltipRendererProvider", "createTrafficTooltipRenderer"));
        }
        return trafficTooltipRendererImpl;
    }

    private static class MyRenderer
    extends LineTooltipRenderer {
        public MyRenderer(String text, Object[] comparable) {
            super(text, comparable);
        }

        public MyRenderer(String text, int width, Object[] comparable) {
            super(text, width, comparable);
        }

        @Override
        protected void onHide(JComponent contentComponent) {
            ShowErrorDescriptionAction.rememberCurrentWidth(contentComponent.getWidth());
        }

        @Override
        protected boolean dressDescription(@NotNull Editor editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/DaemonTooltipRendererProvider$MyRenderer", "dressDescription"));
            }
            List problems = StringUtil.split((String)UIUtil.getHtmlBody((Html)new Html(this.myText).setKeepFont(true)), (String)"<hr size=1 noshade>");
            String text = "";
            for (String problem : problems) {
                String ref = MyRenderer.getLinkRef(problem);
                if (ref != null) {
                    String description = TooltipLinkHandlerEP.getDescription(ref, editor);
                    if (description == null) continue;
                    description = DefaultInspectionToolPresentation.stripUIRefsFromInspectionDescription(UIUtil.getHtmlBody((Html)new Html(description).setKeepFont(true)));
                    text = text + UIUtil.getHtmlBody((Html)new Html(problem).setKeepFont(true)).replace(DaemonBundle.message((String)"inspection.extended.description", (Object[])new Object[0]), DaemonBundle.message((String)"inspection.collapse.description", (Object[])new Object[0])) + DaemonTooltipRendererProvider.END_MARKER + "<p>" + description + "<hr size=1 noshade>";
                    continue;
                }
                text = text + UIUtil.getHtmlBody((Html)new Html(problem).setKeepFont(true)) + "<hr size=1 noshade>";
            }
            if (!text.isEmpty()) {
                this.myText = XmlStringUtil.wrapInHtml((CharSequence)StringUtil.trimEnd((String)text, (String)"<hr size=1 noshade>"));
                return true;
            }
            return false;
        }

        @Nullable
        private static String getLinkRef(@NonNls String text) {
            String ref;
            int quoteIdx;
            String linkWithRef = "<a href=\"";
            int linkStartIdx = text.indexOf("<a href=\"");
            if (linkStartIdx >= 0 && (quoteIdx = (ref = text.substring(linkStartIdx + "<a href=\"".length())).indexOf(34)) > 0) {
                return ref.substring(0, quoteIdx);
            }
            return null;
        }

        @Override
        protected void stripDescription() {
            List problems = StringUtil.split((String)UIUtil.getHtmlBody((Html)new Html(this.myText).setKeepFont(true)), (String)"<hr size=1 noshade>");
            this.myText = "";
            for (String problem1 : problems) {
                String problem = (String)StringUtil.split((String)problem1, (String)DaemonTooltipRendererProvider.END_MARKER).get(0);
                this.myText = this.myText + UIUtil.getHtmlBody((Html)new Html(problem).setKeepFont(true)).replace(DaemonBundle.message((String)"inspection.collapse.description", (Object[])new Object[0]), DaemonBundle.message((String)"inspection.extended.description", (Object[])new Object[0])) + "<hr size=1 noshade>";
            }
            this.myText = XmlStringUtil.wrapInHtml((CharSequence)StringUtil.trimEnd((String)this.myText, (String)"<hr size=1 noshade>"));
        }

        @Override
        protected LineTooltipRenderer createRenderer(String text, int width) {
            return new MyRenderer(text, width, this.getEqualityObjects());
        }
    }
}

