/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonListeners;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightingSession;
import com.intellij.codeInsight.daemon.impl.HighlightingSessionImpl;
import com.intellij.codeInsight.daemon.impl.ShowAutoImportPass;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.EditorMarkupModelImpl;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.Alarm;
import com.intellij.util.Processor;
import com.intellij.util.ui.UIUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultHighlightInfoProcessor
extends HighlightInfoProcessor {
    private final Alarm repaintIconAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);

    @Override
    public void highlightsInsideVisiblePartAreProduced(@NotNull HighlightingSession session2, @NotNull List<HighlightInfo> infos, @NotNull TextRange priorityRange, @NotNull TextRange restrictRange, int groupId) {
        if (session2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor", "highlightsInsideVisiblePartAreProduced"));
        }
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor", "highlightsInsideVisiblePartAreProduced"));
        }
        if (priorityRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "priorityRange", "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor", "highlightsInsideVisiblePartAreProduced"));
        }
        if (restrictRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "restrictRange", "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor", "highlightsInsideVisiblePartAreProduced"));
        }
        PsiFile psiFile = session2.getPsiFile();
        Project project2 = psiFile.getProject();
        Document document2 = PsiDocumentManager.getInstance((Project)project2).getDocument(psiFile);
        if (document2 == null) {
            return;
        }
        long modificationStamp = document2.getModificationStamp();
        TextRange priorityIntersection = priorityRange.intersection(restrictRange);
        Editor editor = session2.getEditor();
        TransactionGuard.submitTransaction((Disposable)project2, () -> {
            if (session2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor", "lambda$highlightsInsideVisiblePartAreProduced$0"));
            }
            if (infos == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor", "lambda$highlightsInsideVisiblePartAreProduced$0"));
            }
            if (modificationStamp != document2.getModificationStamp()) {
                return;
            }
            if (priorityIntersection != null) {
                MarkupModel markupModel = DocumentMarkupModel.forDocument(document2, project2, true);
                EditorColorsScheme scheme = session2.getColorsScheme();
                UpdateHighlightersUtil.setHighlightersInRange(project2, document2, priorityIntersection, scheme, infos, (MarkupModelEx)markupModel, groupId);
            }
            if (editor != null && !editor.isDisposed()) {
                if (!DumbService.isDumb((Project)project2)) {
                    void psiFile2;
                    new ShowAutoImportPass(project2, (PsiFile)psiFile2, editor).addImports();
                }
                DaemonListeners.repaintErrorStripeRenderer(editor, project2);
            }
        });
    }

    @Override
    public void highlightsOutsideVisiblePartAreProduced(@NotNull HighlightingSession session2, @NotNull List<HighlightInfo> infos, @NotNull TextRange priorityRange, @NotNull TextRange restrictedRange, int groupId) {
        if (session2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor", "highlightsOutsideVisiblePartAreProduced"));
        }
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor", "highlightsOutsideVisiblePartAreProduced"));
        }
        if (priorityRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "priorityRange", "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor", "highlightsOutsideVisiblePartAreProduced"));
        }
        if (restrictedRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "restrictedRange", "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor", "highlightsOutsideVisiblePartAreProduced"));
        }
        PsiFile psiFile = session2.getPsiFile();
        Project project2 = psiFile.getProject();
        Document document2 = PsiDocumentManager.getInstance((Project)project2).getDocument(psiFile);
        if (document2 == null) {
            return;
        }
        long modificationStamp = document2.getModificationStamp();
        UIUtil.invokeLaterIfNeeded(() -> {
            void groupId;
            if (session2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor", "lambda$highlightsOutsideVisiblePartAreProduced$1"));
            }
            if (infos == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor", "lambda$highlightsOutsideVisiblePartAreProduced$1"));
            }
            if (restrictedRange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "restrictedRange", "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor", "lambda$highlightsOutsideVisiblePartAreProduced$1"));
            }
            if (priorityRange == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "priorityRange", "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor", "lambda$highlightsOutsideVisiblePartAreProduced$1"));
            }
            if (project2.isDisposed() || modificationStamp != document2.getModificationStamp()) {
                return;
            }
            EditorColorsScheme scheme = session2.getColorsScheme();
            UpdateHighlightersUtil.setHighlightersOutsideRange(project2, document2, psiFile, infos, scheme, restrictedRange.getStartOffset(), restrictedRange.getEndOffset(), ProperTextRange.create((Segment)priorityRange), (int)groupId);
            Editor editor = session2.getEditor();
            if (editor != null) {
                DaemonListeners.repaintErrorStripeRenderer(editor, project2);
            }
        });
    }

    @Override
    public void allHighlightsForRangeAreProduced(@NotNull HighlightingSession session2, @NotNull TextRange elementRange, @Nullable List<HighlightInfo> infos) {
        if (session2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor", "allHighlightsForRangeAreProduced"));
        }
        if (elementRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementRange", "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor", "allHighlightsForRangeAreProduced"));
        }
        PsiFile psiFile = session2.getPsiFile();
        DefaultHighlightInfoProcessor.killAbandonedHighlightsUnder(psiFile, elementRange, infos, session2);
    }

    private static void killAbandonedHighlightsUnder(@NotNull PsiFile psiFile, @NotNull TextRange range, @Nullable List<HighlightInfo> infos, @NotNull HighlightingSession highlightingSession) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor", "killAbandonedHighlightsUnder"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor", "killAbandonedHighlightsUnder"));
        }
        if (highlightingSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightingSession", "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor", "killAbandonedHighlightsUnder"));
        }
        Project project2 = psiFile.getProject();
        Document document2 = PsiDocumentManager.getInstance((Project)project2).getDocument(psiFile);
        if (document2 == null) {
            return;
        }
        DaemonCodeAnalyzerEx.processHighlights(document2, project2, null, range.getStartOffset(), range.getEndOffset(), (Processor<HighlightInfo>)((Processor)existing -> {
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor", "lambda$killAbandonedHighlightsUnder$2"));
            }
            if (highlightingSession == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightingSession", "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor", "lambda$killAbandonedHighlightsUnder$2"));
            }
            if (existing.isBijective() && existing.getGroup() == 4 && range.equalsToRange(existing.getActualStartOffset(), existing.getActualEndOffset())) {
                if (infos != null) {
                    for (HighlightInfo created : infos) {
                        if (!existing.equalsByActualOffset(created)) continue;
                        return true;
                    }
                }
                ((HighlightingSessionImpl)highlightingSession).queueDisposeHighlighter(existing.highlighter);
            }
            return true;
        }));
    }

    @Override
    public void infoIsAvailable(@NotNull HighlightingSession session2, @NotNull HighlightInfo info, @NotNull TextRange priorityRange, @NotNull TextRange restrictedRange, int groupId) {
        if (session2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor", "infoIsAvailable"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor", "infoIsAvailable"));
        }
        if (priorityRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "priorityRange", "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor", "infoIsAvailable"));
        }
        if (restrictedRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "restrictedRange", "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor", "infoIsAvailable"));
        }
        HighlightingSessionImpl impl = (HighlightingSessionImpl)session2;
        impl.queueHighlightInfo(info, priorityRange, restrictedRange, groupId);
    }

    @Override
    public void progressIsAdvanced(@NotNull HighlightingSession highlightingSession, double progress) {
        if (highlightingSession == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightingSession", "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor", "progressIsAdvanced"));
        }
        PsiFile file2 = highlightingSession.getPsiFile();
        Editor editor = highlightingSession.getEditor();
        this.repaintTrafficIcon(file2, editor, progress);
    }

    private void repaintTrafficIcon(@NotNull PsiFile file2, Editor editor, double progress) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor", "repaintTrafficIcon"));
        }
        if (ApplicationManager.getApplication().isCommandLine()) {
            return;
        }
        if (this.repaintIconAlarm.isEmpty() || progress >= 1.0) {
            this.repaintIconAlarm.addRequest(() -> {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/DefaultHighlightInfoProcessor", "lambda$repaintTrafficIcon$3"));
                }
                Project myProject = file2.getProject();
                if (myProject.isDisposed()) {
                    return;
                }
                Editor myeditor = editor;
                if (myeditor == null) {
                    myeditor = PsiUtilBase.findEditor((PsiElement)file2);
                }
                if (myeditor == null || myeditor.isDisposed()) {
                    return;
                }
                EditorMarkupModelImpl markup = (EditorMarkupModelImpl)myeditor.getMarkupModel();
                markup.repaintTrafficLightIcon();
                DaemonListeners.repaintErrorStripeRenderer(myeditor, myProject);
            }, 50, null);
        }
    }
}

