/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.CollectHighlightsUtil;
import com.intellij.codeInsight.daemon.impl.Divider;
import com.intellij.codeInsight.daemon.impl.GeneralHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.concurrency.JobLauncher;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.impl.source.tree.injected.Place;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ConcurrentList;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InjectedGeneralHighlightingPass
extends GeneralHighlightingPass
implements DumbAware {
    private static final String PRESENTABLE_NAME = "Injected fragments";

    InjectedGeneralHighlightingPass(@NotNull Project project2, @NotNull PsiFile file2, @NotNull Document document2, int startOffset, int endOffset, boolean updateAll, @NotNull ProperTextRange priorityRange, @Nullable Editor editor, @NotNull HighlightInfoProcessor highlightInfoProcessor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPass", "<init>"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPass", "<init>"));
        }
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPass", "<init>"));
        }
        if (priorityRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "priorityRange", "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPass", "<init>"));
        }
        if (highlightInfoProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlightInfoProcessor", "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPass", "<init>"));
        }
        super(project2, file2, document2, startOffset, endOffset, updateAll, priorityRange, editor, highlightInfoProcessor);
    }

    @Override
    protected String getPresentableName() {
        return PRESENTABLE_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void collectInformationWithProgress(@NotNull ProgressIndicator progress) {
        THashSet result2;
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPass", "collectInformationWithProgress"));
        }
        if (!Registry.is((String)"editor.injected.highlighting.enabled")) {
            return;
        }
        THashSet gotHighlights = new THashSet(100);
        ArrayList<PsiElement> inside = new ArrayList<PsiElement>();
        ArrayList<PsiElement> outside = new ArrayList<PsiElement>();
        ArrayList<ProperTextRange> insideRanges = new ArrayList<ProperTextRange>();
        ArrayList<ProperTextRange> outsideRanges = new ArrayList<ProperTextRange>();
        Divider.divideInsideAndOutside(this.myFile, this.myRestrictRange.getStartOffset(), this.myRestrictRange.getEndOffset(), (TextRange)this.myPriorityRange, inside, insideRanges, outside, outsideRanges, false, (Condition<PsiFile>)SHOULD_HIGHLIGHT_FILTER);
        THashSet injectedResult = new THashSet();
        Set<PsiFile> injected = this.getInjectedPsiFiles(inside, outside, progress);
        this.setProgressLimit(injected.size());
        if (!this.addInjectedPsiHighlights(injected, progress, Collections.synchronizedSet(injectedResult))) {
            throw new ProcessCanceledException();
        }
        ArrayList<HighlightInfo> injectionsOutside = new ArrayList<HighlightInfo>(gotHighlights.size());
        THashSet tHashSet = injectedResult;
        synchronized (tHashSet) {
            result2 = injectedResult;
        }
        for (HighlightInfo info : result2) {
            if (this.myRestrictRange.contains((Segment)info)) {
                gotHighlights.add(info);
                continue;
            }
            injectionsOutside.add(info);
        }
        if (!injectionsOutside.isEmpty()) {
            ProperTextRange priorityIntersection = this.myPriorityRange.intersection(this.myRestrictRange);
            if (!(inside.isEmpty() && gotHighlights.isEmpty() || priorityIntersection == null)) {
                ArrayList<HighlightInfo> toApplyInside = new ArrayList<HighlightInfo>((Collection<HighlightInfo>)gotHighlights);
                this.myHighlights.addAll(toApplyInside);
                gotHighlights.clear();
                this.myHighlightInfoProcessor.highlightsInsideVisiblePartAreProduced(this.myHighlightingSession, toApplyInside, (TextRange)this.myPriorityRange, this.myRestrictRange, this.getId());
            }
            ArrayList<HighlightInfo> toApply = new ArrayList<HighlightInfo>();
            for (HighlightInfo info : gotHighlights) {
                if (!this.myRestrictRange.containsRange(info.getStartOffset(), info.getEndOffset()) || this.myPriorityRange.containsRange(info.getStartOffset(), info.getEndOffset())) continue;
                toApply.add(info);
            }
            toApply.addAll(injectionsOutside);
            this.myHighlightInfoProcessor.highlightsOutsideVisiblePartAreProduced(this.myHighlightingSession, toApply, this.myRestrictRange, (TextRange)new ProperTextRange(0, this.myDocument.getTextLength()), this.getId());
        } else {
            this.myHighlights.addAll(gotHighlights);
            this.myHighlightInfoProcessor.highlightsInsideVisiblePartAreProduced(this.myHighlightingSession, this.myHighlights, this.myRestrictRange, this.myRestrictRange, this.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private Set<PsiFile> getInjectedPsiFiles(@NotNull List<PsiElement> elements1, @NotNull List<PsiElement> elements2, @NotNull ProgressIndicator progress) {
        if (elements1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements1", "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPass", "getInjectedPsiFiles"));
        }
        if (elements2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements2", "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPass", "getInjectedPsiFiles"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPass", "getInjectedPsiFiles"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        THashSet outInjected = new THashSet();
        ConcurrentList<DocumentWindow> injected = InjectedLanguageUtil.getCachedInjectedDocuments(this.myFile);
        THashSet hosts = new THashSet(elements1.size() + elements2.size() + injected.size());
        for (DocumentWindow documentRange : injected) {
            PsiLanguageInjectionHost context;
            PsiFile file2;
            progress.checkCanceled();
            if (!documentRange.isValid() || (file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile((Document)documentRange)) == null || (context = InjectedLanguageManager.getInstance((Project)file2.getProject()).getInjectionHost((PsiElement)file2)) == null || !context.isValid() || file2.getProject().isDisposed() || !this.myUpdateAll && !this.myRestrictRange.intersects(context.getTextRange())) continue;
            hosts.add(context);
        }
        InjectedLanguageManagerImpl injectedLanguageManager = InjectedLanguageManagerImpl.getInstanceImpl(this.myProject);
        Processor collectInjectableProcessor = Processors.cancelableCollectProcessor((Collection)hosts);
        injectedLanguageManager.processInjectableElements(elements1, (Processor<PsiElement>)collectInjectableProcessor);
        injectedLanguageManager.processInjectableElements(elements2, (Processor<PsiElement>)collectInjectableProcessor);
        PsiLanguageInjectionHost.InjectedPsiVisitor visitor = new PsiLanguageInjectionHost.InjectedPsiVisitor((Set)outInjected){
            final /* synthetic */ Set val$outInjected;
            {
                this.val$outInjected = set;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                if (injectedPsi == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedPsi", "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPass$1", "visit"));
                }
                if (places == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "places", "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPass$1", "visit"));
                }
                Set set = this.val$outInjected;
                synchronized (set) {
                    this.val$outInjected.add(injectedPsi);
                }
            }
        };
        if (!JobLauncher.getInstance().invokeConcurrentlyUnderProgress(new ArrayList(hosts), progress, true, element -> {
            if (progress == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPass", "lambda$getInjectedPsiFiles$0"));
            }
            ApplicationManager.getApplication().assertReadAccessAllowed();
            progress.checkCanceled();
            InjectedLanguageUtil.enumerate(element, this.myFile, false, visitor);
            return true;
        })) {
            throw new ProcessCanceledException();
        }
        THashSet tHashSet2 = outInjected;
        // MONITORENTER : tHashSet2
        THashSet tHashSet = outInjected;
        // MONITOREXIT : tHashSet2
        if (tHashSet != null) return tHashSet;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPass", "getInjectedPsiFiles"));
    }

    private boolean addInjectedPsiHighlights(@NotNull Set<PsiFile> injectedFiles, @NotNull ProgressIndicator progress, @NotNull Collection<HighlightInfo> outInfos) {
        if (injectedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedFiles", "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPass", "addInjectedPsiHighlights"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPass", "addInjectedPsiHighlights"));
        }
        if (outInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outInfos", "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPass", "addInjectedPsiHighlights"));
        }
        if (injectedFiles.isEmpty()) {
            return true;
        }
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)this.myProject);
        TextAttributes injectedAttributes = this.myGlobalScheme.getAttributes(EditorColors.INJECTED_LANGUAGE_FRAGMENT);
        return JobLauncher.getInstance().invokeConcurrentlyUnderProgress(new ArrayList<PsiFile>(injectedFiles), progress, this.isFailFastOnAcquireReadAction(), injectedPsi -> {
            if (outInfos == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outInfos", "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPass", "lambda$addInjectedPsiHighlights$1"));
            }
            if (progress == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPass", "lambda$addInjectedPsiHighlights$1"));
            }
            return this.addInjectedPsiHighlights((PsiFile)injectedPsi, injectedAttributes, outInfos, progress, injectedLanguageManager);
        });
    }

    private boolean addInjectedPsiHighlights(@NotNull PsiFile injectedPsi, TextAttributes injectedAttributes, @NotNull Collection<HighlightInfo> outInfos, @NotNull ProgressIndicator progress, @NotNull InjectedLanguageManager injectedLanguageManager) {
        if (injectedPsi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedPsi", "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPass", "addInjectedPsiHighlights"));
        }
        if (outInfos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outInfos", "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPass", "addInjectedPsiHighlights"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPass", "addInjectedPsiHighlights"));
        }
        if (injectedLanguageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedLanguageManager", "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPass", "addInjectedPsiHighlights"));
        }
        DocumentWindow documentWindow = (DocumentWindow)PsiDocumentManager.getInstance((Project)this.myProject).getCachedDocument(injectedPsi);
        if (documentWindow == null) {
            return true;
        }
        Place places = InjectedLanguageUtil.getShreds(injectedPsi);
        boolean addTooltips = places.size() < 100;
        Iterator iterator = places.iterator();
        while (iterator.hasNext()) {
            TextRange textRange;
            PsiLanguageInjectionHost.Shred place = (PsiLanguageInjectionHost.Shred)iterator.next();
            PsiLanguageInjectionHost host = place.getHost();
            if (host == null || (textRange = place.getRangeInsideHost().shiftRight(host.getTextRange().getStartOffset())).isEmpty()) continue;
            HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo(HighlightInfoType.INJECTED_LANGUAGE_BACKGROUND).range(textRange);
            if (injectedAttributes != null && InjectedLanguageUtil.isHighlightInjectionBackground(host)) {
                builder.textAttributes(injectedAttributes);
            }
            if (addTooltips) {
                String desc = injectedPsi.getLanguage().getDisplayName() + ": " + injectedPsi.getText();
                builder.unescapedToolTip(desc);
            }
            HighlightInfo info = builder.createUnconditionally();
            info.setFromInjection(true);
            outInfos.add(info);
        }
        HighlightInfoHolder holder = this.createInfoHolder(injectedPsi);
        this.runHighlightVisitorsForInjected(injectedPsi, holder, progress);
        for (int i = 0; i < holder.size(); ++i) {
            HighlightInfo info = holder.get(i);
            int startOffset = documentWindow.injectedToHost(info.startOffset);
            TextRange fixedTextRange = InjectedGeneralHighlightingPass.getFixedTextRange(documentWindow, startOffset);
            InjectedGeneralHighlightingPass.addPatchedInfos(info, injectedPsi, documentWindow, injectedLanguageManager, fixedTextRange, outInfos);
        }
        int injectedStart = holder.size();
        this.highlightInjectedSyntax(injectedPsi, holder);
        for (int i = injectedStart; i < holder.size(); ++i) {
            HighlightInfo info = holder.get(i);
            int startOffset = info.startOffset;
            TextRange fixedTextRange = InjectedGeneralHighlightingPass.getFixedTextRange(documentWindow, startOffset);
            if (fixedTextRange == null) {
                info.setFromInjection(true);
                outInfos.add(info);
                continue;
            }
            HighlightInfo patched = new HighlightInfo(info.forcedTextAttributes, info.forcedTextAttributesKey, info.type, fixedTextRange.getStartOffset(), fixedTextRange.getEndOffset(), info.getDescription(), info.getToolTip(), info.type.getSeverity(null), info.isAfterEndOfLine(), null, false, 0, info.getProblemGroup(), info.getGutterIconRenderer());
            patched.setFromInjection(true);
            outInfos.add(patched);
        }
        if (!this.isDumbMode()) {
            ArrayList<HighlightInfo> todos = new ArrayList<HighlightInfo>();
            InjectedGeneralHighlightingPass.highlightTodos(injectedPsi, injectedPsi.getText(), 0, injectedPsi.getTextLength(), progress, this.myPriorityRange, todos, todos);
            for (HighlightInfo info : todos) {
                InjectedGeneralHighlightingPass.addPatchedInfos(info, injectedPsi, documentWindow, injectedLanguageManager, null, outInfos);
            }
        }
        this.advanceProgress(1L);
        return true;
    }

    @Nullable(value="null means invalid")
    private static TextRange getFixedTextRange(@NotNull DocumentWindow documentWindow, int startOffset) {
        ProperTextRange fixedTextRange;
        if (documentWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentWindow", "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPass", "getFixedTextRange"));
        }
        TextRange textRange = documentWindow.getHostRange(startOffset);
        if (textRange == null) {
            textRange = InjectedGeneralHighlightingPass.findNearestTextRange(documentWindow, startOffset);
            if (textRange == null) {
                return null;
            }
            boolean isBefore = startOffset < textRange.getStartOffset();
            fixedTextRange = new ProperTextRange(isBefore ? textRange.getStartOffset() - 1 : textRange.getEndOffset(), isBefore ? textRange.getStartOffset() : textRange.getEndOffset() + 1);
        } else {
            fixedTextRange = null;
        }
        return fixedTextRange;
    }

    private static void addPatchedInfos(@NotNull HighlightInfo info, @NotNull PsiFile injectedPsi, @NotNull DocumentWindow documentWindow, @NotNull InjectedLanguageManager injectedLanguageManager, @Nullable TextRange fixedTextRange, @NotNull Collection<HighlightInfo> out) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPass", "addPatchedInfos"));
        }
        if (injectedPsi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedPsi", "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPass", "addPatchedInfos"));
        }
        if (documentWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentWindow", "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPass", "addPatchedInfos"));
        }
        if (injectedLanguageManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedLanguageManager", "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPass", "addPatchedInfos"));
        }
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPass", "addPatchedInfos"));
        }
        ProperTextRange textRange = new ProperTextRange(info.startOffset, info.endOffset);
        List editables = injectedLanguageManager.intersectWithAllEditableFragments(injectedPsi, (TextRange)textRange);
        for (TextRange editable : editables) {
            TextRange hostRange = fixedTextRange == null ? documentWindow.injectedToHost(editable) : fixedTextRange;
            boolean isAfterEndOfLine = info.isAfterEndOfLine();
            if (isAfterEndOfLine) {
                int hostEndOffset = hostRange.getEndOffset();
                int lineNumber = documentWindow.getDelegate().getLineNumber(hostEndOffset);
                int hostLineEndOffset = documentWindow.getDelegate().getLineEndOffset(lineNumber);
                if (hostEndOffset < hostLineEndOffset) {
                    isAfterEndOfLine = false;
                    hostRange = new ProperTextRange(hostRange.getStartOffset(), hostEndOffset + 1);
                }
            }
            HighlightInfo patched = new HighlightInfo(info.forcedTextAttributes, info.forcedTextAttributesKey, info.type, hostRange.getStartOffset(), hostRange.getEndOffset(), info.getDescription(), info.getToolTip(), info.type.getSeverity(null), isAfterEndOfLine, null, false, 0, info.getProblemGroup(), info.getGutterIconRenderer());
            patched.setHint(info.hasHint());
            if (info.quickFixActionRanges != null) {
                for (Pair<HighlightInfo.IntentionActionDescriptor, TextRange> pair : info.quickFixActionRanges) {
                    TextRange quickfixTextRange = (TextRange)pair.getSecond();
                    List editableQF = injectedLanguageManager.intersectWithAllEditableFragments(injectedPsi, quickfixTextRange);
                    for (TextRange editableRange : editableQF) {
                        HighlightInfo.IntentionActionDescriptor descriptor = (HighlightInfo.IntentionActionDescriptor)pair.getFirst();
                        if (patched.quickFixActionRanges == null) {
                            patched.quickFixActionRanges = new ArrayList<Pair<HighlightInfo.IntentionActionDescriptor, TextRange>>();
                        }
                        TextRange hostEditableRange = documentWindow.injectedToHost(editableRange);
                        patched.quickFixActionRanges.add((Pair<HighlightInfo.IntentionActionDescriptor, TextRange>)Pair.create((Object)descriptor, (Object)hostEditableRange));
                    }
                }
            }
            patched.setFromInjection(true);
            out.add(patched);
        }
    }

    @Nullable(value="null means invalid")
    private static TextRange findNearestTextRange(DocumentWindow documentWindow, int startOffset) {
        Segment marker;
        ProperTextRange curRange;
        ProperTextRange textRange = null;
        Segment[] segmentArray = documentWindow.getHostRanges();
        int n = segmentArray.length;
        for (int i = 0; i < n && ((curRange = ProperTextRange.create((Segment)(marker = segmentArray[i]))).getStartOffset() <= startOffset || textRange == null); ++i) {
            textRange = curRange;
        }
        return textRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runHighlightVisitorsForInjected(@NotNull PsiFile injectedPsi, @NotNull HighlightInfoHolder holder, @NotNull ProgressIndicator progress) {
        if (injectedPsi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedPsi", "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPass", "runHighlightVisitorsForInjected"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPass", "runHighlightVisitorsForInjected"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPass", "runHighlightVisitorsForInjected"));
        }
        HighlightVisitor[] filtered = this.getHighlightVisitors(injectedPsi);
        try {
            List<PsiElement> elements = CollectHighlightsUtil.getElementsInRange((PsiElement)injectedPsi, 0, injectedPsi.getTextLength());
            for (HighlightVisitor visitor : filtered) {
                visitor.analyze(injectedPsi, true, holder, () -> {
                    if (progress == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPass", "lambda$runHighlightVisitorsForInjected$2"));
                    }
                    for (PsiElement element : elements) {
                        progress.checkCanceled();
                        visitor.visit(element);
                    }
                });
            }
        }
        finally {
            this.incVisitorUsageCount(-1);
        }
    }

    private void highlightInjectedSyntax(@NotNull PsiFile injectedPsi, @NotNull HighlightInfoHolder holder) {
        if (injectedPsi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "injectedPsi", "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPass", "highlightInjectedSyntax"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInsight/daemon/impl/InjectedGeneralHighlightingPass", "highlightInjectedSyntax"));
        }
        List<Trinity<IElementType, SmartPsiElementPointer<PsiLanguageInjectionHost>, TextRange>> tokens = InjectedLanguageUtil.getHighlightTokens(injectedPsi);
        if (tokens == null) {
            return;
        }
        Language injectedLanguage = injectedPsi.getLanguage();
        Project project2 = injectedPsi.getProject();
        SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)injectedLanguage, (Project)project2, (VirtualFile)injectedPsi.getVirtualFile());
        TextAttributes defaultAttrs = this.myGlobalScheme.getAttributes(HighlighterColors.TEXT);
        for (Trinity<IElementType, SmartPsiElementPointer<PsiLanguageInjectionHost>, TextRange> token : tokens) {
            TextAttributes forcedAttributes;
            ProgressManager.checkCanceled();
            IElementType tokenType = (IElementType)token.getFirst();
            PsiLanguageInjectionHost injectionHost = (PsiLanguageInjectionHost)((SmartPsiElementPointer)token.getSecond()).getElement();
            if (injectionHost == null) continue;
            TextRange textRange = (TextRange)token.getThird();
            TextAttributesKey[] keys = syntaxHighlighter.getTokenHighlights(tokenType);
            if (textRange.getLength() == 0) continue;
            TextRange annRange = textRange.shiftRight(injectionHost.getTextRange().getStartOffset());
            TextAttributes attributes = null;
            for (TextAttributesKey key2 : keys) {
                TextAttributes attrs2 = this.myGlobalScheme.getAttributes(key2);
                if (attrs2 == null) continue;
                attributes = attributes == null ? attrs2 : TextAttributes.merge((TextAttributes)attributes, (TextAttributes)attrs2);
            }
            if (attributes == null || attributes.isEmpty() || attributes.equals((Object)defaultAttrs)) {
                forcedAttributes = TextAttributes.ERASE_MARKER;
            } else {
                HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.INJECTED_LANGUAGE_FRAGMENT).range(annRange).textAttributes(TextAttributes.ERASE_MARKER).createUnconditionally();
                holder.add(info);
                forcedAttributes = new TextAttributes(attributes.getForegroundColor(), attributes.getBackgroundColor(), attributes.getEffectColor(), attributes.getEffectType(), attributes.getFontType());
            }
            HighlightInfo info = HighlightInfo.newHighlightInfo(HighlightInfoType.INJECTED_LANGUAGE_FRAGMENT).range(annRange).textAttributes(forcedAttributes).createUnconditionally();
            holder.add(info);
        }
    }

    @Override
    protected void applyInformationWithProgress() {
    }
}

