/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;

class PsiMethodReferenceHighlightingUtil {
    PsiMethodReferenceHighlightingUtil() {
    }

    static HighlightInfo checkRawConstructorReference(@NotNull PsiMethodReferenceExpression expression) {
        PsiElement resolve2;
        PsiElement qualifier;
        PsiType[] typeParameters;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInsight/daemon/impl/analysis/PsiMethodReferenceHighlightingUtil", "checkRawConstructorReference"));
        }
        if (expression.isConstructor() && (typeParameters = expression.getTypeParameters()).length > 0 && (qualifier = expression.getQualifier()) instanceof PsiReferenceExpression && (resolve2 = ((PsiReferenceExpression)qualifier).resolve()) instanceof PsiClass && ((PsiClass)resolve2).hasTypeParameters()) {
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range((PsiElement)expression).descriptionAndTooltip("Raw constructor reference with explicit type parameters for constructor").create();
        }
        return null;
    }
}

