/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import java.util.Arrays;
import java.util.Comparator;

public class ReferenceNameExpression
extends Expression {
    LookupElement[] myItems;
    private final String myOldReferenceName;

    public ReferenceNameExpression(LookupElement[] items, String oldReferenceName) {
        this.myItems = items;
        this.myOldReferenceName = oldReferenceName;
        Arrays.sort(this.myItems, new HammingComparator());
    }

    public Result calculateResult(ExpressionContext context) {
        if (this.myItems == null || this.myItems.length == 0) {
            return new TextResult(this.myOldReferenceName);
        }
        return new TextResult(this.myItems[0].getLookupString());
    }

    public Result calculateQuickResult(ExpressionContext context) {
        return null;
    }

    public LookupElement[] calculateLookupItems(ExpressionContext context) {
        if (this.myItems == null || this.myItems.length == 1) {
            return null;
        }
        return this.myItems;
    }

    class HammingComparator
    implements Comparator<LookupElement> {
        HammingComparator() {
        }

        @Override
        public int compare(LookupElement lookupItem1, LookupElement lookupItem2) {
            String s1 = lookupItem1.getLookupString();
            String s2 = lookupItem2.getLookupString();
            int diff1 = 0;
            for (int i = 0; i < Math.min(s1.length(), ReferenceNameExpression.this.myOldReferenceName.length()); ++i) {
                if (s1.charAt(i) == ReferenceNameExpression.this.myOldReferenceName.charAt(i)) continue;
                ++diff1;
            }
            int diff2 = 0;
            for (int i = 0; i < Math.min(s2.length(), ReferenceNameExpression.this.myOldReferenceName.length()); ++i) {
                if (s2.charAt(i) == ReferenceNameExpression.this.myOldReferenceName.charAt(i)) continue;
                ++diff2;
            }
            return diff1 - diff2;
        }
    }
}

