/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.ArgumentFixerActionFactory;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodArgumentFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WrapArrayToArraysAsListFix
extends MethodArgumentFix {
    public static final ArgumentFixerActionFactory REGISTAR = new MyFixerActionFactory();

    protected WrapArrayToArraysAsListFix(@NotNull PsiExpressionList list, int i, @NotNull PsiType toType, @NotNull ArgumentFixerActionFactory fixerActionFactory) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/codeInsight/daemon/impl/quickfix/WrapArrayToArraysAsListFix", "<init>"));
        }
        if (toType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toType", "com/intellij/codeInsight/daemon/impl/quickfix/WrapArrayToArraysAsListFix", "<init>"));
        }
        if (fixerActionFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fixerActionFactory", "com/intellij/codeInsight/daemon/impl/quickfix/WrapArrayToArraysAsListFix", "<init>"));
        }
        super(list, i, toType, fixerActionFactory);
    }

    @NotNull
    public String getText() {
        if (this.myArgList.getExpressions().length == 1) {
            String string = QuickFixBundle.message("wrap.array.to.arrays.as.list.single.parameter.text", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/WrapArrayToArraysAsListFix", "getText"));
            }
            return string;
        }
        String string = QuickFixBundle.message("wrap.array.to.arrays.as.list.parameter.text", this.myIndex + 1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/WrapArrayToArraysAsListFix", "getText"));
        }
        return string;
    }

    public static class MyFixerActionFactory
    extends ArgumentFixerActionFactory {
        @Override
        @Nullable
        protected PsiExpression getModifiedArgument(PsiExpression expression, PsiType toType) throws IncorrectOperationException {
            PsiType exprType = expression.getType();
            if (!(exprType instanceof PsiArrayType) || !(toType instanceof PsiClassType)) {
                return null;
            }
            PsiClass resolvedToType = ((PsiClassType)toType).resolve();
            if (resolvedToType == null) {
                return null;
            }
            PsiClass javaUtilList = MyFixerActionFactory.getJavaUtilList((PsiElement)expression);
            if (javaUtilList == null || !InheritanceUtil.isInheritorOrSelf((PsiClass)javaUtilList, (PsiClass)resolvedToType, (boolean)true)) {
                return null;
            }
            PsiType[] parameters = ((PsiClassType)toType).getParameters();
            PsiType arrayComponentType = ((PsiArrayType)exprType).getComponentType();
            if (parameters.length != 1 || !parameters[0].equals(arrayComponentType)) {
                return null;
            }
            String rawNewExpression = String.format("java.util.Arrays.asList(%s)", expression.getText());
            Project project2 = expression.getProject();
            PsiExpression newExpression = JavaPsiFacade.getInstance((Project)project2).getElementFactory().createExpressionFromText(rawNewExpression, null);
            return (PsiExpression)JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences((PsiElement)newExpression);
        }

        @Nullable
        private static PsiClass getJavaUtilList(PsiElement context) {
            return JavaPsiFacade.getInstance((Project)context.getProject()).findClass("java.util.List", context.getResolveScope());
        }

        @Override
        public boolean areTypesConvertible(@NotNull PsiType exprType, @NotNull PsiType parameterType, @NotNull PsiElement context) {
            if (exprType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exprType", "com/intellij/codeInsight/daemon/impl/quickfix/WrapArrayToArraysAsListFix$MyFixerActionFactory", "areTypesConvertible"));
            }
            if (parameterType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameterType", "com/intellij/codeInsight/daemon/impl/quickfix/WrapArrayToArraysAsListFix$MyFixerActionFactory", "areTypesConvertible"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/daemon/impl/quickfix/WrapArrayToArraysAsListFix$MyFixerActionFactory", "areTypesConvertible"));
            }
            return true;
        }

        @Override
        public MethodArgumentFix createFix(PsiExpressionList list, int i, PsiType toType) {
            return new WrapArrayToArraysAsListFix(list, i, toType, this);
        }
    }
}

