/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.editorActions.JoinLinesHandlerDelegate;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.util.IncorrectOperationException;

public class BlockJoinLinesHandler
implements JoinLinesHandlerDelegate {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.editorActions.BlockJoinLinesHandler");

    public int tryJoinLines(Document document2, PsiFile psiFile, int start, int end) {
        PsiElement elementAtStartLineEnd = psiFile.findElementAt(start);
        PsiElement elementAtNextLineStart = psiFile.findElementAt(end);
        if (elementAtStartLineEnd == null || elementAtNextLineStart == null) {
            return -1;
        }
        if (!(elementAtStartLineEnd instanceof PsiJavaToken) || ((PsiJavaToken)elementAtStartLineEnd).getTokenType() != JavaTokenType.LBRACE) {
            return -1;
        }
        PsiElement codeBlock = elementAtStartLineEnd.getParent();
        if (!(codeBlock instanceof PsiCodeBlock)) {
            return -1;
        }
        if (!(codeBlock.getParent() instanceof PsiBlockStatement)) {
            return -1;
        }
        PsiElement parentStatement = codeBlock.getParent().getParent();
        if (BlockJoinLinesHandler.getForceBraceSetting(parentStatement) == 3) {
            return -1;
        }
        PsiElement foundStatement = null;
        for (PsiElement element = elementAtStartLineEnd.getNextSibling(); element != null; element = element.getNextSibling()) {
            if (element instanceof PsiWhiteSpace) continue;
            if (element instanceof PsiJavaToken && ((PsiJavaToken)element).getTokenType() == JavaTokenType.RBRACE && element.getParent() == codeBlock) {
                if (foundStatement != null) break;
                return -1;
            }
            if (foundStatement != null) {
                return -1;
            }
            foundStatement = element;
        }
        try {
            PsiElement newStatement = codeBlock.getParent().replace(foundStatement);
            return newStatement.getTextRange().getStartOffset();
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return -1;
        }
    }

    private static int getForceBraceSetting(PsiElement statement2) {
        CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)statement2.getProject());
        CommonCodeStyleSettings codeStyleSettings = settings.getCommonSettings((Language)JavaLanguage.INSTANCE);
        if (statement2 instanceof PsiIfStatement) {
            return codeStyleSettings.IF_BRACE_FORCE;
        }
        if (statement2 instanceof PsiWhileStatement) {
            return codeStyleSettings.WHILE_BRACE_FORCE;
        }
        if (statement2 instanceof PsiForStatement) {
            return codeStyleSettings.FOR_BRACE_FORCE;
        }
        if (statement2 instanceof PsiDoWhileStatement) {
            return codeStyleSettings.DOWHILE_BRACE_FORCE;
        }
        return 0;
    }
}

