/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.wordSelection.BasicSelectioner;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiWhiteSpace;
import java.util.ArrayList;
import java.util.List;

public class CaseStatementsSelectioner
extends BasicSelectioner {
    @Override
    public boolean canSelect(PsiElement e) {
        return e.getParent() instanceof PsiCodeBlock && e.getParent().getParent() instanceof PsiSwitchStatement;
    }

    @Override
    public List<TextRange> select(PsiElement statement2, CharSequence editorText, int cursorOffset, Editor editor) {
        PsiElement sibling;
        ArrayList<TextRange> result2 = new ArrayList<TextRange>();
        PsiElement caseStart = statement2;
        PsiElement caseEnd = statement2;
        if (statement2 instanceof PsiSwitchLabelStatement || statement2 instanceof PsiSwitchStatement) {
            return result2;
        }
        for (sibling = statement2.getPrevSibling(); sibling != null && !(sibling instanceof PsiSwitchLabelStatement); sibling = sibling.getPrevSibling()) {
            if (sibling instanceof PsiWhiteSpace) continue;
            caseStart = sibling;
        }
        for (sibling = statement2.getNextSibling(); sibling != null && !(sibling instanceof PsiSwitchLabelStatement); sibling = sibling.getNextSibling()) {
            if (sibling instanceof PsiWhiteSpace || sibling instanceof PsiJavaToken) continue;
            caseEnd = sibling;
        }
        Document document2 = editor.getDocument();
        int startOffset = document2.getLineStartOffset(document2.getLineNumber(caseStart.getTextOffset()));
        int endOffset = document2.getLineEndOffset(document2.getLineNumber(caseEnd.getTextOffset() + caseEnd.getTextLength())) + 1;
        result2.add(new TextRange(startOffset, endOffset));
        return result2;
    }
}

