/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.GenerateGetterAndSetterHandler;
import com.intellij.codeInsight.generation.GenerateMembersHandlerBase;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.codeInsight.generation.GetterSetterPrototypeProvider;
import com.intellij.codeInsight.generation.PsiFieldMember;
import com.intellij.codeInsight.generation.PsiGenerationInfo;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PropertyMemberType;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateFieldOrPropertyHandler
extends GenerateMembersHandlerBase {
    private final String myAttributeName;
    private final PsiType myType;
    private final PropertyMemberType myMemberType;
    private final PsiAnnotation[] myAnnotations;

    public GenerateFieldOrPropertyHandler(String attributeName, PsiType type, PropertyMemberType memberType, PsiAnnotation ... annotations) {
        super("");
        this.myAttributeName = attributeName;
        this.myType = type;
        this.myMemberType = memberType;
        this.myAnnotations = annotations;
    }

    @Override
    protected ClassMember[] chooseOriginalMembers(PsiClass aClass, Project project2) {
        return ClassMember.EMPTY_ARRAY;
    }

    @Override
    @NotNull
    public List<? extends GenerationInfo> generateMemberPrototypes(PsiClass aClass, ClassMember[] members) throws IncorrectOperationException {
        List list;
        PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory();
        try {
            String fieldName = this.getFieldName(aClass);
            PsiField psiField = psiElementFactory.createField(fieldName, this.myType);
            GenerationInfo[] infos = new GenerateGetterAndSetterHandler().generateMemberPrototypes(aClass, new PsiFieldMember(psiField));
            if (this.myAnnotations.length > 0) {
                PsiModifierList modifierList;
                PsiField targetMember = null;
                if (this.myMemberType == PropertyMemberType.FIELD) {
                    targetMember = psiField;
                } else {
                    for (GenerationInfo info : infos) {
                        PsiMember member = info.getPsiMember();
                        if (!(member instanceof PsiMethod) || (this.myMemberType != PropertyMemberType.GETTER || !PropertyUtil.isSimplePropertyGetter((PsiMethod)((PsiMethod)member))) && (this.myMemberType != PropertyMemberType.SETTER || !PropertyUtil.isSimplePropertySetter((PsiMethod)((PsiMethod)member)))) continue;
                        targetMember = member;
                        break;
                    }
                    if (targetMember == null) {
                        targetMember = this.findExistingMember(aClass, this.myMemberType);
                    }
                }
                PsiModifierList psiModifierList = modifierList = targetMember != null ? targetMember.getModifierList() : null;
                if (modifierList != null) {
                    for (PsiAnnotation annotation : this.myAnnotations) {
                        PsiAnnotation existing = modifierList.findAnnotation(annotation.getQualifiedName());
                        if (existing != null) {
                            existing.replace((PsiElement)annotation);
                            continue;
                        }
                        modifierList.addAfter((PsiElement)annotation, null);
                    }
                }
            }
            list = ContainerUtil.concat(Collections.singletonList(new PsiGenerationInfo<PsiField>(psiField)), Arrays.asList(infos));
        }
        catch (IncorrectOperationException e) {
            assert (false) : e;
            List list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/GenerateFieldOrPropertyHandler", "generateMemberPrototypes"));
            }
            return list2;
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/GenerateFieldOrPropertyHandler", "generateMemberPrototypes"));
        }
        return list;
    }

    @Nullable
    public PsiMember findExistingMember(@NotNull PsiClass aClass, @NotNull PropertyMemberType memberType) {
        block7: {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/codeInsight/generation/GenerateFieldOrPropertyHandler", "findExistingMember"));
            }
            if (memberType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "memberType", "com/intellij/codeInsight/generation/GenerateFieldOrPropertyHandler", "findExistingMember"));
            }
            if (memberType == PropertyMemberType.FIELD) {
                return aClass.findFieldByName(this.getFieldName(aClass), false);
            }
            if (memberType == PropertyMemberType.GETTER) {
                try {
                    PsiMethod[] templates;
                    PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory();
                    PsiField field = psiElementFactory.createField(this.myAttributeName, this.myType);
                    for (PsiMethod template : templates = GetterSetterPrototypeProvider.generateGetterSetters(field, this.myMemberType == PropertyMemberType.GETTER)) {
                        PsiMethod existingMethod = aClass.findMethodBySignature(template, true);
                        if (existingMethod == null) continue;
                        return existingMethod;
                    }
                }
                catch (IncorrectOperationException e) {
                    if ($assertionsDisabled) break block7;
                    throw new AssertionError((Object)e);
                }
            }
        }
        return null;
    }

    private String getFieldName(PsiClass aClass) {
        return this.myMemberType == PropertyMemberType.FIELD ? this.myAttributeName : JavaCodeStyleManager.getInstance((Project)aClass.getProject()).propertyNameToVariableName(this.myAttributeName, VariableKind.FIELD);
    }

    @Override
    protected ClassMember[] getAllOriginalMembers(PsiClass aClass) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected GenerationInfo[] generateMemberPrototypes(PsiClass aClass, ClassMember originalMember) throws IncorrectOperationException {
        throw new UnsupportedOperationException();
    }
}

