/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.surroundWith;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.generation.surroundWith.JavaStatementsSurrounder;
import com.intellij.codeInsight.generation.surroundWith.SurroundWithUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;

class JavaWithTryFinallySurrounder
extends JavaStatementsSurrounder {
    private static final Logger LOG = Logger.getInstance((String)("#" + JavaWithTryFinallySurrounder.class.getName()));

    JavaWithTryFinallySurrounder() {
    }

    public String getTemplateDescription() {
        return CodeInsightBundle.message((String)"surround.with.try.finally.template", (Object[])new Object[0]);
    }

    @Override
    public TextRange surroundStatements(Project project2, Editor editor, PsiElement container, PsiElement[] statements) throws IncorrectOperationException {
        PsiManager manager = PsiManager.getInstance((Project)project2);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
        if ((statements = SurroundWithUtil.moveDeclarationsOut(container, statements, false)).length == 0) {
            return null;
        }
        String text = "try{\n}finally{\n\n}";
        PsiTryStatement tryStatement = (PsiTryStatement)factory.createStatementFromText(text, null);
        tryStatement = (PsiTryStatement)codeStyleManager.reformat((PsiElement)tryStatement);
        PsiCodeBlock tryBlock = (tryStatement = (PsiTryStatement)container.addAfter((PsiElement)tryStatement, statements[statements.length - 1])).getTryBlock();
        if (tryBlock == null) {
            return null;
        }
        SurroundWithUtil.indentCommentIfNecessary(tryBlock, statements);
        tryBlock.addRange(statements[0], statements[statements.length - 1]);
        container.deleteChildRange(statements[0], statements[statements.length - 1]);
        PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
        if (finallyBlock == null) {
            return null;
        }
        Document document2 = editor.getDocument();
        PsiDocumentManager.getInstance((Project)project2).doPostponedOperationsAndUnblockDocument(document2);
        TextRange finallyBlockRange = finallyBlock.getTextRange();
        int newLineOffset = finallyBlockRange.getStartOffset() + 2;
        editor.getCaretModel().moveToOffset(newLineOffset);
        editor.getSelectionModel().removeSelection();
        CodeStyleManager.getInstance((Project)project2).adjustLineIndent(document2, newLineOffset);
        PsiDocumentManager.getInstance((Project)project2).commitDocument(document2);
        return new TextRange(editor.getCaretModel().getOffset(), editor.getCaretModel().getOffset());
    }
}

