/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.containers.HashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HighlightManagerImpl
extends HighlightManager {
    private final Project myProject;
    private final Key<Map<RangeHighlighter, HighlightInfo>> HIGHLIGHT_INFO_MAP_KEY = Key.create((String)"HIGHLIGHT_INFO_MAP_KEY");

    public HighlightManagerImpl(Project project2) {
        this.myProject = project2;
        ActionManagerEx.getInstanceEx().addAnActionListener((AnActionListener)new MyAnActionListener(), (Disposable)this.myProject);
        DocumentAdapter documentListener = new DocumentAdapter(){

            public void documentChanged(DocumentEvent event) {
                Editor[] editors;
                Document document2 = event.getDocument();
                for (Editor editor : editors = EditorFactory.getInstance().getEditors(document2)) {
                    Map<RangeHighlighter, HighlightInfo> map = HighlightManagerImpl.this.getHighlightInfoMap(editor, false);
                    if (map == null) {
                        return;
                    }
                    ArrayList<RangeHighlighter> highlightersToRemove = new ArrayList<RangeHighlighter>();
                    for (RangeHighlighter highlighter : map.keySet()) {
                        HighlightInfo info = map.get(highlighter);
                        if (!info.editor.getDocument().equals(document2) || !BitUtil.isSet((int)info.flags, (int)4)) continue;
                        highlightersToRemove.add(highlighter);
                    }
                    for (RangeHighlighter highlighter : highlightersToRemove) {
                        HighlightManagerImpl.this.removeSegmentHighlighter(editor, highlighter);
                    }
                }
            }
        };
        EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)documentListener, (Disposable)this.myProject);
    }

    @Nullable
    public Map<RangeHighlighter, HighlightInfo> getHighlightInfoMap(@NotNull Editor editor, boolean toCreate) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/highlighting/HighlightManagerImpl", "getHighlightInfoMap"));
        }
        if (editor instanceof EditorWindow) {
            return this.getHighlightInfoMap(((EditorWindow)editor).getDelegate(), toCreate);
        }
        Map map = (Map)editor.getUserData(this.HIGHLIGHT_INFO_MAP_KEY);
        if (map == null && toCreate) {
            map = (Map)((UserDataHolderEx)editor).putUserDataIfAbsent(this.HIGHLIGHT_INFO_MAP_KEY, (Object)new HashMap());
        }
        return map;
    }

    @NotNull
    public RangeHighlighter[] getHighlighters(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/highlighting/HighlightManagerImpl", "getHighlighters"));
        }
        Map<RangeHighlighter, HighlightInfo> highlightersMap = this.getHighlightInfoMap(editor, false);
        if (highlightersMap == null) {
            if (RangeHighlighter.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/highlighting/HighlightManagerImpl", "getHighlighters"));
            }
            return RangeHighlighter.EMPTY_ARRAY;
        }
        HashSet<RangeHighlighter> set = new HashSet<RangeHighlighter>();
        for (Map.Entry<RangeHighlighter, HighlightInfo> entry : highlightersMap.entrySet()) {
            HighlightInfo info = entry.getValue();
            if (!info.editor.equals(editor)) continue;
            set.add(entry.getKey());
        }
        RangeHighlighter[] rangeHighlighterArray = set.toArray(new RangeHighlighter[set.size()]);
        if (rangeHighlighterArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/highlighting/HighlightManagerImpl", "getHighlighters"));
        }
        return rangeHighlighterArray;
    }

    private RangeHighlighter addSegmentHighlighter(@NotNull Editor editor, int startOffset, int endOffset, TextAttributes attributes, @HighlightManager.HideFlags int flags) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/highlighting/HighlightManagerImpl", "addSegmentHighlighter"));
        }
        RangeHighlighter highlighter = editor.getMarkupModel().addRangeHighlighter(startOffset, endOffset, 5999, attributes, HighlighterTargetArea.EXACT_RANGE);
        HighlightInfo info = new HighlightInfo(editor instanceof EditorWindow ? ((EditorWindow)editor).getDelegate() : editor, flags);
        Map<RangeHighlighter, HighlightInfo> map = this.getHighlightInfoMap(editor, true);
        map.put(highlighter, info);
        return highlighter;
    }

    public boolean removeSegmentHighlighter(@NotNull Editor editor, @NotNull RangeHighlighter highlighter) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/highlighting/HighlightManagerImpl", "removeSegmentHighlighter"));
        }
        if (highlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/codeInsight/highlighting/HighlightManagerImpl", "removeSegmentHighlighter"));
        }
        Map<RangeHighlighter, HighlightInfo> map = this.getHighlightInfoMap(editor, false);
        if (map == null) {
            return false;
        }
        HighlightInfo info = map.get(highlighter);
        if (info == null) {
            return false;
        }
        MarkupModel markupModel = info.editor.getMarkupModel();
        if (((MarkupModelEx)markupModel).containsHighlighter(highlighter)) {
            highlighter.dispose();
        }
        map.remove(highlighter);
        return true;
    }

    public void addOccurrenceHighlights(@NotNull Editor editor, @NotNull PsiReference[] occurrences, @NotNull TextAttributes attributes, boolean hideByTextChange, Collection<RangeHighlighter> outHighlighters) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/highlighting/HighlightManagerImpl", "addOccurrenceHighlights"));
        }
        if (occurrences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "occurrences", "com/intellij/codeInsight/highlighting/HighlightManagerImpl", "addOccurrenceHighlights"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/codeInsight/highlighting/HighlightManagerImpl", "addOccurrenceHighlights"));
        }
        if (occurrences.length == 0) {
            return;
        }
        int flags = 1;
        if (hideByTextChange) {
            flags |= 4;
        }
        Color scrollmarkColor = HighlightManagerImpl.getScrollMarkColor(attributes);
        int oldOffset = editor.getCaretModel().getOffset();
        int horizontalScrollOffset = editor.getScrollingModel().getHorizontalScrollOffset();
        int verticalScrollOffset = editor.getScrollingModel().getVerticalScrollOffset();
        for (PsiReference occurrence : occurrences) {
            Project project2;
            PsiElement element = occurrence.getElement();
            int startOffset = element.getTextRange().getStartOffset();
            int start = startOffset + occurrence.getRangeInElement().getStartOffset();
            int end = startOffset + occurrence.getRangeInElement().getEndOffset();
            PsiFile containingFile = element.getContainingFile();
            Editor textEditor = InjectedLanguageUtil.openEditorFor(containingFile, project2 = element.getProject());
            if (textEditor == null) continue;
            this.addOccurrenceHighlight(textEditor, start, end, attributes, flags, outHighlighters, scrollmarkColor);
        }
        editor.getCaretModel().moveToOffset(oldOffset);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getScrollingModel().scrollHorizontally(horizontalScrollOffset);
        editor.getScrollingModel().scrollVertically(verticalScrollOffset);
    }

    public void addElementsOccurrenceHighlights(@NotNull Editor editor, @NotNull PsiElement[] elements, @NotNull TextAttributes attributes, boolean hideByTextChange, Collection<RangeHighlighter> outHighlighters) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/highlighting/HighlightManagerImpl", "addElementsOccurrenceHighlights"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInsight/highlighting/HighlightManagerImpl", "addElementsOccurrenceHighlights"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/codeInsight/highlighting/HighlightManagerImpl", "addElementsOccurrenceHighlights"));
        }
        this.addOccurrenceHighlights(editor, elements, attributes, hideByTextChange, outHighlighters);
    }

    public void addOccurrenceHighlight(@NotNull Editor editor, int start, int end, TextAttributes attributes, int flags, Collection<RangeHighlighter> outHighlighters, Color scrollmarkColor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/highlighting/HighlightManagerImpl", "addOccurrenceHighlight"));
        }
        RangeHighlighter highlighter = this.addSegmentHighlighter(editor, start, end, attributes, flags);
        if (outHighlighters != null) {
            outHighlighters.add(highlighter);
        }
        if (scrollmarkColor != null) {
            highlighter.setErrorStripeMarkColor(scrollmarkColor);
        }
    }

    public void addRangeHighlight(@NotNull Editor editor, int startOffset, int endOffset, @NotNull TextAttributes attributes, boolean hideByTextChange, @Nullable Collection<RangeHighlighter> highlighters) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/highlighting/HighlightManagerImpl", "addRangeHighlight"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/codeInsight/highlighting/HighlightManagerImpl", "addRangeHighlight"));
        }
        this.addRangeHighlight(editor, startOffset, endOffset, attributes, hideByTextChange, false, highlighters);
    }

    public void addRangeHighlight(@NotNull Editor editor, int startOffset, int endOffset, @NotNull TextAttributes attributes, boolean hideByTextChange, boolean hideByAnyKey, @Nullable Collection<RangeHighlighter> highlighters) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/highlighting/HighlightManagerImpl", "addRangeHighlight"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/codeInsight/highlighting/HighlightManagerImpl", "addRangeHighlight"));
        }
        int flags = 1;
        if (hideByTextChange) {
            flags |= 4;
        }
        if (hideByAnyKey) {
            flags |= 2;
        }
        Color scrollmarkColor = HighlightManagerImpl.getScrollMarkColor(attributes);
        this.addOccurrenceHighlight(editor, startOffset, endOffset, attributes, flags, highlighters, scrollmarkColor);
    }

    public void addOccurrenceHighlights(@NotNull Editor editor, @NotNull PsiElement[] elements, @NotNull TextAttributes attributes, boolean hideByTextChange, Collection<RangeHighlighter> outHighlighters) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/highlighting/HighlightManagerImpl", "addOccurrenceHighlights"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInsight/highlighting/HighlightManagerImpl", "addOccurrenceHighlights"));
        }
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/codeInsight/highlighting/HighlightManagerImpl", "addOccurrenceHighlights"));
        }
        if (elements.length == 0) {
            return;
        }
        int flags = 1;
        if (hideByTextChange) {
            flags |= 4;
        }
        Color scrollmarkColor = HighlightManagerImpl.getScrollMarkColor(attributes);
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
        }
        for (PsiElement element : elements) {
            TextRange range = element.getTextRange();
            range = InjectedLanguageManager.getInstance((Project)this.myProject).injectedToHost(element, range);
            this.addOccurrenceHighlight(editor, HighlightManagerImpl.trimOffsetToDocumentSize(editor, range.getStartOffset()), HighlightManagerImpl.trimOffsetToDocumentSize(editor, range.getEndOffset()), attributes, flags, outHighlighters, scrollmarkColor);
        }
    }

    private static int trimOffsetToDocumentSize(@NotNull Editor editor, int offset) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/highlighting/HighlightManagerImpl", "trimOffsetToDocumentSize"));
        }
        if (offset < 0) {
            return 0;
        }
        int textLength = editor.getDocument().getTextLength();
        return offset < textLength ? offset : textLength;
    }

    @Nullable
    private static Color getScrollMarkColor(@NotNull TextAttributes attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/codeInsight/highlighting/HighlightManagerImpl", "getScrollMarkColor"));
        }
        if (attributes.getErrorStripeColor() != null) {
            return attributes.getErrorStripeColor();
        }
        if (attributes.getBackgroundColor() != null) {
            return attributes.getBackgroundColor().darker();
        }
        return null;
    }

    public boolean hideHighlights(@NotNull Editor editor, @HighlightManager.HideFlags int mask) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/highlighting/HighlightManagerImpl", "hideHighlights"));
        }
        Map<RangeHighlighter, HighlightInfo> map = this.getHighlightInfoMap(editor, false);
        if (map == null) {
            return false;
        }
        boolean done2 = false;
        ArrayList<RangeHighlighter> highlightersToRemove = new ArrayList<RangeHighlighter>();
        for (RangeHighlighter highlighter : map.keySet()) {
            HighlightInfo info = map.get(highlighter);
            if (!info.editor.equals(editor) || (info.flags & mask) == 0) continue;
            highlightersToRemove.add(highlighter);
            done2 = true;
        }
        for (RangeHighlighter highlighter : highlightersToRemove) {
            this.removeSegmentHighlighter(editor, highlighter);
        }
        return done2;
    }

    static class HighlightInfo {
        final Editor editor;
        @HighlightManager.HideFlags
        final int flags;

        public HighlightInfo(Editor editor, @HighlightManager.HideFlags int flags) {
            this.editor = editor;
            this.flags = flags;
        }
    }

    private class MyAnActionListener
    implements AnActionListener {
        private MyAnActionListener() {
        }

        public void beforeActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
            this.requestHideHighlights(dataContext);
        }

        public void afterActionPerformed(AnAction action, DataContext dataContext, AnActionEvent event) {
        }

        public void beforeEditorTyping(char c, DataContext dataContext) {
            this.requestHideHighlights(dataContext);
        }

        private void requestHideHighlights(DataContext dataContext) {
            Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
            if (editor == null) {
                return;
            }
            HighlightManagerImpl.this.hideHighlights(editor, 2);
        }
    }
}

