/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.unwrap;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.unwrap.JavaUnwrapper;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.List;

public class JavaAnonymousUnwrapper
extends JavaUnwrapper {
    public JavaAnonymousUnwrapper() {
        super(CodeInsightBundle.message((String)"unwrap.anonymous", (Object[])new Object[0]));
    }

    @Override
    public boolean isApplicableTo(PsiElement e) {
        return e instanceof PsiAnonymousClass && ((PsiAnonymousClass)e).getMethods().length <= 1;
    }

    @Override
    public PsiElement collectAffectedElements(PsiElement e, List<PsiElement> toExtract) {
        super.collectAffectedElements(e, toExtract);
        return JavaAnonymousUnwrapper.findElementToExtractFrom(e);
    }

    @Override
    protected void doUnwrap(PsiElement element, JavaUnwrapper.Context context) throws IncorrectOperationException {
        PsiExpression returnValue;
        PsiStatement[] statements;
        PsiCodeBlock body;
        PsiElement from = JavaAnonymousUnwrapper.findElementToExtractFrom(element);
        PsiCodeBlock methods = ((PsiAnonymousClass)element).getMethods();
        if (((PsiMethod[])methods).length == 1 && (body = methods[0].getBody()) != null && (statements = body.getStatements()).length == 1 && statements[0] instanceof PsiReturnStatement && JavaAnonymousUnwrapper.toAssignment(context, from, returnValue = ((PsiReturnStatement)statements[0]).getReturnValue())) {
            return;
        }
        for (PsiCodeBlock m : methods) {
            context.extractFromCodeBlock(m.getBody(), from);
        }
        PsiElement next = from.getNextSibling();
        if (next instanceof PsiJavaToken && ((PsiJavaToken)next).getTokenType() == JavaTokenType.SEMICOLON) {
            context.deleteExactly(from.getNextSibling());
        }
        context.deleteExactly(from);
    }

    public static boolean toAssignment(JavaUnwrapper.Context context, PsiElement from, PsiExpression returnValue) {
        PsiElement[] declaredElements;
        if (from instanceof PsiDeclarationStatement && (declaredElements = ((PsiDeclarationStatement)from).getDeclaredElements()).length == 1 && declaredElements[0] instanceof PsiVariable) {
            context.setInitializer((PsiVariable)declaredElements[0], returnValue);
            return true;
        }
        return false;
    }

    public static PsiElement findElementToExtractFrom(PsiElement el) {
        if (el.getParent() instanceof PsiNewExpression) {
            el = el.getParent();
        }
        el = JavaAnonymousUnwrapper.findTopmostParentOfType(el, PsiMethodCallExpression.class);
        el = JavaAnonymousUnwrapper.findTopmostParentOfType(el, PsiAssignmentExpression.class);
        el = JavaAnonymousUnwrapper.findTopmostParentOfType(el, PsiDeclarationStatement.class);
        PsiElement parent = el.getParent();
        while (parent instanceof PsiExpressionStatement || parent instanceof PsiReturnStatement) {
            el = parent;
            parent = el.getParent();
        }
        return el;
    }

    private static PsiElement findTopmostParentOfType(PsiElement el, Class<? extends PsiElement> clazz) {
        PsiElement temp;
        while ((temp = PsiTreeUtil.getParentOfType((PsiElement)el, clazz, (boolean)true, (Class[])new Class[]{PsiAnonymousClass.class})) != null && !(temp instanceof PsiFile)) {
            el = temp;
        }
        return el;
    }
}

