/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class DefaultAnnotationParamInspection
extends BaseJavaBatchLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/DefaultAnnotationParamInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitNameValuePair(PsiNameValuePair pair) {
                PsiAnnotationMemberValue value = pair.getValue();
                if (!(value instanceof PsiLiteralExpression)) {
                    return;
                }
                PsiReference reference = pair.getReference();
                if (reference == null) {
                    return;
                }
                PsiElement element = reference.resolve();
                if (!(element instanceof PsiAnnotationMethod)) {
                    return;
                }
                PsiAnnotationMemberValue defaultValue = ((PsiAnnotationMethod)element).getDefaultValue();
                if (defaultValue == null) {
                    return;
                }
                if (value.getText().equals(defaultValue.getText())) {
                    holder.registerProblem((PsiElement)value, "Redundant default parameter value assignment", ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new LocalQuickFix(){

                        @Nls
                        @NotNull
                        public String getName() {
                            if ("Remove redundant parameter" == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/DefaultAnnotationParamInspection$1$1", "getName"));
                            }
                            return "Remove redundant parameter";
                        }

                        @Nls
                        @NotNull
                        public String getFamilyName() {
                            String string = this.getName();
                            if (string == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/DefaultAnnotationParamInspection$1$1", "getFamilyName"));
                            }
                            return string;
                        }

                        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
                            if (project2 == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/DefaultAnnotationParamInspection$1$1", "applyFix"));
                            }
                            if (descriptor == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/DefaultAnnotationParamInspection$1$1", "applyFix"));
                            }
                            PsiElement parent = descriptor.getPsiElement().getParent();
                            FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{parent});
                            parent.delete();
                        }
                    }});
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/DefaultAnnotationParamInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }
}

