/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis.asm;

import com.intellij.codeInspection.bytecodeAnalysis.asm.ASMUtils;
import com.intellij.codeInspection.bytecodeAnalysis.asm.IParamsValue;
import java.util.List;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.FieldInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LdcInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;

class IParametersUsage
extends Interpreter<IParamsValue> {
    static final IParamsValue val1 = new IParamsValue(0, 1);
    static final IParamsValue val2 = new IParamsValue(0, 2);
    int leaking;
    int nullableLeaking;
    int called = -1;
    final int rangeStart;
    final int rangeEnd;
    final int arity;
    final int shift;

    IParametersUsage(MethodNode methodNode) {
        super(327680);
        this.arity = Type.getArgumentTypes((String)methodNode.desc).length;
        this.rangeStart = this.shift = (methodNode.access & 8) == 0 ? 2 : 1;
        this.rangeEnd = this.arity + this.shift;
    }

    public IParamsValue newValue(Type type) {
        if (type == null) {
            return val1;
        }
        ++this.called;
        if (type == Type.VOID_TYPE) {
            return null;
        }
        if (this.called < this.rangeEnd && this.rangeStart <= this.called && (ASMUtils.isReferenceType(type) || ASMUtils.isBooleanType(type))) {
            int n = this.called - this.shift;
            return type.getSize() == 1 ? new IParamsValue(1 << n, 1) : new IParamsValue(1 << n, 2);
        }
        return type.getSize() == 1 ? val1 : val2;
    }

    public IParamsValue newOperation(AbstractInsnNode insn) {
        int size;
        switch (insn.getOpcode()) {
            case 9: 
            case 10: 
            case 14: 
            case 15: {
                size = 2;
                break;
            }
            case 18: {
                Object cst = ((LdcInsnNode)insn).cst;
                size = cst instanceof Long || cst instanceof Double ? 2 : 1;
                break;
            }
            case 178: {
                size = ASMUtils.getSizeFast(((FieldInsnNode)insn).desc);
                break;
            }
            default: {
                size = 1;
            }
        }
        return size == 1 ? val1 : val2;
    }

    public IParamsValue copyOperation(AbstractInsnNode insn, IParamsValue value) {
        return value;
    }

    public IParamsValue unaryOperation(AbstractInsnNode insn, IParamsValue value) {
        int size;
        switch (insn.getOpcode()) {
            case 192: {
                return value;
            }
            case 117: 
            case 119: 
            case 133: 
            case 135: 
            case 138: 
            case 140: 
            case 141: 
            case 143: {
                size = 2;
                break;
            }
            case 180: {
                size = ASMUtils.getSizeFast(((FieldInsnNode)insn).desc);
                this.leaking |= value.params;
                break;
            }
            case 153: 
            case 154: 
            case 172: 
            case 176: 
            case 190: 
            case 193: 
            case 194: 
            case 198: 
            case 199: {
                size = 1;
                this.leaking |= value.params;
                break;
            }
            default: {
                size = 1;
            }
        }
        return size == 1 ? val1 : val2;
    }

    public IParamsValue binaryOperation(AbstractInsnNode insn, IParamsValue value1, IParamsValue value2) {
        int size;
        switch (insn.getOpcode()) {
            case 47: 
            case 49: {
                size = 2;
                this.leaking |= value1.params;
                break;
            }
            case 97: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 111: 
            case 113: 
            case 115: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: {
                size = 2;
                break;
            }
            case 46: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                this.leaking |= value1.params;
                size = 1;
                break;
            }
            case 181: {
                this.leaking |= value1.params;
                this.nullableLeaking |= value2.params;
                size = 1;
                break;
            }
            default: {
                size = 1;
            }
        }
        return size == 1 ? val1 : val2;
    }

    public IParamsValue ternaryOperation(AbstractInsnNode insn, IParamsValue value1, IParamsValue value2, IParamsValue value3) {
        switch (insn.getOpcode()) {
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 86: {
                this.leaking |= value1.params;
                break;
            }
            case 83: {
                this.leaking |= value1.params;
                this.nullableLeaking |= value3.params;
                break;
            }
        }
        return null;
    }

    public IParamsValue naryOperation(AbstractInsnNode insn, List<? extends IParamsValue> values) {
        int size;
        int opcode = insn.getOpcode();
        switch (opcode) {
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                for (IParamsValue iParamsValue : values) {
                    this.leaking |= iParamsValue.params;
                }
                break;
            }
        }
        if (opcode == 197) {
            size = 1;
        } else {
            String string = opcode == 186 ? ((InvokeDynamicInsnNode)insn).desc : ((MethodInsnNode)insn).desc;
            size = ASMUtils.getReturnSizeFast(string);
        }
        return size == 1 ? val1 : val2;
    }

    public void returnOperation(AbstractInsnNode insn, IParamsValue value, IParamsValue expected) {
    }

    public IParamsValue merge(IParamsValue v1, IParamsValue v2) {
        if (v1.equals(v2)) {
            return v1;
        }
        return new IParamsValue(v1.params | v2.params, Math.min(v1.size, v2.size));
    }
}

