/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.emptyMethod;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.BatchQuickFix;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalJavaBatchInspectionTool;
import com.intellij.codeInspection.GlobalJavaInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefJavaVisitor;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.codeInspection.util.SpecialAnnotationsUtil;
import com.intellij.codeInspection.util.SpecialAnnotationsUtilBase;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.searches.AllOverridingMethodsSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.safeDelete.SafeDeleteHandler;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.containers.BidirectionalMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmptyMethodInspection
extends GlobalJavaBatchInspectionTool {
    private static final String DISPLAY_NAME = InspectionsBundle.message((String)"inspection.empty.method.display.name", (Object[])new Object[0]);
    @NonNls
    private static final String SHORT_NAME = "EmptyMethod";
    private final BidirectionalMap<Boolean, QuickFix> myQuickFixes = new BidirectionalMap();
    public final JDOMExternalizableStringList EXCLUDE_ANNOS = new JDOMExternalizableStringList();
    public boolean commentsAreContent = false;
    @NonNls
    private static final String QUICK_FIX_NAME = InspectionsBundle.message((String)"inspection.empty.method.delete.quickfix", (Object[])new Object[0]);
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.emptyMethod.EmptyMethodInspection");

    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext, @NotNull ProblemDescriptionsProcessor processor2) {
        if (refEntity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/emptyMethod/EmptyMethodInspection", "checkElement"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/emptyMethod/EmptyMethodInspection", "checkElement"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/emptyMethod/EmptyMethodInspection", "checkElement"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "com/intellij/codeInspection/emptyMethod/EmptyMethodInspection", "checkElement"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInspection/emptyMethod/EmptyMethodInspection", "checkElement"));
        }
        if (!(refEntity instanceof RefMethod)) {
            return null;
        }
        RefMethod refMethod = (RefMethod)refEntity;
        if (!this.isBodyEmpty(refMethod)) {
            return null;
        }
        if (refMethod.isConstructor()) {
            return null;
        }
        if (refMethod.isSyntheticJSP()) {
            return null;
        }
        for (RefMethod refSuper : refMethod.getSuperMethods()) {
            if (this.checkElement((RefEntity)refSuper, scope, manager, globalContext, processor2) == null) continue;
            return null;
        }
        String message = null;
        boolean needToDeleteHierarchy = false;
        RefMethod refSuper = EmptyMethodInspection.findSuperWithBody(refMethod);
        if (refMethod.isOnlyCallsSuper() && !refMethod.isFinal()) {
            RefJavaUtil refUtil = RefJavaUtil.getInstance();
            if (refSuper != null && Comparing.strEqual((String)refMethod.getAccessModifier(), (String)refSuper.getAccessModifier())) {
                PsiModifierListOwner supMethod;
                PsiModifierList list;
                if (Comparing.strEqual((String)refSuper.getAccessModifier(), (String)"protected") && !Comparing.strEqual((String)refUtil.getPackageName((RefEntity)refSuper), (String)refUtil.getPackageName((RefEntity)refMethod))) {
                    return null;
                }
                PsiModifierListOwner modifierListOwner = refMethod.getElement();
                if (modifierListOwner != null && (list = modifierListOwner.getModifierList()) != null && (supMethod = refSuper.getElement()) != null) {
                    PsiModifierList superModifiedList = supMethod.getModifierList();
                    LOG.assertTrue(superModifiedList != null);
                    if (list.hasModifierProperty("synchronized") && !superModifiedList.hasModifierProperty("synchronized")) {
                        return null;
                    }
                }
            }
            if (refSuper == null || refUtil.compareAccess(refMethod.getAccessModifier(), refSuper.getAccessModifier()) <= 0) {
                message = InspectionsBundle.message((String)"inspection.empty.method.problem.descriptor", (Object[])new Object[0]);
            }
        } else if (refMethod.hasBody() && this.hasEmptySuperImplementation(refMethod)) {
            message = InspectionsBundle.message((String)"inspection.empty.method.problem.descriptor1", (Object[])new Object[0]);
        } else if (this.areAllImplementationsEmpty(refMethod) && refSuper == null) {
            if (refMethod.hasBody()) {
                if (refMethod.getDerivedMethods().isEmpty()) {
                    if (refMethod.getSuperMethods().isEmpty()) {
                        message = InspectionsBundle.message((String)"inspection.empty.method.problem.descriptor2", (Object[])new Object[0]);
                    }
                } else {
                    needToDeleteHierarchy = true;
                    message = InspectionsBundle.message((String)"inspection.empty.method.problem.descriptor3", (Object[])new Object[0]);
                }
            } else if (!refMethod.getDerivedMethods().isEmpty()) {
                needToDeleteHierarchy = true;
                message = InspectionsBundle.message((String)"inspection.empty.method.problem.descriptor4", (Object[])new Object[0]);
            }
        }
        if (message != null) {
            ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
            fixes.add(this.getFix(processor2, needToDeleteHierarchy));
            if (globalContext instanceof GlobalInspectionContextBase && ((GlobalInspectionContextBase)globalContext).getCurrentProfile().getSingleTool() == null) {
                SpecialAnnotationsUtilBase.createAddToSpecialAnnotationFixes(refMethod.getElement(), (Processor<String>)((Processor)qualifiedName -> {
                    fixes.add(SpecialAnnotationsUtilBase.createAddToSpecialAnnotationsListQuickFix(QuickFixBundle.message("fix.add.special.annotation.text", qualifiedName), QuickFixBundle.message("fix.add.special.annotation.family", new Object[0]), (List<String>)this.EXCLUDE_ANNOS, qualifiedName, (PsiElement)refMethod.getElement()));
                    return true;
                }));
            }
            ProblemDescriptor descriptor = manager.createProblemDescriptor(refMethod.getElement().getNavigationElement(), message, false, fixes.toArray(new LocalQuickFix[fixes.size()]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            return new ProblemDescriptor[]{descriptor};
        }
        return null;
    }

    private boolean isBodyEmpty(RefMethod refMethod) {
        if (!refMethod.isBodyEmpty()) {
            return false;
        }
        PsiModifierListOwner owner = refMethod.getElement();
        if (owner == null) {
            return false;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)owner, (Collection)this.EXCLUDE_ANNOS)) {
            return false;
        }
        for (Object extension : Extensions.getExtensions((String)"com.intellij.canBeEmpty")) {
            if (!((Condition)extension).value((Object)refMethod)) continue;
            return false;
        }
        return !this.commentsAreContent || PsiTreeUtil.findChildOfType((PsiElement)owner, PsiComment.class) == null;
    }

    @Nullable
    private static RefMethod findSuperWithBody(RefMethod refMethod) {
        for (RefMethod refSuper : refMethod.getSuperMethods()) {
            if (!refSuper.hasBody()) continue;
            return refSuper;
        }
        return null;
    }

    private boolean areAllImplementationsEmpty(RefMethod refMethod) {
        if (refMethod.hasBody() && !this.isBodyEmpty(refMethod)) {
            return false;
        }
        for (RefMethod refDerived : refMethod.getDerivedMethods()) {
            if (this.areAllImplementationsEmpty(refDerived)) continue;
            return false;
        }
        return true;
    }

    private boolean hasEmptySuperImplementation(RefMethod refMethod) {
        for (RefMethod refSuper : refMethod.getSuperMethods()) {
            if (!refSuper.hasBody() || !this.isBodyEmpty(refSuper)) continue;
            return true;
        }
        return false;
    }

    protected boolean queryExternalUsagesRequests(@NotNull RefManager manager, final @NotNull GlobalJavaInspectionContext context, final @NotNull ProblemDescriptionsProcessor descriptionsProcessor) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/emptyMethod/EmptyMethodInspection", "queryExternalUsagesRequests"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInspection/emptyMethod/EmptyMethodInspection", "queryExternalUsagesRequests"));
        }
        if (descriptionsProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptionsProcessor", "com/intellij/codeInspection/emptyMethod/EmptyMethodInspection", "queryExternalUsagesRequests"));
        }
        manager.iterate((RefVisitor)new RefJavaVisitor(){

            public void visitElement(@NotNull RefEntity refEntity) {
                if (refEntity == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/intellij/codeInspection/emptyMethod/EmptyMethodInspection$1", "visitElement"));
                }
                if (refEntity instanceof RefElement && descriptionsProcessor.getDescriptions(refEntity) != null) {
                    refEntity.accept((RefVisitor)new RefJavaVisitor(){

                        public void visitMethod(final @NotNull RefMethod refMethod) {
                            if (refMethod == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refMethod", "com/intellij/codeInspection/emptyMethod/EmptyMethodInspection$1$1", "visitMethod"));
                            }
                            context.enqueueDerivedMethodsProcessor(refMethod, new GlobalJavaInspectionContext.DerivedMethodsProcessor(){

                                public boolean process(PsiMethod derivedMethod) {
                                    PsiCodeBlock body = derivedMethod.getBody();
                                    if (body == null) {
                                        return true;
                                    }
                                    if (body.getStatements().length == 0) {
                                        return true;
                                    }
                                    if (RefJavaUtil.getInstance().isMethodOnlyCallsSuper(derivedMethod)) {
                                        return true;
                                    }
                                    descriptionsProcessor.ignoreElement((RefEntity)refMethod);
                                    return false;
                                }
                            });
                        }
                    });
                }
            }
        });
        return false;
    }

    @NotNull
    public String getDisplayName() {
        String string = DISPLAY_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/emptyMethod/EmptyMethodInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.DECLARATION_REDUNDANCY;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/emptyMethod/EmptyMethodInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/emptyMethod/EmptyMethodInspection", "getShortName"));
        }
        return SHORT_NAME;
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInspection/emptyMethod/EmptyMethodInspection", "writeSettings"));
        }
        if (!this.EXCLUDE_ANNOS.isEmpty() || this.commentsAreContent) {
            super.writeSettings(node);
        }
    }

    private LocalQuickFix getFix(ProblemDescriptionsProcessor processor2, boolean needToDeleteHierarchy) {
        Object fix = (QuickFix)this.myQuickFixes.get((Object)needToDeleteHierarchy);
        if (fix == null) {
            fix = new DeleteMethodQuickFix(processor2, needToDeleteHierarchy);
            this.myQuickFixes.put((Object)needToDeleteHierarchy, fix);
            return (LocalQuickFix)fix;
        }
        return (LocalQuickFix)fix;
    }

    public String getHint(@NotNull QuickFix fix) {
        if (fix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fix", "com/intellij/codeInspection/emptyMethod/EmptyMethodInspection", "getHint"));
        }
        List list = this.myQuickFixes.getKeysByValue((Object)fix);
        if (list != null) {
            LOG.assertTrue(list.size() == 1);
            return String.valueOf(list.get(0));
        }
        return null;
    }

    @Nullable
    public LocalQuickFix getQuickFix(String hint) {
        return new DeleteMethodIntention(hint);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        JPanel listPanel = SpecialAnnotationsUtil.createSpecialAnnotationsListControl((List<String>)this.EXCLUDE_ANNOS, InspectionsBundle.message((String)"special.annotations.annotations.list", (Object[])new Object[0]));
        JPanel panel = new JPanel(new BorderLayout(2, 2));
        panel.add((Component)new SingleCheckboxOptionsPanel("Comments and javadoc count as content", (InspectionProfileEntry)this, "commentsAreContent"), "North");
        panel.add((Component)listPanel, "Center");
        return panel;
    }

    private class DeleteMethodQuickFix
    implements LocalQuickFix,
    BatchQuickFix<CommonProblemDescriptor> {
        private final ProblemDescriptionsProcessor myProcessor;
        private final boolean myNeedToDeleteHierarchy;

        public DeleteMethodQuickFix(ProblemDescriptionsProcessor processor2, boolean needToDeleteHierarchy) {
            this.myProcessor = processor2;
            this.myNeedToDeleteHierarchy = needToDeleteHierarchy;
        }

        @NotNull
        public String getName() {
            String string = QUICK_FIX_NAME;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/emptyMethod/EmptyMethodInspection$DeleteMethodQuickFix", "getName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/emptyMethod/EmptyMethodInspection$DeleteMethodQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/emptyMethod/EmptyMethodInspection$DeleteMethodQuickFix", "applyFix"));
            }
            this.applyFix(project2, (CommonProblemDescriptor[])new ProblemDescriptor[]{descriptor}, new ArrayList<PsiElement>(), null);
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/emptyMethod/EmptyMethodInspection$DeleteMethodQuickFix", "getFamilyName"));
            }
            return string;
        }

        private void deleteHierarchy(RefMethod refMethod, List<PsiElement> result2) {
            RefMethod[] refMethods;
            Collection derivedMethods = refMethod.getDerivedMethods();
            for (RefMethod refDerived : refMethods = derivedMethods.toArray(new RefMethod[derivedMethods.size()])) {
                this.deleteMethod(refDerived, result2);
            }
            this.deleteMethod(refMethod, result2);
        }

        private void deleteMethod(RefMethod refMethod, List<PsiElement> result2) {
            PsiModifierListOwner psiElement = refMethod.getElement();
            if (psiElement == null) {
                return;
            }
            if (!result2.contains(psiElement)) {
                result2.add((PsiElement)psiElement);
            }
        }

        public void applyFix(@NotNull Project project2, @NotNull CommonProblemDescriptor[] descriptors, @NotNull List<PsiElement> psiElementsToIgnore, @Nullable Runnable refreshViews) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/emptyMethod/EmptyMethodInspection$DeleteMethodQuickFix", "applyFix"));
            }
            if (descriptors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/codeInspection/emptyMethod/EmptyMethodInspection$DeleteMethodQuickFix", "applyFix"));
            }
            if (psiElementsToIgnore == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElementsToIgnore", "com/intellij/codeInspection/emptyMethod/EmptyMethodInspection$DeleteMethodQuickFix", "applyFix"));
            }
            for (CommonProblemDescriptor descriptor : descriptors) {
                RefElement refElement = (RefElement)this.myProcessor.getElement(descriptor);
                if (!refElement.isValid() || !(refElement instanceof RefMethod)) continue;
                RefMethod refMethod = (RefMethod)refElement;
                if (this.myNeedToDeleteHierarchy) {
                    this.deleteHierarchy(refMethod, psiElementsToIgnore);
                    continue;
                }
                this.deleteMethod(refMethod, psiElementsToIgnore);
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/emptyMethod/EmptyMethodInspection$DeleteMethodQuickFix", "lambda$applyFix$0"));
                }
                if (psiElementsToIgnore == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElementsToIgnore", "com/intellij/codeInspection/emptyMethod/EmptyMethodInspection$DeleteMethodQuickFix", "lambda$applyFix$0"));
                }
                SafeDeleteHandler.invoke(project2, PsiUtilCore.toPsiElementArray((Collection)psiElementsToIgnore), false, refreshViews);
            }, project2.getDisposed());
        }
    }

    private class DeleteMethodIntention
    implements LocalQuickFix {
        private final String myHint;

        public DeleteMethodIntention(String hint) {
            this.myHint = hint;
        }

        @NotNull
        public String getName() {
            String string = QUICK_FIX_NAME;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/emptyMethod/EmptyMethodInspection$DeleteMethodIntention", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = QUICK_FIX_NAME;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/emptyMethod/EmptyMethodInspection$DeleteMethodIntention", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/emptyMethod/EmptyMethodInspection$DeleteMethodIntention", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/emptyMethod/EmptyMethodInspection$DeleteMethodIntention", "applyFix"));
            }
            PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiMethod.class, (boolean)false);
            if (psiMethod != null) {
                ArrayList<PsiMethod> psiElements = new ArrayList<PsiMethod>();
                psiElements.add(psiMethod);
                if (Boolean.valueOf(this.myHint).booleanValue()) {
                    Query query = AllOverridingMethodsSearch.search((PsiClass)psiMethod.getContainingClass());
                    query.forEach(pair -> {
                        if (pair.first == psiMethod) {
                            psiElements.add((PsiMethod)pair.second);
                        }
                        return true;
                    });
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (project2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/emptyMethod/EmptyMethodInspection$DeleteMethodIntention", "lambda$applyFix$1"));
                    }
                    SafeDeleteHandler.invoke(project2, PsiUtilCore.toPsiElementArray((Collection)psiElements), false);
                }, project2.getDisposed());
            }
        }
    }
}

