/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.debugger.jdi.JdiTimer;
import org.jetbrains.annotations.NotNull;

public abstract class JdiProxy {
    @NotNull
    protected final JdiTimer myTimer;
    private int myTimeStamp;

    public JdiProxy(@NotNull JdiTimer timer) {
        if (timer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timer", "com/intellij/debugger/jdi/JdiProxy", "<init>"));
        }
        this.myTimeStamp = 0;
        this.myTimer = timer;
        this.myTimeStamp = this.myTimer.getCurrentTime();
    }

    protected void checkValid() {
        if (!this.isValid()) {
            this.myTimeStamp = this.myTimer.getCurrentTime();
            this.clearCaches();
        }
    }

    public boolean isValid() {
        return this.myTimeStamp == this.myTimer.getCurrentTime();
    }

    protected abstract void clearCaches();
}

