/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.render.ChildrenRenderer;
import com.intellij.debugger.ui.tree.render.CompoundNodeRenderer;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.ReferenceRenderer;
import com.intellij.debugger.ui.tree.render.ValueLabelRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.search.GlobalSearchScope;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import org.jetbrains.annotations.NotNull;

public class CompoundReferenceRenderer
extends CompoundNodeRenderer {
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.tree.render.CompoundReferenceRenderer");

    public CompoundReferenceRenderer(NodeRendererSettings rendererSettings, String name, ValueLabelRenderer labelRenderer, ChildrenRenderer childrenRenderer) {
        super(rendererSettings, name, labelRenderer, childrenRenderer);
        this.myProperties.setClassName("java.lang.Object");
        LOG.assertTrue(labelRenderer == null || labelRenderer instanceof ReferenceRenderer);
        LOG.assertTrue(childrenRenderer == null || childrenRenderer instanceof ReferenceRenderer);
    }

    @Override
    public void setLabelRenderer(ValueLabelRenderer labelRenderer) {
        ValueLabelRenderer prevRenderer = this.getLabelRenderer();
        super.setLabelRenderer(this.myRendererSettings.isBase(labelRenderer) ? null : labelRenderer);
        ValueLabelRenderer currentRenderer = this.getLabelRenderer();
        if (prevRenderer != currentRenderer && currentRenderer instanceof ReferenceRenderer) {
            ((ReferenceRenderer)((Object)currentRenderer)).setClassName(this.getClassName());
        }
    }

    @Override
    public void setChildrenRenderer(ChildrenRenderer childrenRenderer) {
        ChildrenRenderer prevRenderer = this.getChildrenRenderer();
        super.setChildrenRenderer(this.myRendererSettings.isBase(childrenRenderer) ? null : childrenRenderer);
        ChildrenRenderer currentRenderer = this.getChildrenRenderer();
        if (prevRenderer != currentRenderer && currentRenderer instanceof ReferenceRenderer) {
            ((ReferenceRenderer)((Object)currentRenderer)).setClassName(this.getClassName());
        }
    }

    @Override
    public ChildrenRenderer getChildrenRenderer() {
        ChildrenRenderer childrenRenderer = super.getChildrenRenderer();
        return childrenRenderer != null ? childrenRenderer : this.getDefaultRenderer();
    }

    private NodeRenderer getDefaultRenderer() {
        return this.getClassName().endsWith("]") ? this.myRendererSettings.getArrayRenderer() : this.myRendererSettings.getClassRenderer();
    }

    @Override
    public ValueLabelRenderer getLabelRenderer() {
        ValueLabelRenderer labelRenderer = super.getLabelRenderer();
        return labelRenderer != null ? labelRenderer : this.getDefaultRenderer();
    }

    private ChildrenRenderer getRawChildrenRenderer() {
        NodeRenderer classRenderer = this.getDefaultRenderer();
        ChildrenRenderer originalRenderer = super.getChildrenRenderer();
        return originalRenderer == classRenderer ? null : originalRenderer;
    }

    private ValueLabelRenderer getRawLabelRenderer() {
        NodeRenderer classRenderer = this.getDefaultRenderer();
        ValueLabelRenderer originalRenderer = super.getLabelRenderer();
        return originalRenderer == classRenderer ? null : originalRenderer;
    }

    @Override
    public boolean isApplicable(Type type) {
        if (type == null || !(type instanceof ReferenceType) || !DebuggerUtils.instanceOf((Type)type, (String)this.getClassName())) {
            return false;
        }
        return super.isApplicable(type);
    }

    public void setClassName(@NotNull String name) {
        ChildrenRenderer originalChildrenRenderer;
        ValueLabelRenderer originalLabelRenderer;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/debugger/ui/tree/render/CompoundReferenceRenderer", "setClassName"));
        }
        this.myProperties.setClassName(name);
        if (this.getRawLabelRenderer() != null && (originalLabelRenderer = super.getLabelRenderer()) instanceof ReferenceRenderer) {
            ((ReferenceRenderer)((Object)originalLabelRenderer)).setClassName(name);
        }
        if (this.getRawChildrenRenderer() != null && (originalChildrenRenderer = super.getChildrenRenderer()) instanceof ReferenceRenderer) {
            ((ReferenceRenderer)((Object)originalChildrenRenderer)).setClassName(name);
        }
    }

    @NotNull
    public String getClassName() {
        String string = this.myProperties.getClassName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/tree/render/CompoundReferenceRenderer", "getClassName"));
        }
        return string;
    }

    protected final PsiElement getContext(Project project2, DebuggerContext context) {
        DebugProcess process2 = context.getDebugProcess();
        GlobalSearchScope scope = process2 != null ? process2.getSearchScope() : GlobalSearchScope.allScope((Project)project2);
        return DebuggerUtils.findClass((String)this.getClassName(), (Project)project2, (GlobalSearchScope)scope);
    }

    protected final PsiElement getChildValueExpression(String text, DebuggerTreeNode node, DebuggerContext context) {
        Project project2 = node.getProject();
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
        return elementFactory.createExpressionFromText(text, this.getContext(project2, context));
    }
}

