/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.actions;

import com.intellij.diff.actions.DocumentsSynchronizer;
import com.intellij.diff.contents.DiffContentBase;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LineSeparator;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DocumentFragmentContent
extends DiffContentBase
implements DocumentContent {
    @NotNull
    private final DocumentContent myOriginal;
    @NotNull
    private final MyDocumentsSynchronizer mySynchonizer;
    private int myAssignments;

    public DocumentFragmentContent(@Nullable Project project2, @NotNull DocumentContent original, @NotNull TextRange range) {
        if (original == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "original", "com/intellij/diff/actions/DocumentFragmentContent", "<init>"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/diff/actions/DocumentFragmentContent", "<init>"));
        }
        this.myAssignments = 0;
        this.myOriginal = original;
        Document document1 = this.myOriginal.getDocument();
        Document document2 = EditorFactory.getInstance().createDocument((CharSequence)"");
        document2.putUserData(UndoManager.ORIGINAL_DOCUMENT, (Object)document1);
        RangeMarker rangeMarker = document1.createRangeMarker(range.getStartOffset(), range.getEndOffset(), true);
        rangeMarker.setGreedyToLeft(true);
        rangeMarker.setGreedyToRight(true);
        this.mySynchonizer = new MyDocumentsSynchronizer(project2, rangeMarker, document1, document2);
    }

    @NotNull
    public Document getDocument() {
        Document document2 = this.mySynchonizer.getDocument2();
        if (document2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/actions/DocumentFragmentContent", "getDocument"));
        }
        return document2;
    }

    @Nullable
    public VirtualFile getHighlightFile() {
        return this.myOriginal.getHighlightFile();
    }

    @Nullable
    public OpenFileDescriptor getOpenFileDescriptor(int offset) {
        return this.myOriginal.getOpenFileDescriptor(offset + this.mySynchonizer.getStartOffset());
    }

    @Nullable
    public LineSeparator getLineSeparator() {
        return null;
    }

    @Nullable
    public Charset getCharset() {
        return null;
    }

    @Nullable
    public FileType getContentType() {
        return this.myOriginal.getContentType();
    }

    @Nullable
    public OpenFileDescriptor getOpenFileDescriptor() {
        return this.getOpenFileDescriptor(0);
    }

    public void onAssigned(boolean isAssigned) {
        if (isAssigned) {
            if (this.myAssignments == 0) {
                this.mySynchonizer.startListen();
            }
            ++this.myAssignments;
        } else {
            --this.myAssignments;
            if (this.myAssignments == 0) {
                this.mySynchonizer.stopListen();
            }
        }
        assert (this.myAssignments >= 0);
    }

    private static class MyDocumentsSynchronizer
    extends DocumentsSynchronizer {
        @NotNull
        private final RangeMarker myRangeMarker;

        public MyDocumentsSynchronizer(@Nullable Project project2, @NotNull RangeMarker range, @NotNull Document document1, @NotNull Document document2) {
            if (range == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/diff/actions/DocumentFragmentContent$MyDocumentsSynchronizer", "<init>"));
            }
            if (document1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document1", "com/intellij/diff/actions/DocumentFragmentContent$MyDocumentsSynchronizer", "<init>"));
            }
            if (document2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document2", "com/intellij/diff/actions/DocumentFragmentContent$MyDocumentsSynchronizer", "<init>"));
            }
            super(project2, document1, document2);
            this.myRangeMarker = range;
        }

        public int getStartOffset() {
            return this.myRangeMarker.getStartOffset();
        }

        public int getEndOffset() {
            return this.myRangeMarker.getEndOffset();
        }

        @Override
        protected void onDocumentChanged1(@NotNull DocumentEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/diff/actions/DocumentFragmentContent$MyDocumentsSynchronizer", "onDocumentChanged1"));
            }
            if (!this.myRangeMarker.isValid()) {
                this.myDocument2.setReadOnly(false);
                this.replaceString(this.myDocument2, 0, this.myDocument2.getTextLength(), "Invalid selection range");
                this.myDocument2.setReadOnly(true);
                return;
            }
            CharSequence newText = this.myDocument1.getCharsSequence().subSequence(this.myRangeMarker.getStartOffset(), this.myRangeMarker.getEndOffset());
            this.replaceString(this.myDocument2, 0, this.myDocument2.getTextLength(), newText);
        }

        @Override
        protected void onDocumentChanged2(@NotNull DocumentEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/diff/actions/DocumentFragmentContent$MyDocumentsSynchronizer", "onDocumentChanged2"));
            }
            if (!this.myRangeMarker.isValid()) {
                return;
            }
            if (!this.myDocument1.isWritable()) {
                return;
            }
            CharSequence newText = event.getNewFragment();
            int originalOffset = event.getOffset() + this.myRangeMarker.getStartOffset();
            int originalEnd = originalOffset + event.getOldLength();
            this.replaceString(this.myDocument1, originalOffset, originalEnd, newText);
        }

        @Override
        public void startListen() {
            if (this.myRangeMarker.isValid()) {
                this.myDocument2.setReadOnly(false);
                CharSequence nexText = this.myDocument1.getCharsSequence().subSequence(this.myRangeMarker.getStartOffset(), this.myRangeMarker.getEndOffset());
                this.replaceString(this.myDocument2, 0, this.myDocument2.getTextLength(), nexText);
                this.myDocument2.setReadOnly(!this.myDocument1.isWritable());
            } else {
                this.myDocument2.setReadOnly(false);
                this.replaceString(this.myDocument2, 0, this.myDocument2.getTextLength(), "Invalid selection range");
                this.myDocument2.setReadOnly(true);
            }
            super.startListen();
        }
    }
}

