/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.comparison;

import com.intellij.diff.comparison.ByChar;
import com.intellij.diff.comparison.ByLine;
import com.intellij.diff.comparison.ByWord;
import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.ComparisonUtil;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.fragments.DiffFragmentImpl;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.fragments.LineFragmentImpl;
import com.intellij.diff.util.Range;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.diff.FilesTooBigForDiffException;
import com.intellij.util.text.CharSequenceSubSequence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ComparisonManagerImpl
extends ComparisonManager {
    public static final Logger LOG = Logger.getInstance(ComparisonManagerImpl.class);

    @NotNull
    public List<LineFragment> compareLines(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLines"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLines"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLines"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLines"));
        }
        if (policy == ComparisonPolicy.IGNORE_WHITESPACES) {
            List<LineFragment> list = ByLine.compare(text1, text2, policy, indicator);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLines"));
            }
            return list;
        }
        List<LineFragment> list = ByLine.compareTwoStep(text1, text2, policy, indicator);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLines"));
        }
        return list;
    }

    @NotNull
    public List<LineFragment> compareLinesInner(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLinesInner"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLinesInner"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLinesInner"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLinesInner"));
        }
        List<LineFragment> lineFragments = this.compareLines(text1, text2, policy, indicator);
        ArrayList<LineFragment> fineFragments = new ArrayList<LineFragment>(lineFragments.size());
        int tooBigChunksCount = 0;
        for (LineFragment fragment : lineFragments) {
            CharSequence subSequence1 = text1.subSequence(fragment.getStartOffset1(), fragment.getEndOffset1());
            CharSequence subSequence2 = text2.subSequence(fragment.getStartOffset2(), fragment.getEndOffset2());
            if (fragment.getStartLine1() == fragment.getEndLine1() || fragment.getStartLine2() == fragment.getEndLine2()) {
                if (this.isEquals(subSequence1, subSequence2, policy)) {
                    fineFragments.add((LineFragment)new LineFragmentImpl(fragment, Collections.emptyList()));
                    continue;
                }
                fineFragments.add((LineFragment)new LineFragmentImpl(fragment, null));
                continue;
            }
            if (tooBigChunksCount >= FilesTooBigForDiffException.MAX_BAD_LINES) {
                fineFragments.add((LineFragment)new LineFragmentImpl(fragment, null));
                continue;
            }
            try {
                List<ByWord.LineBlock> lineBlocks = ByWord.compareAndSplit(subSequence1, subSequence2, policy, indicator);
                assert (lineBlocks.size() != 0);
                int startOffset1 = fragment.getStartOffset1();
                int startOffset2 = fragment.getStartOffset2();
                int currentStartLine1 = fragment.getStartLine1();
                int currentStartLine2 = fragment.getStartLine2();
                for (int i = 0; i < lineBlocks.size(); ++i) {
                    ByWord.LineBlock block = lineBlocks.get(i);
                    Range offsets = block.offsets;
                    int currentEndLine1 = i != lineBlocks.size() - 1 ? currentStartLine1 + block.newlines1 : fragment.getEndLine1();
                    int currentEndLine2 = i != lineBlocks.size() - 1 ? currentStartLine2 + block.newlines2 : fragment.getEndLine2();
                    fineFragments.add((LineFragment)new LineFragmentImpl(currentStartLine1, currentEndLine1, currentStartLine2, currentEndLine2, offsets.start1 + startOffset1, offsets.end1 + startOffset1, offsets.start2 + startOffset2, offsets.end2 + startOffset2, block.fragments));
                    currentStartLine1 = currentEndLine1;
                    currentStartLine2 = currentEndLine2;
                }
            }
            catch (DiffTooBigException e) {
                fineFragments.add((LineFragment)new LineFragmentImpl(fragment, null));
                ++tooBigChunksCount;
            }
        }
        ArrayList<LineFragment> arrayList = fineFragments;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLinesInner"));
        }
        return arrayList;
    }

    @Deprecated
    @NotNull
    public List<LineFragment> compareLinesInner(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull List<LineFragment> lineFragments, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLinesInner"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLinesInner"));
        }
        if (lineFragments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineFragments", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLinesInner"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLinesInner"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLinesInner"));
        }
        List<LineFragment> list = this.compareLinesInner(text1, text2, policy, indicator);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareLinesInner"));
        }
        return list;
    }

    @NotNull
    public List<DiffFragment> compareWords(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareWords"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareWords"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareWords"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareWords"));
        }
        List<DiffFragment> list = ByWord.compare(text1, text2, policy, indicator);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareWords"));
        }
        return list;
    }

    @NotNull
    public List<DiffFragment> compareChars(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, @NotNull ProgressIndicator indicator) throws DiffTooBigException {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareChars"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareChars"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareChars"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareChars"));
        }
        if (policy == ComparisonPolicy.IGNORE_WHITESPACES) {
            List<DiffFragment> list = DiffIterableUtil.convertIntoFragments(ByChar.compareIgnoreWhitespaces(text1, text2, indicator));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareChars"));
            }
            return list;
        }
        if (policy == ComparisonPolicy.DEFAULT) {
            List<DiffFragment> list = DiffIterableUtil.convertIntoFragments(ByChar.compareTwoStep(text1, text2, indicator));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareChars"));
            }
            return list;
        }
        LOG.warn(policy.toString() + " is not supported by ByChar comparison");
        List<DiffFragment> list = DiffIterableUtil.convertIntoFragments(ByChar.compareTwoStep(text1, text2, indicator));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "compareChars"));
        }
        return list;
    }

    public boolean isEquals(@NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy) {
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ComparisonManagerImpl", "isEquals"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ComparisonManagerImpl", "isEquals"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ComparisonManagerImpl", "isEquals"));
        }
        return ComparisonUtil.isEquals(text1, text2, policy);
    }

    @NotNull
    public List<LineFragment> squash(@NotNull List<LineFragment> oldFragments) {
        if (oldFragments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldFragments", "com/intellij/diff/comparison/ComparisonManagerImpl", "squash"));
        }
        if (oldFragments.isEmpty()) {
            List<LineFragment> list = oldFragments;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "squash"));
            }
            return list;
        }
        ArrayList<LineFragment> newFragments = new ArrayList<LineFragment>();
        ComparisonManagerImpl.processAdjoining(oldFragments, (Consumer<List<LineFragment>>)((Consumer)fragments -> newFragments.add(ComparisonManagerImpl.doSquash(fragments))));
        ArrayList<LineFragment> arrayList = newFragments;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "squash"));
        }
        return arrayList;
    }

    @NotNull
    public List<LineFragment> processBlocks(@NotNull List<LineFragment> oldFragments, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, boolean squash, boolean trim) {
        if (oldFragments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldFragments", "com/intellij/diff/comparison/ComparisonManagerImpl", "processBlocks"));
        }
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ComparisonManagerImpl", "processBlocks"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ComparisonManagerImpl", "processBlocks"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ComparisonManagerImpl", "processBlocks"));
        }
        if (!squash && !trim) {
            List<LineFragment> list = oldFragments;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "processBlocks"));
            }
            return list;
        }
        if (oldFragments.isEmpty()) {
            List<LineFragment> list = oldFragments;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "processBlocks"));
            }
            return list;
        }
        ArrayList<LineFragment> newFragments = new ArrayList<LineFragment>();
        ComparisonManagerImpl.processAdjoining(oldFragments, (Consumer<List<LineFragment>>)((Consumer)fragments -> {
            if (text1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ComparisonManagerImpl", "lambda$processBlocks$1"));
            }
            if (text2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ComparisonManagerImpl", "lambda$processBlocks$1"));
            }
            if (policy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ComparisonManagerImpl", "lambda$processBlocks$1"));
            }
            newFragments.addAll(ComparisonManagerImpl.processAdjoining(fragments, text1, text2, policy, squash, trim));
        }));
        ArrayList<LineFragment> arrayList = newFragments;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "processBlocks"));
        }
        return arrayList;
    }

    private static void processAdjoining(@NotNull List<LineFragment> oldFragments, @NotNull Consumer<List<LineFragment>> consumer) {
        if (oldFragments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldFragments", "com/intellij/diff/comparison/ComparisonManagerImpl", "processAdjoining"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/diff/comparison/ComparisonManagerImpl", "processAdjoining"));
        }
        int startIndex = 0;
        for (int i = 1; i < oldFragments.size(); ++i) {
            if (ComparisonManagerImpl.isAdjoining(oldFragments.get(i - 1), oldFragments.get(i))) continue;
            consumer.consume(oldFragments.subList(startIndex, i));
            startIndex = i;
        }
        if (startIndex < oldFragments.size()) {
            consumer.consume(oldFragments.subList(startIndex, oldFragments.size()));
        }
    }

    @NotNull
    private static List<LineFragment> processAdjoining(@NotNull List<LineFragment> fragments, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull ComparisonPolicy policy, boolean squash, boolean trim) {
        int start;
        if (fragments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragments", "com/intellij/diff/comparison/ComparisonManagerImpl", "processAdjoining"));
        }
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/comparison/ComparisonManagerImpl", "processAdjoining"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/comparison/ComparisonManagerImpl", "processAdjoining"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/comparison/ComparisonManagerImpl", "processAdjoining"));
        }
        int end = fragments.size();
        if (trim && policy == ComparisonPolicy.IGNORE_WHITESPACES) {
            CharSequenceSubSequence sequence2;
            CharSequenceSubSequence sequence1;
            LineFragment fragment;
            for (start = 0; start < end; ++start) {
                fragment = fragments.get(start);
                sequence1 = new CharSequenceSubSequence(text1, fragment.getStartOffset1(), fragment.getEndOffset1());
                sequence2 = new CharSequenceSubSequence(text2, fragment.getStartOffset2(), fragment.getEndOffset2());
                if ((fragment.getInnerFragments() == null || !fragment.getInnerFragments().isEmpty()) && !StringUtil.equalsIgnoreWhitespaces((CharSequence)sequence1, (CharSequence)sequence2)) break;
            }
            while (start < end) {
                fragment = fragments.get(end - 1);
                sequence1 = new CharSequenceSubSequence(text1, fragment.getStartOffset1(), fragment.getEndOffset1());
                sequence2 = new CharSequenceSubSequence(text2, fragment.getStartOffset2(), fragment.getEndOffset2());
                if ((fragment.getInnerFragments() == null || !fragment.getInnerFragments().isEmpty()) && !StringUtil.equalsIgnoreWhitespaces((CharSequence)sequence1, (CharSequence)sequence2)) break;
                --end;
            }
        }
        if (start == end) {
            List<LineFragment> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "processAdjoining"));
            }
            return list;
        }
        if (squash) {
            List<LineFragment> list = Collections.singletonList(ComparisonManagerImpl.doSquash(fragments.subList(start, end)));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "processAdjoining"));
            }
            return list;
        }
        List<LineFragment> list = fragments.subList(start, end);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "processAdjoining"));
        }
        return list;
    }

    @NotNull
    private static LineFragment doSquash(@NotNull List<LineFragment> oldFragments) {
        if (oldFragments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldFragments", "com/intellij/diff/comparison/ComparisonManagerImpl", "doSquash"));
        }
        assert (!oldFragments.isEmpty());
        if (oldFragments.size() == 1) {
            LineFragment lineFragment = oldFragments.get(0);
            if (lineFragment == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "doSquash"));
            }
            return lineFragment;
        }
        LineFragment firstFragment = oldFragments.get(0);
        LineFragment lastFragment = oldFragments.get(oldFragments.size() - 1);
        ArrayList<DiffFragmentImpl> newInnerFragments = new ArrayList<DiffFragmentImpl>();
        for (LineFragment fragment : oldFragments) {
            for (DiffFragment diffFragment : ComparisonManagerImpl.extractInnerFragments(fragment)) {
                int shift1 = fragment.getStartOffset1() - firstFragment.getStartOffset1();
                int shift2 = fragment.getStartOffset2() - firstFragment.getStartOffset2();
                DiffFragment previousFragment = (DiffFragment)ContainerUtil.getLastItem(newInnerFragments);
                if (previousFragment == null || !ComparisonManagerImpl.isAdjoiningInner(previousFragment, diffFragment, shift1, shift2)) {
                    newInnerFragments.add(new DiffFragmentImpl(diffFragment.getStartOffset1() + shift1, diffFragment.getEndOffset1() + shift1, diffFragment.getStartOffset2() + shift2, diffFragment.getEndOffset2() + shift2));
                    continue;
                }
                newInnerFragments.remove(newInnerFragments.size() - 1);
                newInnerFragments.add(new DiffFragmentImpl(previousFragment.getStartOffset1(), diffFragment.getEndOffset1() + shift1, previousFragment.getStartOffset2(), diffFragment.getEndOffset2() + shift2));
            }
        }
        LineFragmentImpl lineFragmentImpl = new LineFragmentImpl(firstFragment.getStartLine1(), lastFragment.getEndLine1(), firstFragment.getStartLine2(), lastFragment.getEndLine2(), firstFragment.getStartOffset1(), lastFragment.getEndOffset1(), firstFragment.getStartOffset2(), lastFragment.getEndOffset2(), newInnerFragments);
        if (lineFragmentImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "doSquash"));
        }
        return lineFragmentImpl;
    }

    private static boolean isAdjoining(@NotNull LineFragment beforeFragment, @NotNull LineFragment afterFragment) {
        if (beforeFragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beforeFragment", "com/intellij/diff/comparison/ComparisonManagerImpl", "isAdjoining"));
        }
        if (afterFragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterFragment", "com/intellij/diff/comparison/ComparisonManagerImpl", "isAdjoining"));
        }
        return beforeFragment.getEndLine1() == afterFragment.getStartLine1() && beforeFragment.getEndLine2() == afterFragment.getStartLine2() && beforeFragment.getEndOffset1() == afterFragment.getStartOffset1() && beforeFragment.getEndOffset2() == afterFragment.getStartOffset2();
    }

    private static boolean isAdjoiningInner(@NotNull DiffFragment beforeFragment, @NotNull DiffFragment afterFragment, int shift1, int shift2) {
        if (beforeFragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beforeFragment", "com/intellij/diff/comparison/ComparisonManagerImpl", "isAdjoiningInner"));
        }
        if (afterFragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterFragment", "com/intellij/diff/comparison/ComparisonManagerImpl", "isAdjoiningInner"));
        }
        return beforeFragment.getEndOffset1() == afterFragment.getStartOffset1() + shift1 && beforeFragment.getEndOffset2() == afterFragment.getStartOffset2() + shift2;
    }

    @NotNull
    private static List<? extends DiffFragment> extractInnerFragments(@NotNull LineFragment lineFragment) {
        if (lineFragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineFragment", "com/intellij/diff/comparison/ComparisonManagerImpl", "extractInnerFragments"));
        }
        if (lineFragment.getInnerFragments() != null) {
            List list = lineFragment.getInnerFragments();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "extractInnerFragments"));
            }
            return list;
        }
        int length1 = lineFragment.getEndOffset1() - lineFragment.getStartOffset1();
        int length2 = lineFragment.getEndOffset2() - lineFragment.getStartOffset2();
        List<DiffFragmentImpl> list = Collections.singletonList(new DiffFragmentImpl(0, length1, 0, length2));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/comparison/ComparisonManagerImpl", "extractInnerFragments"));
        }
        return list;
    }
}

