/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util.base;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.Condition;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum HighlightingLevel {
    INSPECTIONS("Inspections", AllIcons.Ide.HectorOn, (Condition<RangeHighlighter>)((Condition)rangeHighlighter -> true)),
    ADVANCED("Syntax", AllIcons.Ide.HectorSyntax, (Condition<RangeHighlighter>)((Condition)rangeHighlighter -> rangeHighlighter.getLayer() <= 3000)),
    SIMPLE("None", AllIcons.Ide.HectorOff, (Condition<RangeHighlighter>)((Condition)rangeHighlighter -> rangeHighlighter.getLayer() <= 1000));

    @NotNull
    private final String myText;
    @Nullable
    private final Icon myIcon;
    @NotNull
    private final Condition<RangeHighlighter> myCondition;

    private HighlightingLevel(@NotNull String text, Icon icon, Condition<RangeHighlighter> condition) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/tools/util/base/HighlightingLevel", "<init>"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/diff/tools/util/base/HighlightingLevel", "<init>"));
        }
        this.myText = text;
        this.myIcon = icon;
        this.myCondition = condition;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/HighlightingLevel", "getText"));
        }
        return string;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    @NotNull
    public Condition<RangeHighlighter> getCondition() {
        Condition<RangeHighlighter> condition = this.myCondition;
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/base/HighlightingLevel", "getCondition"));
        }
        return condition;
    }
}

