/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.applet;

import com.intellij.application.options.ModulesComboBox;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.applet.AppletConfiguration;
import com.intellij.execution.impl.CheckableRunConfigurationEditor;
import com.intellij.execution.ui.ClassBrowser;
import com.intellij.execution.ui.ConfigurationModuleSelector;
import com.intellij.execution.ui.DefaultJreSelector;
import com.intellij.execution.ui.JrePathEditor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.EditorTextFieldWithBrowseButton;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AppletConfigurable
extends SettingsEditor<AppletConfiguration>
implements CheckableRunConfigurationEditor<AppletConfiguration>,
PanelWithAnchor {
    private JPanel myWholePanel;
    private JRadioButton myMainClass;
    private JRadioButton myURL;
    private JPanel myClassOptions;
    private JPanel myHTMLOptions;
    private LabeledComponent<TextFieldWithBrowseButton> myPolicyFile;
    private LabeledComponent<RawCommandLineEditor> myVMParameters;
    private EditorTextFieldWithBrowseButton myClassName;
    private TextFieldWithBrowseButton myHtmlFile;
    private JTextField myWidth;
    private JTextField myHeight;
    private LabeledComponent<ModulesComboBox> myModule;
    private JPanel myTablePlace;
    private JBLabel myHtmlFileLabel;
    private JBLabel myClassNameLabel;
    private JBLabel myWidthLabel;
    private JLabel myHeightLabel;
    private JrePathEditor myJrePathEditor;
    private final ButtonGroup myAppletRadioButtonGroup;
    private JComponent anchor;
    private final Project myProject;
    private final ConfigurationModuleSelector myModuleSelector;
    private static final ColumnInfo[] PARAMETER_COLUMNS = new ColumnInfo[]{new MyColumnInfo(ExecutionBundle.message((String)"applet.configuration.parameter.name.column", (Object[])new Object[0])){

        public String valueOf(AppletConfiguration.AppletParameter appletParameter) {
            return appletParameter.getName();
        }

        public void setValue(AppletConfiguration.AppletParameter appletParameter, String name) {
            appletParameter.setName(name);
        }
    }, new MyColumnInfo(ExecutionBundle.message((String)"applet.configuration.parameter.value.column", (Object[])new Object[0])){

        public String valueOf(AppletConfiguration.AppletParameter appletParameter) {
            return appletParameter.getValue();
        }

        public void setValue(AppletConfiguration.AppletParameter appletParameter, String value) {
            appletParameter.setValue(value);
        }
    }};
    private final ListTableModel<AppletConfiguration.AppletParameter> myParameters;
    private final TableView myTable;
    @NonNls
    protected static final String HTTP_PREFIX = "http:/";

    private void changePanel() {
        if (this.myMainClass.isSelected()) {
            this.myClassOptions.setVisible(true);
            this.myHTMLOptions.setVisible(false);
        } else {
            this.myHTMLOptions.setVisible(true);
            this.myClassOptions.setVisible(false);
        }
    }

    public AppletConfigurable(Project project2) {
        this.myProject = project2;
        this.$$$setupUI$$$();
        this.myClassNameLabel.setLabelFor((Component)this.myClassName.getChildComponent());
        this.myHtmlFileLabel.setLabelFor((Component)this.myHtmlFile.getTextField());
        this.myWidthLabel.setLabelFor((Component)this.myWidth);
        this.myHeightLabel.setLabelFor(this.myHeight);
        this.myModuleSelector = new ConfigurationModuleSelector(project2, this.getModuleComponent());
        this.myJrePathEditor.setDefaultJreSelector(DefaultJreSelector.fromModuleDependencies(this.getModuleComponent(), true));
        this.myTablePlace.setLayout(new BorderLayout());
        this.myParameters = new ListTableModel(PARAMETER_COLUMNS);
        this.myTable = new TableView(this.myParameters);
        this.myTable.getEmptyText().setText(ExecutionBundle.message((String)"no.parameters", (Object[])new Object[0]));
        this.myTablePlace.add((Component)ToolbarDecorator.createDecorator((JTable)this.myTable).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                AppletConfigurable.this.addParameter();
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                AppletConfigurable.this.removeParameter();
            }
        }).disableUpDownActions().createPanel(), "Center");
        this.myAppletRadioButtonGroup = new ButtonGroup();
        this.myAppletRadioButtonGroup.add(this.myMainClass);
        this.myAppletRadioButtonGroup.add(this.myURL);
        this.getVMParametersComponent().setDialogCaption(this.myVMParameters.getRawText());
        this.myMainClass.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppletConfigurable.this.changePanel();
            }
        });
        this.myURL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AppletConfigurable.this.changePanel();
            }
        });
        this.getPolicyFileComponent().addBrowseFolderListener(ExecutionBundle.message((String)"select.applet.policy.file.dialog.title", (Object[])new Object[0]), null, this.myProject, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        this.getHtmlPathComponent().addBrowseFolderListener(ExecutionBundle.message((String)"choose.html.file.dialog.title", (Object[])new Object[0]), null, this.myProject, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        ClassBrowser.createAppletClassBrowser(this.myProject, this.myModuleSelector).setField(this.getClassNameComponent());
        this.myHTMLOptions.setVisible(false);
        this.setAnchor((JComponent)this.myVMParameters.getLabel());
    }

    private void removeParameter() {
        TableUtil.removeSelectedItems((JTable)this.myTable);
    }

    private void addParameter() {
        ArrayList<AppletConfiguration.AppletParameter> newItems = new ArrayList<AppletConfiguration.AppletParameter>(this.myParameters.getItems());
        AppletConfiguration.AppletParameter parameter = new AppletConfiguration.AppletParameter("newParameter", "");
        newItems.add(parameter);
        this.myParameters.setItems(newItems);
        int index = newItems.size() - 1;
        this.myTable.getSelectionModel().setSelectionInterval(index, index);
        this.myTable.scrollRectToVisible(this.myTable.getCellRect(index, 0, true));
    }

    private ModulesComboBox getModuleComponent() {
        return (ModulesComboBox)((Object)this.myModule.getComponent());
    }

    private TextFieldWithBrowseButton getPolicyFileComponent() {
        return (TextFieldWithBrowseButton)this.myPolicyFile.getComponent();
    }

    private static List<AppletConfiguration.AppletParameter> cloneParameters(List<AppletConfiguration.AppletParameter> items) {
        ArrayList<AppletConfiguration.AppletParameter> params = new ArrayList<AppletConfiguration.AppletParameter>();
        for (AppletConfiguration.AppletParameter appletParameter : items) {
            params.add(new AppletConfiguration.AppletParameter(appletParameter.getName(), appletParameter.getValue()));
        }
        return params;
    }

    private JTextField getWidthComponent() {
        return this.myWidth;
    }

    private EditorTextFieldWithBrowseButton getClassNameComponent() {
        return this.myClassName;
    }

    private TextFieldWithBrowseButton getHtmlPathComponent() {
        return this.myHtmlFile;
    }

    private String toNull(String s) {
        return (s = s.trim()).length() == 0 ? null : s;
    }

    private String toSystemFormat(String s) {
        return (s = s.trim()).length() == 0 ? null : s.replace(File.separatorChar, '/');
    }

    public void applyEditorTo(AppletConfiguration configuration) {
        this.checkEditorData(configuration);
        this.myTable.stopEditing();
        List<AppletConfiguration.AppletParameter> params = AppletConfigurable.cloneParameters(this.myParameters.getItems());
        configuration.setAppletParameters(params);
    }

    public void resetEditorFrom(AppletConfiguration configuration) {
        this.getClassNameComponent().setText(configuration.MAIN_CLASS_NAME);
        String presentableHtmlName = configuration.HTML_FILE_NAME;
        if (presentableHtmlName != null && !StringUtil.startsWithIgnoreCase((String)presentableHtmlName, (String)HTTP_PREFIX)) {
            presentableHtmlName = presentableHtmlName.replace('/', File.separatorChar);
        }
        this.getHtmlPathComponent().setText(presentableHtmlName);
        this.getPolicyFileComponent().setText(configuration.getPolicyFile());
        this.getVMParametersComponent().setText(configuration.VM_PARAMETERS);
        this.getWidthComponent().setText(Integer.toString(configuration.WIDTH));
        this.getHeightComponent().setText(Integer.toString(configuration.HEIGHT));
        (configuration.HTML_USED ? this.myURL : this.myMainClass).setSelected(true);
        this.changePanel();
        AppletConfiguration.AppletParameter[] appletParameters = configuration.getAppletParameters();
        if (appletParameters != null) {
            this.myParameters.setItems(AppletConfigurable.cloneParameters(Arrays.asList(appletParameters)));
        }
        this.myModuleSelector.reset(configuration);
        this.myJrePathEditor.setPathOrName(configuration.ALTERNATIVE_JRE_PATH, configuration.ALTERNATIVE_JRE_PATH_ENABLED);
    }

    private RawCommandLineEditor getVMParametersComponent() {
        return (RawCommandLineEditor)this.myVMParameters.getComponent();
    }

    private JTextField getHeightComponent() {
        return this.myHeight;
    }

    @NotNull
    public JComponent createEditor() {
        JPanel jPanel = this.myWholePanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/applet/AppletConfigurable", "createEditor"));
        }
        return jPanel;
    }

    public void checkEditorData(AppletConfiguration configuration) {
        configuration.MAIN_CLASS_NAME = this.toNull(this.getClassNameComponent().getText());
        configuration.HTML_FILE_NAME = this.toSystemFormat(this.getHtmlPathComponent().getText());
        configuration.VM_PARAMETERS = this.toNull(this.getVMParametersComponent().getText());
        configuration.setPolicyFile(this.getPolicyFileComponent().getText());
        this.myModuleSelector.applyTo(configuration);
        try {
            configuration.WIDTH = Integer.parseInt(this.getWidthComponent().getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            configuration.HEIGHT = Integer.parseInt(this.getHeightComponent().getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        configuration.HTML_USED = this.myURL.isSelected();
        configuration.ALTERNATIVE_JRE_PATH = this.myJrePathEditor.getJrePathOrName();
        configuration.ALTERNATIVE_JRE_PATH_ENABLED = this.myJrePathEditor.isAlternativeJreSelected();
    }

    private void createUIComponents() {
        this.myClassName = new EditorTextFieldWithBrowseButton(this.myProject, true);
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.myModule.setAnchor(anchor);
        this.myPolicyFile.setAnchor(anchor);
        this.myVMParameters.setAnchor(anchor);
        this.myJrePathEditor.setAnchor(anchor);
        this.myHtmlFileLabel.setAnchor(anchor);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JrePathEditor jrePathEditor;
        JTextField jTextField;
        JLabel jLabel;
        JTextField jTextField2;
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JPanel jPanel;
        JPanel jPanel2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JBLabel jBLabel3;
        JPanel jPanel3;
        LabeledComponent labeledComponent;
        LabeledComponent labeledComponent2;
        LabeledComponent labeledComponent3;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JPanel jPanel4;
        this.createUIComponents();
        this.myWholePanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(8, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 1, null, null, null));
        this.myMainClass = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/ExecutionBundle").getString("applet.configuration.applet.class.option"));
        jRadioButton2.setSelected(true);
        jPanel5.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myURL = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/ExecutionBundle").getString("applet.configuration.url.label"));
        jPanel5.add((Component)jRadioButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myPolicyFile = labeledComponent3 = new LabeledComponent();
        labeledComponent3.setLabelInsets(new Insets(0, 0, 0, 0));
        labeledComponent3.setText(ResourceBundle.getBundle("messages/ExecutionBundle").getString("applet.configuration.policy.file.label"));
        labeledComponent3.setComponentClass("com.intellij.openapi.ui.TextFieldWithBrowseButton");
        labeledComponent3.setLabelLocation("West");
        jPanel4.add((Component)labeledComponent3, new GridConstraints(3, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        this.myVMParameters = labeledComponent2 = new LabeledComponent();
        labeledComponent2.setLabelInsets(new Insets(0, 0, 0, 0));
        labeledComponent2.setText(ResourceBundle.getBundle("messages/ExecutionBundle").getString("applet.configuration.vm.parameters.for.appletviewer.label"));
        labeledComponent2.setComponentClass("com.intellij.ui.RawCommandLineEditor");
        labeledComponent2.setLabelLocation("West");
        jPanel4.add((Component)labeledComponent2, new GridConstraints(4, 0, 1, 1, 1, 1, 3, 0, null, new Dimension(400, -1), null));
        this.myModule = labeledComponent = new LabeledComponent();
        labeledComponent.setText(ResourceBundle.getBundle("messages/ExecutionBundle").getString("application.configuration.use.classpath.and.jdk.of.module.label"));
        labeledComponent.setComponentClass("com.intellij.application.options.ModulesComboBox");
        labeledComponent.setLabelLocation("West");
        jPanel4.add((Component)labeledComponent, new GridConstraints(5, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myHTMLOptions = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "");
        jPanel6.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 7, null, null, null));
        this.myHtmlFileLabel = jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, ResourceBundle.getBundle("messages/ExecutionBundle").getString("applet.configuration.url.html.file.label"));
        jPanel3.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHtmlFile = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setText("");
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 8, 3, 3, 0, null, null, null));
        this.myClassOptions = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel2).setEnabled(true);
        jPanel2.putClientProperty("BorderFactoryClass", "");
        jPanel6.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 1, 1, 3, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel7, new GridConstraints(3, 0, 1, 2, 1, 1, 3, 0, null, null, null));
        jPanel7.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/ExecutionBundle").getString("applet.configuration.applet.parameters.label"), (int)0, (int)0, null, null));
        this.myTablePlace = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel7.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(-1, 100), null));
        this.myClassNameLabel = jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("messages/ExecutionBundle").getString("applet.configuration.applet.class.label"));
        jPanel2.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        EditorTextFieldWithBrowseButton editorTextFieldWithBrowseButton = this.myClassName;
        editorTextFieldWithBrowseButton.setText("");
        jPanel2.add((Component)((Object)editorTextFieldWithBrowseButton), new GridConstraints(0, 1, 1, 1, 8, 3, 3, 0, null, null, null));
        this.myWidthLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("messages/ExecutionBundle").getString("applet.configuration.width.label"));
        jPanel2.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myWidth = jTextField2 = new JTextField();
        jTextField2.setText("");
        jPanel2.add((Component)jTextField2, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(50, -1), null));
        this.myHeightLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/ExecutionBundle").getString("applet.configuration.height.label"));
        jPanel2.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHeight = jTextField = new JTextField();
        jTextField.setText("");
        jPanel2.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 0, null, new Dimension(50, -1), null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(7, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JSeparator jSeparator = new JSeparator();
        jPanel4.add((Component)jSeparator, new GridConstraints(2, 0, 1, 1, 0, 1, 0, 7, null, null, null));
        this.myJrePathEditor = jrePathEditor = new JrePathEditor();
        jPanel4.add((Component)jrePathEditor, new GridConstraints(6, 0, 1, 1, 0, 1, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myWholePanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static abstract class MyColumnInfo
    extends ColumnInfo<AppletConfiguration.AppletParameter, String> {
        public MyColumnInfo(String name) {
            super(name);
        }

        public TableCellEditor getEditor(AppletConfiguration.AppletParameter item) {
            JTextField textField = new JTextField();
            textField.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            return new DefaultCellEditor(textField);
        }

        public boolean isCellEditable(AppletConfiguration.AppletParameter appletParameter) {
            return true;
        }
    }
}

