/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ProcessProxy;
import com.intellij.openapi.util.Key;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.jetbrains.annotations.NonNls;

class ProcessProxyImpl
implements ProcessProxy {
    public static final Key<ProcessProxyImpl> KEY = Key.create((String)"ProcessProxyImpl");
    @NonNls
    public static final String PROPERTY_BINPATH = "idea.launcher.bin.path";
    @NonNls
    public static final String PROPERTY_PORT_NUMBER = "idea.launcher.port";
    @NonNls
    public static final String LAUNCH_MAIN_CLASS = "com.intellij.rt.execution.application.AppMain";
    @NonNls
    private static final String DONT_USE_LAUNCHER_PROPERTY = "idea.no.launcher";
    private static final int SOCKET_NUMBER_START = 7532;
    private static final int SOCKET_NUMBER = 100;
    private static final boolean[] ourUsedSockets = new boolean[100];
    private final int myPortNumber = ProcessProxyImpl.findFreePort();
    private PrintWriter myWriter;
    private Socket mySocket;

    public ProcessProxyImpl() throws NoMoreSocketsException {
        if (this.myPortNumber == -1) {
            throw new NoMoreSocketsException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int findFreePort() {
        boolean[] blArray = ourUsedSockets;
        synchronized (ourUsedSockets) {
            for (int j = 0; j < 100; ++j) {
                if (ourUsedSockets[j]) continue;
                try {
                    ServerSocket s = new ServerSocket(j + 7532);
                    s.close();
                    ProcessProxyImpl.ourUsedSockets[j] = true;
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return j + 7532;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return -1;
        }
    }

    public int getPortNumber() {
        return this.myPortNumber;
    }

    protected synchronized void finalize() throws Throwable {
        if (this.myWriter != null) {
            this.myWriter.close();
        }
        ProcessProxyImpl.ourUsedSockets[this.myPortNumber - 7532] = false;
        super.finalize();
    }

    public void attach(ProcessHandler processHandler2) {
        processHandler2.putUserData(KEY, (Object)this);
    }

    private synchronized void writeLine(@NonNls String s) {
        if (this.myWriter == null) {
            try {
                if (this.mySocket == null) {
                    this.mySocket = new Socket(InetAddress.getLoopbackAddress(), this.myPortNumber);
                }
                this.myWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(this.mySocket.getOutputStream())));
            }
            catch (IOException e) {
                return;
            }
        }
        this.myWriter.println(s);
        this.myWriter.flush();
    }

    public void sendBreak() {
        this.writeLine("BREAK");
    }

    public void sendStop() {
        this.writeLine("STOP");
    }

    public static boolean useLauncher() {
        return Boolean.valueOf(System.getProperty(DONT_USE_LAUNCHER_PROPERTY)) == false;
    }

    public static class NoMoreSocketsException
    extends Exception {
    }
}

