/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AlignmentCyclesDetector {
    private final int myTotalAlignmentsCount;
    private int myBlockRollbacks;
    private LeafBlockWrapper myOffsetResponsibleBlock;
    private int myBeforeTotalSpaces;
    private Map<List<LeafBlockWrapper>, Set<Pair<Integer, Integer>>> map = ContainerUtil.newHashMap();

    public AlignmentCyclesDetector(int totalAlignmentsCount) {
        this.myTotalAlignmentsCount = totalAlignmentsCount;
    }

    public void registerOffsetResponsibleBlock(LeafBlockWrapper block) {
        this.myOffsetResponsibleBlock = block;
        this.myBeforeTotalSpaces = block.getWhiteSpace().getTotalSpaces();
    }

    public boolean isCycleDetected() {
        return this.myBlockRollbacks > this.myTotalAlignmentsCount;
    }

    public void registerBlockRollback(LeafBlockWrapper currentBlock) {
        List<LeafBlockWrapper> pairId = Arrays.asList(currentBlock, this.myOffsetResponsibleBlock);
        Set<Pair<Integer, Integer>> pairs = this.map.get(pairId);
        if (pairs == null) {
            pairs = new HashSet<Pair<Integer, Integer>>();
            this.map.put(pairId, pairs);
        }
        int newSpaces = this.myOffsetResponsibleBlock.getWhiteSpace().getTotalSpaces();
        boolean added = pairs.add((Pair<Integer, Integer>)Pair.create((Object)this.myBeforeTotalSpaces, (Object)newSpaces));
        if (added) {
            ++this.myBlockRollbacks;
        }
    }
}

