/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndentInside {
    public int whiteSpaces = 0;
    public int tabs = 0;

    public IndentInside() {
    }

    public IndentInside(int whiteSpaces, int tabs) {
        this.whiteSpaces = whiteSpaces;
        this.tabs = tabs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndentInside indent = (IndentInside)o;
        if (this.tabs != indent.tabs) {
            return false;
        }
        return this.whiteSpaces == indent.whiteSpaces;
    }

    public int hashCode() {
        int result2 = this.whiteSpaces;
        result2 = 29 * result2 + this.tabs;
        return result2;
    }

    public int getTabsCount(CommonCodeStyleSettings.IndentOptions options) {
        int tabsFromSpaces = this.whiteSpaces / options.TAB_SIZE;
        return this.tabs + tabsFromSpaces;
    }

    public int getSpacesCount(CommonCodeStyleSettings.IndentOptions options) {
        return this.whiteSpaces + this.tabs * options.TAB_SIZE;
    }

    @NotNull
    static IndentInside getLastLineIndent(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/formatting/IndentInside", "getLastLineIndent"));
        }
        CharSequence lastLine = IndentInside.getLastLine(text);
        IndentInside indentInside = IndentInside.createIndentOn(lastLine);
        if (indentInside == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/IndentInside", "getLastLineIndent"));
        }
        return indentInside;
    }

    @NotNull
    public static IndentInside createIndentOn(@Nullable CharSequence lastLine) {
        IndentInside result2 = new IndentInside();
        if (lastLine == null) {
            IndentInside indentInside = result2;
            if (indentInside == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/IndentInside", "createIndentOn"));
            }
            return indentInside;
        }
        for (int i = 0; i < lastLine.length(); ++i) {
            if (lastLine.charAt(i) == ' ') {
                ++result2.whiteSpaces;
            }
            if (lastLine.charAt(i) != '\t') continue;
            ++result2.tabs;
        }
        IndentInside indentInside = result2;
        if (indentInside == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/IndentInside", "createIndentOn"));
        }
        return indentInside;
    }

    @NotNull
    public static CharSequence getLastLine(@NotNull CharSequence text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/formatting/IndentInside", "getLastLine"));
        }
        int i = CharArrayUtil.shiftBackwardUntil((CharSequence)text, (int)(text.length() - 1), (String)"\n");
        if (i < 0) {
            CharSequence charSequence = text;
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/IndentInside", "getLastLine"));
            }
            return charSequence;
        }
        if (i >= text.length() - 1) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/IndentInside", "getLastLine"));
            }
            return "";
        }
        CharSequence charSequence = text.subSequence(i + 1, text.length());
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/formatting/IndentInside", "getLastLine"));
        }
        return charSequence;
    }

    public String toString() {
        return String.format("spaces: %d, tabs: %d", this.whiteSpaces, this.tabs);
    }
}

