/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration;

import com.intellij.history.core.LabelImpl;
import com.intellij.history.core.revisions.ChangeRevision;
import com.intellij.history.core.revisions.Revision;
import com.intellij.history.integration.ui.models.HistoryDialogModel;
import com.intellij.history.integration.ui.models.RevisionItem;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LocalHistoryUtil {
    static int findRevisionIndexToRevert(@NotNull HistoryDialogModel dirHistoryModel, @NotNull LabelImpl label) {
        if (dirHistoryModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirHistoryModel", "com/intellij/history/integration/LocalHistoryUtil", "findRevisionIndexToRevert"));
        }
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/intellij/history/integration/LocalHistoryUtil", "findRevisionIndexToRevert"));
        }
        List<RevisionItem> revs = dirHistoryModel.getRevisions();
        for (int i = 0; i < revs.size(); ++i) {
            RevisionItem rev = revs.get(i);
            if (LocalHistoryUtil.isLabelRevision(rev, label)) {
                return i;
            }
            if (!LocalHistoryUtil.isChangeWithId(rev.revision, label.getLabelChangeId())) continue;
            return i;
        }
        return -1;
    }

    static boolean isLabelRevision(@NotNull RevisionItem rev, @NotNull LabelImpl label) {
        if (rev == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rev", "com/intellij/history/integration/LocalHistoryUtil", "isLabelRevision"));
        }
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/intellij/history/integration/LocalHistoryUtil", "isLabelRevision"));
        }
        long targetChangeId = label.getLabelChangeId();
        return ContainerUtil.exists(rev.labels, revision -> LocalHistoryUtil.isChangeWithId(revision, targetChangeId));
    }

    private static boolean isChangeWithId(@NotNull Revision revision, long targetChangeId) {
        if (revision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision", "com/intellij/history/integration/LocalHistoryUtil", "isChangeWithId"));
        }
        return revision instanceof ChangeRevision && ((ChangeRevision)revision).containsChangeWithId(targetChangeId);
    }
}

