/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.IdeView;
import com.intellij.ide.PasteProvider;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.ide.dnd.LinuxDragAndDropSupport;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.copy.CopyFilesOrDirectoriesHandler;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesHandler;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FileListPasteProvider
implements PasteProvider {
    public void performPaste(@NotNull DataContext dataContext) {
        PsiDirectory dir;
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ide/FileListPasteProvider", "performPaste"));
        }
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        IdeView ideView = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (project2 == null || ideView == null) {
            return;
        }
        if (!FileCopyPasteUtil.isFileListFlavorAvailable()) {
            return;
        }
        Transferable contents = CopyPasteManager.getInstance().getContents();
        if (contents == null) {
            return;
        }
        List<File> fileList = FileCopyPasteUtil.getFileList(contents);
        if (fileList == null) {
            return;
        }
        if (DumbService.isDumb((Project)project2)) {
            DumbService.getInstance((Project)project2).showDumbModeNotification("Sorry, file copy/paste is not available during indexing");
            return;
        }
        ArrayList<PsiDirectory> elements = new ArrayList<PsiDirectory>();
        for (File file2 : fileList) {
            VirtualFile vFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2);
            if (vFile == null) continue;
            PsiManager instance = PsiManager.getInstance((Project)project2);
            Object item = vFile.isDirectory() ? instance.findDirectory(vFile) : instance.findFile(vFile);
            if (item == null) continue;
            elements.add((PsiDirectory)item);
        }
        if (elements.size() > 0 && (dir = ideView.getOrChooseDirectory()) != null) {
            boolean move = LinuxDragAndDropSupport.isMoveOperation(contents);
            if (move) {
                new MoveFilesOrDirectoriesHandler().doMove(PsiUtilCore.toPsiElementArray(elements), (PsiElement)dir);
            } else {
                new CopyFilesOrDirectoriesHandler().doCopy(PsiUtilCore.toPsiElementArray(elements), dir);
            }
        }
    }

    public boolean isPastePossible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ide/FileListPasteProvider", "isPastePossible"));
        }
        return true;
    }

    public boolean isPasteEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/ide/FileListPasteProvider", "isPasteEnabled"));
        }
        return LangDataKeys.IDE_VIEW.getData(dataContext) != null && FileCopyPasteUtil.isFileListFlavorAvailable();
    }
}

