/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.AbstractBundle;
import com.intellij.CommonBundle;
import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.SchemeManagerFactoryBase;
import com.intellij.configurationStore.SchemeManagerFactoryImplKt;
import com.intellij.configurationStore.SchemeManagerImpl;
import com.intellij.configurationStore.StateStorageManagerImplKt;
import com.intellij.ide.actions.ExportSettingsAction;
import com.intellij.ide.actions.ExportSettingsActionKt;
import com.intellij.ide.actions.ExportableItem;
import com.intellij.ide.actions.MyZipOutputStream;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ExportableApplicationComponent;
import com.intellij.openapi.components.ExportableComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceBean;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.impl.ServiceManagerImpl;
import com.intellij.openapi.components.impl.stores.StateStorageManager;
import com.intellij.openapi.components.impl.stores.StoreUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemesManagerFactory;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.PairProcessor;
import com.intellij.util.PathKt;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.io.ZipUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.io.FileFilter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000j\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a$\u0010\u0007\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a&\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002\u001aD\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\b\b\u0002\u0010\u001d\u001a\u00020\u001e2\u0010\b\u0002\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\t\u001a \u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u000eH\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "exportInstalledPlugins", "", "zipOut", "Lcom/intellij/ide/actions/MyZipOutputStream;", "exportSettings", "exportFiles", "", "Ljava/nio/file/Path;", "out", "Ljava/io/OutputStream;", "configPath", "", "getComponentPresentableName", "state", "Lcom/intellij/openapi/components/State;", "aClass", "Ljava/lang/Class;", "pluginDescriptor", "Lcom/intellij/openapi/extensions/PluginDescriptor;", "getExportableComponentsMap", "", "", "Lcom/intellij/ide/actions/ExportableItem;", "onlyExisting", "", "computePresentableNames", "storageManager", "Lcom/intellij/openapi/components/impl/stores/StateStorageManager;", "onlyPaths", "messageOrDefault", "classLoader", "Ljava/lang/ClassLoader;", "bundleName", "defaultName", "configuration-store-impl"})
public final class ExportSettingsActionKt {
    private static final Logger LOG = Logger.getInstance(ExportSettingsAction.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void exportSettings(@NotNull Set<? extends Path> exportFiles, @NotNull OutputStream out, @NotNull String configPath) {
        Intrinsics.checkParameterIsNotNull(exportFiles, (String)"exportFiles");
        Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
        Intrinsics.checkParameterIsNotNull((Object)configPath, (String)"configPath");
        MyZipOutputStream zipOut = new MyZipOutputStream(out);
        try {
            THashSet writtenItemRelativePaths = new THashSet();
            for (Path path : exportFiles) {
                String relativePath;
                if (!PathKt.exists(path)) continue;
                if (FileUtilRt.getRelativePath((String)configPath, (String)PathKt.getSystemIndependentPath(path.toAbsolutePath()), (char)'/') == null) {
                    Intrinsics.throwNpe();
                }
                ZipUtil.addFileOrDirRecursively((ZipOutputStream)zipOut, (File)null, (File)path.toFile(), (String)relativePath, (FileFilter)null, (Set)((Set)writtenItemRelativePaths));
            }
            ExportSettingsActionKt.exportInstalledPlugins(zipOut);
            ZipEntry zipEntry = new ZipEntry("IntelliJ IDEA Global Settings");
            zipOut.putNextEntry(zipEntry);
            zipOut.closeEntry();
        }
        finally {
            zipOut.doClose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void exportInstalledPlugins(MyZipOutputStream zipOut) {
        ArrayList<String> plugins2 = new ArrayList<String>();
        IdeaPluginDescriptor[] ideaPluginDescriptorArray = PluginManagerCore.getPlugins();
        for (int i = 0; i < ideaPluginDescriptorArray.length; ++i) {
            IdeaPluginDescriptor descriptor = ideaPluginDescriptorArray[i];
            if (descriptor.isBundled() || !descriptor.isEnabled()) continue;
            plugins2.add(descriptor.getPluginId().getIdString());
        }
        if (plugins2.isEmpty()) {
            return;
        }
        ZipEntry e = new ZipEntry("installed.txt");
        zipOut.putNextEntry(e);
        try {
            PluginManagerCore.writePluginsList((Collection<String>)plugins2, new OutputStreamWriter((OutputStream)zipOut, CharsetToolkit.UTF8_CHARSET));
        }
        finally {
            zipOut.closeEntry();
        }
    }

    @NotNull
    public static final Map<Path, List<ExportableItem>> getExportableComponentsMap(boolean onlyExisting, boolean computePresentableNames, @NotNull StateStorageManager storageManager2, @Nullable Set<String> onlyPaths) {
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)storageManager2, (String)"storageManager");
        LinkedHashMap result2 = new LinkedHashMap();
        Function1 processor2 = (Function1)new Function1<ExportableComponent, Unit>(result2){
            final /* synthetic */ LinkedHashMap $result;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull ExportableComponent component) {
                List list;
                void destination$iv$iv;
                void $receiver$iv$iv;
                void $receiver$iv;
                ExportableItem exportableItem;
                Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
                Object[] objectArray = component.getExportFiles();
                ExportableItem exportableItem2 = exportableItem;
                ExportableItem exportableItem3 = exportableItem;
                Iterator<Path> iterator = $receiver$iv;
                Collection collection = new ArrayList<E>(((void)$receiver$iv).length);
                for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
                    void it;
                    void item$iv$iv = $receiver$iv$iv[i];
                    File file2 = (File)item$iv$iv;
                    list = destination$iv$iv;
                    Path path = it.toPath();
                    list.add(path);
                }
                list = (List)destination$iv$iv;
                String string = component.getPresentableName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"component.presentableName");
                exportableItem2(list, string, RoamingType.DEFAULT);
                ExportableItem item = exportableItem3;
                for (Path exportFile : item.getFiles()) {
                    UtilKt.putValue(this.$result, exportFile, item);
                }
            }
            {
                this.$result = linkedHashMap;
                super(1);
            }
        };
        Object[] objectArray = ApplicationManager.getApplication().getComponents(ExportableApplicationComponent.class);
        for (int i = 0; i < ((void)$receiver$iv).length; ++i) {
            Object element$iv = $receiver$iv[i];
            processor2.invoke(element$iv);
        }
        $receiver$iv = ServiceBean.loadServicesFromBeans((ExtensionPointName)ExportableComponent.EXTENSION_POINT, ExportableComponent.class);
        for (Object element$iv : $receiver$iv) {
            processor2.invoke(element$iv);
        }
        String configPath = storageManager2.expandMacros(SchemeManagerFactoryImplKt.ROOT_CONFIG);
        Function1<Path, Boolean> isSkipFile$ = new Function1<Path, Boolean>(onlyPaths, configPath, onlyExisting){
            final /* synthetic */ Set $onlyPaths;
            final /* synthetic */ String $configPath;
            final /* synthetic */ boolean $onlyExisting;

            public final boolean invoke(@NotNull Path file2) {
                Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
                if (this.$onlyPaths != null) {
                    String string = FileUtilRt.getRelativePath((String)this.$configPath, (String)PathKt.getSystemIndependentPath(file2), (char)'/');
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    String relativePath = string;
                    if (!StringsKt.contains$default((CharSequence)((Object)file2.getFileName()).toString(), (char)'.', (boolean)false, (int)2, null) && !PathKt.isFile(file2)) {
                        relativePath = relativePath + '/';
                    }
                    if (!this.$onlyPaths.contains(relativePath)) {
                        return true;
                    }
                }
                return this.$onlyExisting && !PathKt.exists(file2);
            }
            {
                this.$onlyPaths = set;
                this.$configPath = string;
                this.$onlyExisting = bl;
                super(1);
            }
        };
        if (onlyExisting || onlyPaths != null) {
            CollectionsKt.removeAll((Iterable)result2.keySet(), (Function1)((Function1)new Function1<Path, Boolean>(isSkipFile$){
                final /* synthetic */ getExportableComponentsMap.1 $isSkipFile;

                public final boolean invoke(@NotNull Path p1) {
                    Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                    return this.$isSkipFile.invoke(p1);
                }

                public final KDeclarationContainer getOwner() {
                    return null;
                }

                public final String getName() {
                    return "isSkipFile";
                }

                public final String getSignature() {
                    return "invoke(Ljava/nio/file/Path;)Z";
                }
                {
                    this.$isSkipFile = var1_1;
                    super(1);
                }
            }));
        }
        THashMap fileToContent = new THashMap();
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.application.impl.ApplicationImpl");
        }
        ServiceManagerImpl.processAllImplementationClasses((ApplicationImpl)application, (PairProcessor)new PairProcessor<Class<?>, PluginDescriptor>(storageManager2, isSkipFile$, computePresentableNames, onlyExisting, fileToContent, result2){
            final /* synthetic */ StateStorageManager $storageManager;
            final /* synthetic */ getExportableComponentsMap.1 $isSkipFile;
            final /* synthetic */ boolean $computePresentableNames;
            final /* synthetic */ boolean $onlyExisting;
            final /* synthetic */ THashMap $fileToContent;
            final /* synthetic */ LinkedHashMap $result;

            /*
             * WARNING - void declaration
             */
            public final boolean process(Class<?> aClass, PluginDescriptor pluginDescriptor) {
                boolean isFileIncluded;
                Path file2;
                Storage storage2;
                State stateAnnotation;
                block20: {
                    block19: {
                        block18: {
                            block17: {
                                stateAnnotation = StoreUtil.getStateSpec(aClass);
                                if (stateAnnotation == null) break block17;
                                CharSequence charSequence = stateAnnotation.name();
                                if (!(charSequence == null || charSequence.length() == 0) && !ExportableComponent.class.isAssignableFrom(aClass)) break block18;
                            }
                            return true;
                        }
                        Storage storage3 = (Storage)ArraysKt.firstOrNull((Object[])ComponentStoreImplKt.sortByDeprecated(stateAnnotation.storages()));
                        if (storage3 == null) {
                            return true;
                        }
                        storage2 = storage3;
                        if (!(Intrinsics.areEqual((Object)storage2.roamingType(), (Object)RoamingType.DISABLED) ^ true) || !Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass((Class)storage2.storageClass()), (Object)Reflection.getOrCreateKotlinClass(StateStorage.class))) break block19;
                        CharSequence charSequence = StateStorageManagerImplKt.getPath(storage2);
                        if (!(charSequence == null || charSequence.length() == 0)) break block20;
                    }
                    return true;
                }
                Path additionalExportFile = null;
                String additionalExportPath = stateAnnotation.additionalExportFile();
                CharSequence charSequence = additionalExportPath;
                if (charSequence.length() > 0) {
                    additionalExportFile = additionalExportPath.charAt(0) == '$' ? Paths.get(this.$storageManager.expandMacros(additionalExportPath), new String[0]) : Paths.get(this.$storageManager.expandMacros(SchemeManagerFactoryImplKt.ROOT_CONFIG), additionalExportPath);
                    Path path = additionalExportFile;
                    Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"additionalExportFile");
                    if (this.$isSkipFile.invoke(path)) {
                        additionalExportFile = null;
                    }
                }
                Path path = file2 = Paths.get(this.$storageManager.expandMacros(StateStorageManagerImplKt.getPath(storage2)), new String[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"file");
                boolean bl = isFileIncluded = !this.$isSkipFile.invoke(path);
                if (isFileIncluded || additionalExportFile != null) {
                    String string;
                    List files;
                    if (this.$computePresentableNames && this.$onlyExisting && additionalExportFile == null && StringsKt.endsWith$default((String)((Object)file2.getFileName()).toString(), (String)".xml", (boolean)false, (int)2, null)) {
                        Object object;
                        void $receiver$iv;
                        Map map = (Map)this.$fileToContent;
                        V value$iv = $receiver$iv.get(file2);
                        if (value$iv == null) {
                            String answer$iv = PathKt.readText(file2);
                            $receiver$iv.put(file2, answer$iv);
                            object = answer$iv;
                        } else {
                            object = value$iv;
                        }
                        String content = (String)object;
                        if (!StringsKt.contains$default((CharSequence)content, (CharSequence)("<component name=" + "\"" + stateAnnotation.name() + "\"" + ">"), (boolean)false, (int)2, null)) {
                            return true;
                        }
                    }
                    List list = additionalExportFile == null ? CollectionsKt.listOf((Object)file2) : (files = isFileIncluded ? CollectionsKt.listOf((Object[])new Path[]{file2, additionalExportFile}) : CollectionsKt.listOf((Object)additionalExportFile));
                    if (this.$computePresentableNames) {
                        Class<?> clazz = aClass;
                        Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"aClass");
                        string = ExportSettingsActionKt.access$getComponentPresentableName(stateAnnotation, clazz, pluginDescriptor);
                    } else {
                        string = "";
                    }
                    ExportableItem item = new ExportableItem(files, string, storage2.roamingType());
                    Map map = this.$result;
                    Path path2 = file2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"file");
                    UtilKt.putValue(map, path2, item);
                    if (additionalExportFile != null) {
                        UtilKt.putValue(this.$result, additionalExportFile, item);
                    }
                }
                return true;
            }
            {
                this.$storageManager = stateStorageManager;
                this.$isSkipFile = var2_2;
                this.$computePresentableNames = bl;
                this.$onlyExisting = bl2;
                this.$fileToContent = tHashMap;
                this.$result = linkedHashMap;
            }
        });
        SchemesManagerFactory schemesManagerFactory = SchemesManagerFactory.getInstance();
        if (schemesManagerFactory == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.configurationStore.SchemeManagerFactoryBase");
        }
        ((SchemeManagerFactoryBase)schemesManagerFactory).process((Function1<? super SchemeManagerImpl<Scheme, ExternalizableScheme>, Unit>)((Function1)new Function1<SchemeManagerImpl<Scheme, ExternalizableScheme>, Unit>(storageManager2, result2, isSkipFile$){
            final /* synthetic */ StateStorageManager $storageManager;
            final /* synthetic */ LinkedHashMap $result;
            final /* synthetic */ getExportableComponentsMap.1 $isSkipFile;

            public final void invoke(@NotNull SchemeManagerImpl<Scheme, ExternalizableScheme> it) {
                Path file2;
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                if (Intrinsics.areEqual((Object)it.getRoamingType(), (Object)RoamingType.DISABLED) ^ true && it.getPresentableName() != null && Intrinsics.areEqual((Object)StringsKt.getOrNull((CharSequence)it.getFileSpec(), (int)0), (Object)Character.valueOf('$')) ^ true && !this.$result.containsKey(file2 = Paths.get(this.$storageManager.expandMacros(SchemeManagerFactoryImplKt.ROOT_CONFIG), it.getFileSpec()))) {
                    Path path = file2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"file");
                    if (!this.$isSkipFile.invoke(path)) {
                        Map map = this.$result;
                        Path path2 = file2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"file");
                        UtilKt.putValue(map, path2, new ExportableItem(CollectionsKt.listOf((Object)file2), it.getPresentableName(), it.getRoamingType()));
                    }
                }
            }
            {
                this.$storageManager = stateStorageManager;
                this.$result = linkedHashMap;
                this.$isSkipFile = var3_3;
                super(1);
            }
        }));
        return result2;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Map getExportableComponentsMap$default(boolean bl, boolean bl2, StateStorageManager stateStorageManager, Set set, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getExportableComponentsMap");
        }
        if ((n & 4) != 0) {
            StateStorageManager stateStorageManager2 = ServiceKt.getStateStore((ComponentManager)ApplicationManager.getApplication()).getStateStorageManager();
            Intrinsics.checkExpressionValueIsNotNull((Object)stateStorageManager2, (String)"ApplicationManager.getAp\u2026Store.stateStorageManager");
            stateStorageManager = stateStorageManager2;
        }
        if ((n & 8) != 0) {
            set = null;
        }
        return ExportSettingsActionKt.getExportableComponentsMap(bl, bl2, stateStorageManager, set);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String getComponentPresentableName(State state, Class<?> aClass, PluginDescriptor pluginDescriptor) {
        Object classLoader;
        Object object;
        String resourceBundleName;
        Class presentableName = state.presentableName();
        if (Intrinsics.areEqual((Object)presentableName, State.NameGetter.class) ^ true) {
            try {
                String string = (String)((State.NameGetter)ReflectionUtil.newInstance((Class)presentableName)).get();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ReflectionUtil.newInstance(presentableName).get()");
                return string;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        String defaultName = state.name();
        Function0<String> trimDefaultName$ = new Function0<String>(defaultName){
            final /* synthetic */ String $defaultName;

            @NotNull
            public final String invoke() {
                return StringsKt.removeSuffix((String)this.$defaultName, (CharSequence)"Settings");
            }
            {
                this.$defaultName = string;
                super(0);
            }
        };
        if (pluginDescriptor instanceof IdeaPluginDescriptor && Intrinsics.areEqual((Object)"com.intellij", (Object)((IdeaPluginDescriptor)pluginDescriptor).getPluginId().getIdString()) ^ true) {
            resourceBundleName = ((IdeaPluginDescriptor)pluginDescriptor).getResourceBundleBaseName();
            if (resourceBundleName == null) {
                if (!Intrinsics.areEqual((Object)((IdeaPluginDescriptor)pluginDescriptor).getVendor(), (Object)"JetBrains")) return trimDefaultName$.invoke();
                resourceBundleName = "messages.OptionsBundle";
            }
        } else {
            resourceBundleName = "messages.OptionsBundle";
        }
        if ((object = pluginDescriptor) == null || (object = object.getPluginClassLoader()) == null) {
            object = classLoader = aClass.getClassLoader();
        }
        if (classLoader == null) return trimDefaultName$.invoke();
        String message = ExportSettingsActionKt.messageOrDefault((ClassLoader)classLoader, resourceBundleName, defaultName);
        if (message != defaultName) {
            return message;
        }
        if (!PlatformUtils.isRubyMine()) return trimDefaultName$.invoke();
        return ExportSettingsActionKt.messageOrDefault((ClassLoader)classLoader, "org.jetbrains.plugins.ruby.RBundle", defaultName);
    }

    private static final String messageOrDefault(ClassLoader classLoader, String bundleName, String defaultName) {
        ResourceBundle resourceBundle = AbstractBundle.getResourceBundle((String)bundleName, (ClassLoader)classLoader);
        if (resourceBundle == null) {
            return defaultName;
        }
        ResourceBundle bundle = resourceBundle;
        String string = CommonBundle.messageOrDefault((ResourceBundle)bundle, (String)("exportable." + defaultName + ".presentable.name"), (String)defaultName, (Object[])new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"CommonBundle.messageOrDe\u2026table.name\", defaultName)");
        return string;
    }

    @NotNull
    public static final /* synthetic */ String access$getComponentPresentableName(@NotNull State state, @NotNull Class aClass, @Nullable PluginDescriptor pluginDescriptor) {
        return ExportSettingsActionKt.getComponentPresentableName(state, aClass, pluginDescriptor);
    }
}

