/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.HelpSetPath;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.components.ComponentConfig;
import com.intellij.openapi.extensions.PluginId;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PluginNode
implements IdeaPluginDescriptor {
    public static final int STATUS_UNKNOWN = 0;
    public static final int STATUS_INSTALLED = 1;
    public static final int STATUS_MISSING = 2;
    public static final int STATUS_CURRENT = 3;
    public static final int STATUS_NEWEST = 4;
    public static final int STATUS_DOWNLOADED = 5;
    public static final int STATUS_DELETED = 6;
    private PluginId id;
    private String name;
    private String version;
    private String vendor;
    private String description;
    private String sinceBuild;
    private String untilBuild;
    private String changeNotes;
    private String downloads;
    private String category;
    private String size;
    private String vendorEmail;
    private String vendorUrl;
    private String url;
    private long date = Long.MAX_VALUE;
    private List<PluginId> myDependencies;
    private PluginId[] myOptionalDependencies;
    private int myStatus = 0;
    private boolean myLoaded = false;
    private String myDownloadUrl;
    private String myRepositoryName;
    private String myInstalledVersion;
    private boolean myEnabled = true;
    private String myRating;
    private boolean myIncomplete;

    public PluginNode() {
    }

    public PluginNode(PluginId id) {
        this.id = id;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.id == null) {
            this.id = PluginId.getId((String)name);
        }
        this.name = name;
    }

    public void setId(String id) {
        this.id = PluginId.getId((String)id);
    }

    public String getCategory() {
        return this.category;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getChangeNotes() {
        return this.changeNotes;
    }

    public void setChangeNotes(String changeNotes) {
        this.changeNotes = changeNotes;
    }

    public String getSinceBuild() {
        return this.sinceBuild;
    }

    public void setSinceBuild(String sinceBuild) {
        this.sinceBuild = sinceBuild;
    }

    public int getStatus() {
        return this.myStatus;
    }

    public void setStatus(int status2) {
        this.myStatus = status2;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isLoaded() {
        return this.myLoaded;
    }

    public void setLoaded(boolean loaded) {
        this.myLoaded = loaded;
    }

    public String getDownloads() {
        return this.downloads;
    }

    public void setDownloads(String downloads) {
        this.downloads = downloads;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public String getVendorEmail() {
        return this.vendorEmail;
    }

    public void setVendorEmail(String vendorEmail) {
        this.vendorEmail = vendorEmail;
    }

    public String getVendorUrl() {
        return this.vendorUrl;
    }

    public void setVendorUrl(String vendorUrl) {
        this.vendorUrl = vendorUrl;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setDate(String date) {
        this.date = Long.valueOf(date);
    }

    public long getDate() {
        return this.date;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof PluginNode && this.name.equals(((PluginNode)object).getName());
    }

    public List<PluginId> getDepends() {
        return this.myDependencies;
    }

    public void setDepends(List<PluginId> depends, @Nullable PluginId[] optionalDependencies) {
        this.myDependencies = depends;
        this.myOptionalDependencies = optionalDependencies;
    }

    public void addDepends(String id) {
        if (this.myDependencies == null) {
            this.myDependencies = new ArrayList<PluginId>();
        }
        this.myDependencies.add(PluginId.getId((String)id));
    }

    public PluginId getPluginId() {
        return this.id;
    }

    @Nullable
    public ClassLoader getPluginClassLoader() {
        return null;
    }

    @Nullable
    public File getPath() {
        return null;
    }

    @NotNull
    public PluginId[] getDependentPluginIds() {
        if (PluginId.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/PluginNode", "getDependentPluginIds"));
        }
        return PluginId.EMPTY_ARRAY;
    }

    @NotNull
    public PluginId[] getOptionalDependentPluginIds() {
        PluginId[] pluginIdArray = this.myOptionalDependencies != null ? this.myOptionalDependencies : PluginId.EMPTY_ARRAY;
        if (pluginIdArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/plugins/PluginNode", "getOptionalDependentPluginIds"));
        }
        return pluginIdArray;
    }

    @Nullable
    public String getResourceBundleBaseName() {
        return null;
    }

    @Nullable
    public List<Element> getActionsDescriptionElements() {
        return null;
    }

    @NotNull
    public ComponentConfig[] getAppComponents() {
        throw new IllegalStateException();
    }

    @NotNull
    public ComponentConfig[] getProjectComponents() {
        throw new IllegalStateException();
    }

    @NotNull
    public ComponentConfig[] getModuleComponents() {
        throw new IllegalStateException();
    }

    @NotNull
    public HelpSetPath[] getHelpSets() {
        throw new IllegalStateException();
    }

    @Nullable
    public String getVendorLogoPath() {
        return null;
    }

    public boolean getUseIdeaClassLoader() {
        return false;
    }

    public String getUntilBuild() {
        return this.untilBuild;
    }

    public void setUntilBuild(String untilBuild) {
        this.untilBuild = untilBuild;
    }

    public boolean isBundled() {
        return false;
    }

    public boolean allowBundledUpdate() {
        return false;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    @Nullable
    public String getStatusText() {
        switch (this.myStatus) {
            case 0: {
                return "Available";
            }
            case 1: {
                return "Installed";
            }
            case 4: {
                return "Ready to update";
            }
        }
        return null;
    }

    public String getDownloadUrl() {
        return this.myDownloadUrl;
    }

    public void setDownloadUrl(String host) {
        this.myDownloadUrl = host;
    }

    public String getRepositoryName() {
        return this.myRepositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.myRepositoryName = repositoryName;
    }

    public String getInstalledVersion() {
        return this.myInstalledVersion;
    }

    public void setInstalledVersion(String installedVersion) {
        this.myInstalledVersion = installedVersion;
    }

    public String getRating() {
        return this.myRating;
    }

    public void setRating(String rating) {
        this.myRating = rating;
    }

    public boolean isIncomplete() {
        return this.myIncomplete;
    }

    public void setIncomplete(boolean incomplete) {
        this.myIncomplete = incomplete;
    }
}

