/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.search.TodoItem;
import org.jetbrains.annotations.NotNull;

public final class SmartTodoItemPointer {
    private final TodoItem myTodoItem;
    private final Document myDocument;
    private final RangeMarker myRangeMarker;

    public SmartTodoItemPointer(@NotNull TodoItem todoItem, @NotNull Document document2) {
        if (todoItem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "todoItem", "com/intellij/ide/todo/SmartTodoItemPointer", "<init>"));
        }
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/ide/todo/SmartTodoItemPointer", "<init>"));
        }
        this.myTodoItem = todoItem;
        this.myDocument = document2;
        TextRange textRange = this.myTodoItem.getTextRange();
        this.myRangeMarker = document2.createRangeMarker(textRange);
    }

    public TodoItem getTodoItem() {
        return this.myTodoItem;
    }

    public Document getDocument() {
        return this.myDocument;
    }

    public RangeMarker getRangeMarker() {
        return this.myRangeMarker;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SmartTodoItemPointer)) {
            return false;
        }
        SmartTodoItemPointer pointer = (SmartTodoItemPointer)obj;
        return this.myTodoItem.getFile().equals(pointer.myTodoItem.getFile()) && this.myRangeMarker.getStartOffset() == pointer.myRangeMarker.getStartOffset() && this.myRangeMarker.getEndOffset() == pointer.myRangeMarker.getEndOffset() && this.myTodoItem.getPattern().equals((Object)pointer.myTodoItem.getPattern());
    }

    public int hashCode() {
        return this.myTodoItem.getFile().hashCode();
    }
}

